/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import jakarta.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.emf.ui.common.ImageTooltip;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.PartIconDialogEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.objectdata.ObjectViewer;
import org.eclipse.e4.tools.emf.ui.internal.common.uistructure.UIViewer;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractPartEditor<M extends MPart>
extends AbstractComponentEditor<M> {
    private Composite composite;
    private EMFDataBindingContext context;
    private Button createRemoveToolBarButton;
    private StackLayout stackLayout;
    @Inject
    @Optional
    private IProject project;
    @Inject
    private IEclipseContext eclipseContext;

    @Inject
    public AbstractPartEditor() {
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.GENERIC_TILE__HORIZONTAL}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED})};
    }

    @Override
    public String getDetailLabel(Object element) {
        return null;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.requestLayout();
        }
        if (this.createRemoveToolBarButton != null) {
            this.createRemoveToolBarButton.setSelection(((MPart)object).getToolbar() != null);
        }
        return this.composite;
    }

    protected Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue<M> master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 2048);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.elementId(this.getEditingDomain()));
        ControlFactory.createTextField(parent, this.Messages.PartEditor_LabelLabel, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.label(this.getEditingDomain()));
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_UIElement_AccessibilityPhrase, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.accessibilityPhrase(this.getEditingDomain()));
        ControlFactory.createTextField(parent, this.Messages.PartEditor_Tooltip, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.tooltip(this.getEditingDomain()));
        Label l = new Label(parent, 0);
        l.setText(this.Messages.PartEditor_IconURI);
        l.setLayoutData((Object)new GridData());
        l.setToolTipText(this.Messages.PartEditor_IconURI_Tooltip);
        Text t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        t.setLayoutData((Object)new GridData(768));
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.iconUri(this.getEditingDomain()).observeDetail(master));
        new ImageTooltip((Control)t, this.Messages, this);
        final Button b = ControlFactory.createFindButton(parent, this.resourcePool);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartIconDialogEditor dialog = new PartIconDialogEditor(b.getShell(), AbstractPartEditor.this.eclipseContext, AbstractPartEditor.this.project, AbstractPartEditor.this.getEditingDomain(), (MPart)AbstractPartEditor.this.getMaster().getValue(), AbstractPartEditor.this.Messages);
                dialog.open();
            }
        });
        ControlFactory.createClassURIField(parent, this.Messages, this, this.Messages.PartEditor_ClassURI, ApplicationPackageImpl.Literals.CONTRIBUTION__CONTRIBUTION_URI, this.getEditor().getContributionCreator(BasicPackageImpl.Literals.PART), this.project, context, this.eclipseContext);
        ControlFactory.createTextField(parent, this.Messages.PartEditor_ContainerData, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.containerData(this.getEditingDomain()));
        this.createSubformElements(parent, context, (IObservableValue<M>)master);
        l = new Label(parent, 0);
        l.setText(this.Messages.PartEditor_ToolBar);
        l.setLayoutData((Object)new GridData());
        this.createRemoveToolBarButton = new Button(parent, 32);
        this.createRemoveToolBarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MPart window = (MPart)AbstractPartEditor.this.getMaster().getValue();
                if (window.getToolbar() == null) {
                    AbstractPartEditor.this.addToolBar();
                } else {
                    AbstractPartEditor.this.removeToolBar();
                }
            }
        });
        this.createRemoveToolBarButton.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        ControlFactory.createCheckBox(parent, this.Messages.PartEditor_Closeable, this.Messages.PartEditor_Closeable_Tooltip, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.partClosable(this.getEditingDomain()));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_ToBeRendered, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.toBeRendered(this.getEditingDomain()));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_Visible, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.visible(this.getEditingDomain()));
        ControlFactory.createBindingContextWiget(parent, this.Messages, this, this.Messages.PartEditor_BindingContexts);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Context_Properties, (EStructuralFeature)UiPackageImpl.Literals.CONTEXT__PROPERTIES, 10);
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.ModelTooling_Context_Variables, this.Messages.ModelTooling_Context_Variables_Tooltip, (EStructuralFeature)UiPackageImpl.Literals.CONTEXT__VARIABLES, 10);
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        if (this.project == null) {
            this.createInstanceInspection(folder);
            this.createUITreeInspection(folder);
        }
        this.createContributedEditorTabs(folder, context, this.getMaster(), MPart.class);
        folder.setSelection(0);
        return folder;
    }

    protected void createSubformElements(Composite parent, EMFDataBindingContext context, IObservableValue<M> master) {
    }

    protected void addToolBar() {
        MToolBar menu = MMenuFactory.INSTANCE.createToolBar();
        this.setElementId(menu);
        Command cmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)BasicPackageImpl.Literals.PART__TOOLBAR, (Object)menu);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
        }
    }

    protected void removeToolBar() {
        Command cmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)BasicPackageImpl.Literals.PART__TOOLBAR, null);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
        }
    }

    private void createInstanceInspection(CTabFolder folder) {
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_RuntimeContributionInstance);
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout());
        item.setControl((Control)container);
        ObjectViewer objectViewer = new ObjectViewer();
        TreeViewer viewer = objectViewer.createViewer(container, (EStructuralFeature)ApplicationPackageImpl.Literals.CONTRIBUTION__OBJECT, (IObservableValue<?>)this.getMaster(), this.resourcePool, this.Messages);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    private void createUITreeInspection(CTabFolder folder) {
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_RuntimeWidgetTree);
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout());
        item.setControl((Control)container);
        UIViewer objectViewer = new UIViewer();
        TreeViewer viewer = objectViewer.createViewer(container, (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__WIDGET, (IObservableValue<?>)this.getMaster(), this.resourcePool, this.Messages);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        WritableList list = new WritableList();
        MPart part = (MPart)element;
        if (this.getEditor().isModelFragment() && Util.isImport((EObject)element)) {
            return list;
        }
        list.add(new VirtualEntry<MPart, MMenu>("org.eclipse.e4.tools.emf.ui.VIRTUAL_PART_MENU", E4Properties.partMenus(), part, this.Messages.PartEditor_Menus));
        list.add(new VirtualEntry<MPart, MHandler>("org.eclipse.e4.tools.emf.ui.VIRTUAL_HANDLER", E4Properties.handlers(), part, this.Messages.PartEditor_Handlers));
        list.add(new VirtualEntry<MPart, MTrimBar>("org.eclipse.e4.tools.emf.ui.VIRTUAL_PART_TRIMS", E4Properties.partTrimBars(), part, this.Messages.PartEditor_TrimBars));
        if (part.getToolbar() != null) {
            list.add(0, (Object)part.getToolbar());
        }
        E4Properties.partToolbar().observe((Object)part).addValueChangeListener(event -> {
            if (event.diff.getOldValue() != null) {
                list.remove(event.diff.getOldValue());
                if (this.getMaster().getValue() == element && !this.createRemoveToolBarButton.isDisposed()) {
                    this.createRemoveToolBarButton.setSelection(false);
                }
            }
            if (event.diff.getNewValue() != null) {
                list.add(0, event.diff.getNewValue());
                if (this.getMaster().getValue() == element && !this.createRemoveToolBarButton.isDisposed()) {
                    this.createRemoveToolBarButton.setSelection(true);
                }
            }
        });
        this.addChildListEntries(part, (IObservableList<Object>)list);
        return list;
    }

    protected void addChildListEntries(MPart part, IObservableList<Object> list) {
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.context != null) {
            this.context.dispose();
        }
    }
}

