/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;

public class MembersOrderPreferenceCacheCommon {
    public static final String APPEARANCE_MEMBER_SORT_ORDER = "outlinesortoption";
    public static final String APPEARANCE_VISIBILITY_SORT_ORDER = "org.eclipse.jdt.ui.visibility.order";
    public static final String APPEARANCE_ENABLE_VISIBILITY_SORT_ORDER = "org.eclipse.jdt.ui.enable.visibility.order";
    public static final int TYPE_INDEX = 0;
    public static final int CONSTRUCTORS_INDEX = 1;
    public static final int METHOD_INDEX = 2;
    public static final int FIELDS_INDEX = 3;
    public static final int INIT_INDEX = 4;
    public static final int STATIC_FIELDS_INDEX = 5;
    public static final int STATIC_INIT_INDEX = 6;
    public static final int STATIC_METHODS_INDEX = 7;
    public static final int ENUM_CONSTANTS_INDEX = 8;
    public static final int N_CATEGORIES = 9;
    protected static final int PUBLIC_INDEX = 0;
    protected static final int PRIVATE_INDEX = 1;
    protected static final int PROTECTED_INDEX = 2;
    protected static final int DEFAULT_INDEX = 3;
    protected static final int N_VISIBILITIES = 4;
    protected int[] fCategoryOffsets = null;
    protected boolean fSortByVisibility;
    protected int[] fVisibilityOffsets = null;
    private IEclipsePreferences fPreferences = null;
    private IEclipsePreferences fDefaultPreferenceStore = null;

    public void install() {
        this.fPreferences = InstanceScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId());
        this.fDefaultPreferenceStore = DefaultScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId());
        this.fVisibilityOffsets = null;
        boolean defaultValue = this.fDefaultPreferenceStore.getBoolean(APPEARANCE_ENABLE_VISIBILITY_SORT_ORDER, false);
        this.fSortByVisibility = this.fPreferences.getBoolean(APPEARANCE_ENABLE_VISIBILITY_SORT_ORDER, defaultValue);
        JavaManipulationPlugin.getDefault().setMembersOrderPreferenceCacheCommon(this);
    }

    public void dispose() {
        this.fPreferences = null;
        this.fDefaultPreferenceStore = null;
    }

    public static boolean isMemberOrderProperty(String property) {
        return APPEARANCE_MEMBER_SORT_ORDER.equals(property) || APPEARANCE_VISIBILITY_SORT_ORDER.equals(property) || APPEARANCE_ENABLE_VISIBILITY_SORT_ORDER.equals(property);
    }

    public void propertyChange(String property) {
        block13: {
            if (property == null) break block13;
            switch (property) {
                case "outlinesortoption": {
                    this.fCategoryOffsets = null;
                    break;
                }
                case "org.eclipse.jdt.ui.visibility.order": {
                    this.fVisibilityOffsets = null;
                    break;
                }
                case "org.eclipse.jdt.ui.enable.visibility.order": {
                    String key = APPEARANCE_ENABLE_VISIBILITY_SORT_ORDER;
                    boolean defaultValue = this.fDefaultPreferenceStore.getBoolean(key, false);
                    this.fSortByVisibility = this.fPreferences.getBoolean(key, defaultValue);
                    break;
                }
            }
        }
    }

    public int getCategoryIndex(int kind) {
        if (this.fCategoryOffsets == null) {
            this.fCategoryOffsets = this.getCategoryOffsets();
        }
        return this.fCategoryOffsets[kind];
    }

    protected int[] getCategoryOffsets() {
        int[] offsets = new int[9];
        String key = APPEARANCE_MEMBER_SORT_ORDER;
        boolean success = this.fillCategoryOffsetsFromPreferenceString(this.fPreferences.get(key, ""), offsets);
        if (!success) {
            String defaultValue = this.fDefaultPreferenceStore.get(key, "");
            this.fPreferences.put(key, defaultValue);
            this.fillCategoryOffsetsFromPreferenceString(defaultValue, offsets);
        }
        return offsets;
    }

    protected boolean fillCategoryOffsetsFromPreferenceString(String str, int[] offsets) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int i = 0;
        offsets[8] = i++;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token == null) continue;
            switch (token) {
                case "T": {
                    offsets[0] = i++;
                    break;
                }
                case "M": {
                    offsets[2] = i++;
                    break;
                }
                case "F": {
                    offsets[3] = i++;
                    break;
                }
                case "I": {
                    offsets[4] = i++;
                    break;
                }
                case "SF": {
                    offsets[5] = i++;
                    break;
                }
                case "SI": {
                    offsets[6] = i++;
                    break;
                }
                case "SM": {
                    offsets[7] = i++;
                    break;
                }
                case "C": {
                    offsets[1] = i++;
                    break;
                }
            }
        }
        return i == 9;
    }

    public boolean isSortByVisibility() {
        return this.fSortByVisibility;
    }

    public int getVisibilityIndex(int modifierFlags) {
        if (this.fVisibilityOffsets == null) {
            this.fVisibilityOffsets = this.getVisibilityOffsets();
        }
        int kind = 3;
        if (Flags.isPublic((int)modifierFlags)) {
            kind = 0;
        } else if (Flags.isProtected((int)modifierFlags)) {
            kind = 2;
        } else if (Flags.isPrivate((int)modifierFlags)) {
            kind = 1;
        }
        return this.fVisibilityOffsets[kind];
    }

    protected int[] getVisibilityOffsets() {
        int[] offsets = new int[4];
        String key = APPEARANCE_VISIBILITY_SORT_ORDER;
        boolean success = this.fillVisibilityOffsetsFromPreferenceString(this.fPreferences.get(key, ""), offsets);
        if (!success) {
            String defaultValue = this.fDefaultPreferenceStore.get(key, "");
            this.fPreferences.put(key, defaultValue);
            this.fillVisibilityOffsetsFromPreferenceString(defaultValue, offsets);
        }
        return offsets;
    }

    protected boolean fillVisibilityOffsetsFromPreferenceString(String str, int[] offsets) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token == null) continue;
            switch (token) {
                case "B": {
                    offsets[0] = i++;
                    break;
                }
                case "V": {
                    offsets[1] = i++;
                    break;
                }
                case "R": {
                    offsets[2] = i++;
                    break;
                }
                case "D": {
                    offsets[3] = i++;
                    break;
                }
            }
        }
        return i == 4;
    }
}

