/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.compiler;

import com.google.common.hash.HashCode;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.AbstractEObjectDescription;
import org.eclipse.xtext.util.Strings;

class ClassFileEObjectDescription
extends AbstractEObjectDescription {
    private static final String HASH = "#";
    private final URI uri;
    private final HashCode hash;

    ClassFileEObjectDescription(URI uri, HashCode hash) {
        this.uri = uri;
        this.hash = hash;
    }

    public QualifiedName getName() {
        return this.getQualifiedName();
    }

    public QualifiedName getQualifiedName() {
        return QualifiedName.create((List)Strings.split((String)this.uri.fragment(), (char)'.'));
    }

    public EObject getEObjectOrProxy() {
        InternalEObject result = (InternalEObject)EcoreUtil.create((EClass)this.getEClass());
        result.eSetProxyURI(this.getEObjectURI());
        return result;
    }

    public URI getEObjectURI() {
        return this.uri;
    }

    public EClass getEClass() {
        return TypesPackage.Literals.JVM_GENERIC_TYPE;
    }

    public String getUserData(String name) {
        if (HASH.equals(name)) {
            return this.hash.toString();
        }
        return null;
    }

    public String[] getUserDataKeys() {
        return new String[]{HASH};
    }

    public int hashCode() {
        return Objects.hash(this.hash, this.uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ClassFileEObjectDescription other = (ClassFileEObjectDescription)((Object)obj);
        return Objects.equals(this.hash, other.hash) && Objects.equals(this.uri, other.uri);
    }
}

