/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.VarDefinitionsUsesVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class PatternCleanUpCore
extends AbstractMultiFix {
    private static final String STRING_CLASS_NAME = String.class.getCanonicalName();
    private static final String SPLIT_METHOD = "split";
    private static final String REPLACE_FIRST_METHOD = "replaceFirst";
    private static final String REPLACE_ALL_METHOD = "replaceAll";
    private static final String MATCHER_METHOD = "matcher";
    private static final String MATCHES_METHOD = "matches";
    private static final String COMPILE_METHOD = "compile";

    public PatternCleanUpCore() {
        this(Collections.emptyMap());
    }

    public PatternCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.precompile_regex");
        Map<String, String> requiredOptions = null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.precompile_regex")) {
            return new String[]{MultiFixMessages.PatternCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.precompile_regex")) {
            return "Pattern dateCheck= Pattern.compile(\"\\\\d{4}-\\\\d{2}-\\\\d{2}\");\ndateCheck.matcher(\"2020-03-17\").matches();\ndateCheck.matcher(\"2020-03-17\").dateCheckplaceFirst(\"0000-00-00\");\ndateCheck.matcher(\"2020-03-17\").replaceAll(\"0000-00-00\");\ndateCheck.split(\"A2020-03-17B\");\n";
        }
        return "String dateCheck= \"\\\\d{4}-\\\\d{2}-\\\\d{2}\";\n\"2020-03-17\".matches(dateCheck);\n\"2020-03-17\".replaceFirst(dateCheck, \"0000-00-00\");\n\"2020-03-17\".replaceAll(dateCheck, \"0000-00-00\");\n\"A2020-03-17B\".split(dateCheck);\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.precompile_regex")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        final HashMap addedPatternFields = new HashMap();
        unit.accept(new ASTVisitor(){

            public boolean visit(Block node) {
                RegExAndUsesVisitor regExAndUsesVisitor = new RegExAndUsesVisitor(node, rewriteOperations, addedPatternFields);
                node.accept((ASTVisitor)regExAndUsesVisitor);
                return true;
            }

            final class RegExAndUsesVisitor
            extends ASTVisitor {
                private final Block startNode;
                private final /* synthetic */ List val$rewriteOperations;
                private final /* synthetic */ Map val$addedPatternFields;

                public RegExAndUsesVisitor(Block startNode, List list, Map map) {
                    this.val$rewriteOperations = list;
                    this.val$addedPatternFields = map;
                    this.startNode = startNode;
                }

                public boolean visit(Block node) {
                    return this.startNode == node;
                }

                public boolean visit(VariableDeclarationStatement node) {
                    if (node.fragments().size() != 1) {
                        return true;
                    }
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)node.fragments().get(0);
                    return this.visitVariable(node.getType(), fragment.resolveBinding(), fragment.getExtraDimensions(), fragment.getInitializer());
                }

                public boolean visit(VariableDeclarationExpression node) {
                    if (node.fragments().size() != 1) {
                        return true;
                    }
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)node.fragments().get(0);
                    return this.visitVariable(node.getType(), fragment.resolveBinding(), fragment.getExtraDimensions(), fragment.getInitializer());
                }

                public boolean visit(SingleVariableDeclaration node) {
                    return this.visitVariable(node.getType(), node.resolveBinding(), node.getExtraDimensions(), node.getInitializer());
                }

                private boolean visitVariable(Type type, IVariableBinding variableBinding, int extraDimensions, Expression initializer) {
                    if (ASTNodes.hasType(type.resolveBinding(), STRING_CLASS_NAME) && extraDimensions == 0 && initializer != null) {
                        VarDefinitionsUsesVisitor varOccurrencesVisitor = new VarDefinitionsUsesVisitor(variableBinding, (ASTNode)this.startNode, true);
                        List<SimpleName> reads = varOccurrencesVisitor.getReads();
                        List<SimpleName> writes = varOccurrencesVisitor.getWrites();
                        if (writes.size() == 1 && reads.size() > 1) {
                            for (SimpleName simpleName : reads) {
                                if (this.isRegExUse(simpleName, initializer)) continue;
                                return true;
                            }
                            String varName = variableBinding.getName();
                            this.val$rewriteOperations.add(new PatternOperation(type, initializer, reads, varName, this.val$addedPatternFields));
                            return false;
                        }
                    }
                    return true;
                }

                private boolean isRegExUse(SimpleName simpleName, Expression initializer) {
                    if (simpleName.getParent() instanceof MethodInvocation) {
                        MethodInvocation methodInvocation = (MethodInvocation)simpleName.getParent();
                        if (simpleName.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY && !methodInvocation.arguments().isEmpty() && simpleName.equals(methodInvocation.arguments().get(0))) {
                            if (ASTNodes.usesGivenSignature(methodInvocation, STRING_CLASS_NAME, PatternCleanUpCore.MATCHES_METHOD, STRING_CLASS_NAME) || ASTNodes.usesGivenSignature(methodInvocation, STRING_CLASS_NAME, PatternCleanUpCore.REPLACE_ALL_METHOD, STRING_CLASS_NAME, STRING_CLASS_NAME) || ASTNodes.usesGivenSignature(methodInvocation, STRING_CLASS_NAME, PatternCleanUpCore.REPLACE_FIRST_METHOD, STRING_CLASS_NAME, STRING_CLASS_NAME)) {
                                return true;
                            }
                            if (ASTNodes.usesGivenSignature(methodInvocation, STRING_CLASS_NAME, PatternCleanUpCore.SPLIT_METHOD, STRING_CLASS_NAME) || ASTNodes.usesGivenSignature(methodInvocation, STRING_CLASS_NAME, PatternCleanUpCore.SPLIT_METHOD, STRING_CLASS_NAME, Integer.TYPE.getCanonicalName())) {
                                Expression exp;
                                ASTNode aSTNode;
                                Name name;
                                IBinding binding;
                                String value = null;
                                Expression expression = ASTNodes.getUnparenthesedExpression(initializer);
                                if (expression instanceof StringLiteral) {
                                    StringLiteral literal = (StringLiteral)expression;
                                    value = literal.getLiteralValue();
                                } else if (expression instanceof Name && (binding = (name = (Name)expression).resolveBinding()) instanceof IVariableBinding && (aSTNode = ASTNodes.findDeclaration(binding, (ASTNode)this.startNode)) instanceof VariableDeclarationFragment && (exp = ((VariableDeclarationFragment)aSTNode).getInitializer()) != null && (exp = ASTNodes.getUnparenthesedExpression(exp)) instanceof StringLiteral) {
                                    value = ((StringLiteral)exp).getLiteralValue();
                                }
                                if (value != null) {
                                    if (value.length() == 1) {
                                        return ".$|()[{^?*+\\".contains(value);
                                    }
                                    if (value.length() == 2 && value.charAt(0) == '\\') {
                                        return Character.isLetterOrDigit(value.charAt(1));
                                    }
                                }
                                return true;
                            }
                        }
                    }
                    return false;
                }
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.PatternCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class PatternOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final Type type;
        private final Expression initializer;
        private final List<SimpleName> regExUses;
        private final String varName;
        private final Map<ASTNode, Set<String>> addedPatternFields;

        public PatternOperation(Type type, Expression initializer, List<SimpleName> regExUses, String varName, Map<ASTNode, Set<String>> addedPatternFields) {
            this.type = type;
            this.initializer = initializer;
            this.regExUses = regExUses;
            this.varName = varName;
            this.addedPatternFields = addedPatternFields;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            boolean isInNonStaticInnerClass;
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            TextEditGroup group = this.createTextEditGroup(FixMessages.PatternFix_convert_string_to_pattern_object, cuRewrite);
            String patternNameText = importRewrite.addImport(Pattern.class.getCanonicalName());
            SimpleType replacement = ast.newSimpleType(ASTNodeFactory.newName(ast, patternNameText));
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.type, (ASTNode)replacement, group);
            Expression unparanthesedInitializer = ASTNodes.getUnparenthesedExpression(this.initializer);
            MethodInvocation newCompileMethod = ast.newMethodInvocation();
            newCompileMethod.setExpression((Expression)ASTNodeFactory.newName(ast, patternNameText));
            newCompileMethod.setName(ast.newSimpleName(PatternCleanUpCore.COMPILE_METHOD));
            newCompileMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, unparanthesedInitializer));
            boolean isInStaticInitializer = ASTNodes.getFirstAncestorOrNull((ASTNode)this.initializer, Initializer.class) != null;
            ASTNode typeDecl = ASTNodes.getFirstAncestorOrNull((ASTNode)this.initializer, TypeDeclaration.class, RecordDeclaration.class);
            boolean isInInterface = typeDecl instanceof TypeDeclaration && ((TypeDeclaration)typeDecl).isInterface();
            boolean isInLocalType = typeDecl instanceof AbstractTypeDeclaration && ((AbstractTypeDeclaration)typeDecl).isLocalTypeDeclaration();
            boolean bl = isInNonStaticInnerClass = typeDecl instanceof AbstractTypeDeclaration && ((AbstractTypeDeclaration)typeDecl).isMemberTypeDeclaration() && (((AbstractTypeDeclaration)typeDecl).getModifiers() & 8) != 8;
            if (unparanthesedInitializer instanceof StringLiteral && typeDecl instanceof AbstractTypeDeclaration && !isInStaticInitializer && !isInInterface && !isInLocalType && !isInNonStaticInnerClass) {
                VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
                Set<String> addedFields = this.addedPatternFields.get(typeDecl);
                if (addedFields == null) {
                    addedFields = new HashSet<String>();
                    this.addedPatternFields.put(typeDecl, addedFields);
                }
                String newFieldName = this.getUniqueFieldName(addedFields);
                newFragment.setName(ast.newSimpleName(newFieldName));
                newFragment.setInitializer((Expression)newCompileMethod);
                FieldDeclaration newFieldDeclaration = ast.newFieldDeclaration(newFragment);
                newFieldDeclaration.setType((Type)ast.newSimpleType(ASTNodeFactory.newName(ast, patternNameText)));
                newFieldDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(ast, 26));
                int insertionIndex = this.findInsertionIndex((AbstractTypeDeclaration)typeDecl);
                int addedFieldCount = addedFields.size();
                rewrite.getListRewrite(typeDecl, ASTNodes.getBodyDeclarationsProperty(typeDecl)).insertAt((ASTNode)newFieldDeclaration, insertionIndex + addedFieldCount, group);
                addedFields.add(newFieldName);
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.initializer, (ASTNode)ast.newSimpleName(newFieldName), group);
            } else {
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.initializer, (ASTNode)newCompileMethod, group);
            }
            for (SimpleName oldRegExUse : this.regExUses) {
                MethodInvocation oldMethodInvocation = (MethodInvocation)oldRegExUse.getParent();
                MethodInvocation newMethod = ast.newMethodInvocation();
                newMethod.setExpression((Expression)ASTNodes.createMoveTarget(rewrite, oldRegExUse));
                if (ASTNodes.usesGivenSignature(oldMethodInvocation, STRING_CLASS_NAME, PatternCleanUpCore.SPLIT_METHOD, STRING_CLASS_NAME)) {
                    newMethod.setName(ast.newSimpleName(PatternCleanUpCore.SPLIT_METHOD));
                    newMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(oldMethodInvocation.getExpression())));
                } else if (ASTNodes.usesGivenSignature(oldMethodInvocation, STRING_CLASS_NAME, PatternCleanUpCore.SPLIT_METHOD, STRING_CLASS_NAME, Integer.TYPE.getCanonicalName())) {
                    newMethod.setName(ast.newSimpleName(PatternCleanUpCore.SPLIT_METHOD));
                    newMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(oldMethodInvocation.getExpression())));
                    newMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression((Expression)oldMethodInvocation.arguments().get(1))));
                } else {
                    MethodInvocation newMatcherExpression = newMethod;
                    newMethod = ast.newMethodInvocation();
                    if (ASTNodes.usesGivenSignature(oldMethodInvocation, STRING_CLASS_NAME, PatternCleanUpCore.MATCHES_METHOD, STRING_CLASS_NAME)) {
                        newMethod.setName(ast.newSimpleName(PatternCleanUpCore.MATCHES_METHOD));
                    } else if (ASTNodes.usesGivenSignature(oldMethodInvocation, STRING_CLASS_NAME, PatternCleanUpCore.REPLACE_ALL_METHOD, STRING_CLASS_NAME, STRING_CLASS_NAME)) {
                        newMethod.setName(ast.newSimpleName(PatternCleanUpCore.REPLACE_ALL_METHOD));
                        newMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression((Expression)oldMethodInvocation.arguments().get(1))));
                    } else if (ASTNodes.usesGivenSignature(oldMethodInvocation, STRING_CLASS_NAME, PatternCleanUpCore.REPLACE_FIRST_METHOD, STRING_CLASS_NAME, STRING_CLASS_NAME)) {
                        newMethod.setName(ast.newSimpleName(PatternCleanUpCore.REPLACE_FIRST_METHOD));
                        newMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression((Expression)oldMethodInvocation.arguments().get(1))));
                    }
                    newMatcherExpression.setName(ast.newSimpleName(PatternCleanUpCore.MATCHER_METHOD));
                    newMatcherExpression.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(oldMethodInvocation.getExpression())));
                    newMethod.setExpression((Expression)newMatcherExpression);
                }
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)oldMethodInvocation, (ASTNode)newMethod, group);
            }
        }

        private String getUniqueFieldName(Set<String> usedPatternNames) {
            String newPatternName;
            List<String> usedNames = this.getVisibleVariablesInScope((ASTNode)this.initializer);
            String newName = newPatternName = this.varName + "_pattern";
            int i = 2;
            boolean finished = false;
            block0: while (!finished) {
                finished = true;
                for (String usedName : usedNames) {
                    if (!usedName.equals(newName)) continue;
                    newName = newPatternName + i++;
                    finished = false;
                    break;
                }
                for (String patternName : usedPatternNames) {
                    if (!patternName.equals(newName)) continue;
                    newName = newPatternName + i++;
                    finished = false;
                    continue block0;
                }
            }
            return newName;
        }

        private List<String> getVisibleVariablesInScope(ASTNode node) {
            IBinding[] bindings;
            ArrayList<String> variableNames = new ArrayList<String>();
            CompilationUnit root = (CompilationUnit)node.getRoot();
            IBinding[] iBindingArray = bindings = new ScopeAnalyzer(root).getDeclarationsInScope(node.getStartPosition(), 18);
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding binding = iBindingArray[n2];
                variableNames.add(binding.getName());
                ++n2;
            }
            return variableNames;
        }

        private int findInsertionIndex(AbstractTypeDeclaration typeDecl) {
            List decls = typeDecl.bodyDeclarations();
            boolean finished = false;
            BodyDeclaration bodyDecl = (BodyDeclaration)ASTNodes.getFirstAncestorOrNull((ASTNode)this.initializer, MethodDeclaration.class, FieldDeclaration.class);
            while (!finished) {
                int i = 0;
                while (i < decls.size()) {
                    if (((BodyDeclaration)decls.get(i)).equals((Object)bodyDecl)) {
                        return i;
                    }
                    ++i;
                }
                if ((bodyDecl = (BodyDeclaration)ASTNodes.getFirstAncestorOrNull((ASTNode)bodyDecl, MethodDeclaration.class, FieldDeclaration.class)) != null) continue;
                finished = true;
            }
            return 0;
        }
    }
}

