/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.rangeonrange;

import java.io.IOException;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.rangeonrange.LongRange;
import org.apache.lucene.facet.rangeonrange.Range;
import org.apache.lucene.facet.rangeonrange.RangeOnRangeFacetCounts;
import org.apache.lucene.search.Query;

public class LongRangeOnRangeFacetCounts
extends RangeOnRangeFacetCounts {
    public LongRangeOnRangeFacetCounts(String field, FacetsCollector hits, RangeFieldQuery.QueryType queryType, LongRange ... ranges) throws IOException {
        super(field, hits, queryType, null, 8, LongRangeOnRangeFacetCounts.getEncodedRanges(ranges), Range.getLabelsFromRanges(ranges));
    }

    public LongRangeOnRangeFacetCounts(String field, FacetsCollector hits, RangeFieldQuery.QueryType queryType, Query fastMatchQuery, LongRange ... ranges) throws IOException {
        super(field, hits, queryType, fastMatchQuery, 8, LongRangeOnRangeFacetCounts.getEncodedRanges(ranges), Range.getLabelsFromRanges(ranges));
    }

    private static byte[][] getEncodedRanges(LongRange ... ranges) {
        byte[][] result = new byte[ranges.length][16 * ranges[0].dims];
        for (int i = 0; i < ranges.length; ++i) {
            org.apache.lucene.document.LongRange.verifyAndEncode((long[])ranges[i].min, (long[])ranges[i].max, (byte[])result[i]);
        }
        return result;
    }
}

