/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.LineIndentInfo;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class CloseTagCodeAction
implements ICodeActionParticipant {
    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        Diagnostic diagnostic = request.getDiagnostic();
        DOMDocument document = request.getDocument();
        Range diagnosticRange = diagnostic.getRange();
        try {
            int startOffset = document.offsetAt(diagnosticRange.getStart()) + 1;
            DOMNode node = document.findNodeAt(startOffset);
            if (node == null || !node.isElement()) {
                return;
            }
            DOMElement element = (DOMElement)node;
            if (element.hasEndTag() && !element.isEndTagClosed() && element.hasTagName()) {
                this.doCodeActionsForEndTagUnclosed(element, document, diagnostic, codeActions);
            } else {
                boolean startTagClosed = element.isStartTagClosed();
                if (!startTagClosed) {
                    this.doCodeActionsForStartTagUnclosed(element, document, diagnosticRange, diagnostic, codeActions);
                } else {
                    this.doCodeActionsForStartTagClosed(element, document, diagnosticRange, diagnostic, codeActions);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void doCodeActionsForEndTagUnclosed(DOMElement element, DOMDocument document, Diagnostic diagnostic, List<CodeAction> codeActions) throws BadLocationException {
        Position endTagPosition = document.positionAt(element.getEndTagOpenOffset() + 2 + element.getTagName().length());
        CodeAction autoCloseAction = CodeActionFactory.insert("Close end-tag with '>'", endTagPosition, ">", document.getTextDocument(), diagnostic);
        codeActions.add(autoCloseAction);
    }

    private void doCodeActionsForStartTagUnclosed(DOMElement element, DOMDocument document, Range diagnosticRange, Diagnostic diagnostic, List<CodeAction> codeActions) throws BadLocationException {
        String text = document.getText();
        int closeAngleBracketOffset = element.getUnclosedStartTagCloseOffset();
        Position closeAngleBracketPosition = document.positionAt(closeAngleBracketOffset);
        if (!element.hasEndTag()) {
            boolean hasSlash = CloseTagCodeAction.isCharAt(text, closeAngleBracketOffset - 1, '/');
            if (hasSlash) {
                CodeAction autoCloseAction = CloseTagCodeAction.insertGreaterThanCharacterCodeAction(document, diagnostic, closeAngleBracketPosition);
                codeActions.add(autoCloseAction);
            } else {
                String tagName = element.getTagName();
                if (tagName != null) {
                    CodeAction autoCloseAction = CodeActionFactory.insert("Close with '/>'", closeAngleBracketPosition, "/>", document.getTextDocument(), diagnostic);
                    codeActions.add(autoCloseAction);
                    String insertText = "></" + tagName + ">";
                    CodeAction closeEndTagAction = CodeActionFactory.insert("Close with '" + insertText + "'", closeAngleBracketPosition, insertText, document.getTextDocument(), diagnostic);
                    codeActions.add(closeEndTagAction);
                }
            }
        } else {
            CodeAction autoCloseAction = CloseTagCodeAction.insertGreaterThanCharacterCodeAction(document, diagnostic, closeAngleBracketPosition);
            codeActions.add(autoCloseAction);
        }
    }

    private void doCodeActionsForStartTagClosed(DOMElement element, DOMDocument document, Range diagnosticRange, Diagnostic diagnostic, List<CodeAction> codeActions) throws BadLocationException {
        block7: {
            block5: {
                String label;
                String tagName;
                String text;
                block6: {
                    text = document.getText();
                    if (element.hasEndTag()) break block5;
                    tagName = element.getTagName();
                    if (element.hasChildNodes()) break block6;
                    String insertText = "</" + tagName + ">";
                    int endOffset = element.getStartTagCloseOffset() + 1;
                    Position endPosition = document.positionAt(endOffset);
                    CodeAction closeEndTagAction = CodeActionFactory.insert("Close with '" + insertText + "'", endPosition, insertText, document.getTextDocument(), diagnostic);
                    codeActions.add(closeEndTagAction);
                    break block7;
                }
                boolean hasChildWithNoTagName = false;
                List<DOMNode> children = element.getChildren();
                for (DOMNode child : children) {
                    DOMElement childElement;
                    if (!child.isElement() || (childElement = (DOMElement)child).hasTagName() && !childElement.isOrphanEndTag()) continue;
                    String replaceTagName = element.getTagName();
                    CodeAction replaceTagAction = CloseTagCodeAction.replaceEndTagNameCodeAction(childElement, replaceTagName, diagnostic);
                    codeActions.add(replaceTagAction);
                    hasChildWithNoTagName = !childElement.hasTagName();
                }
                if (hasChildWithNoTagName) break block7;
                int endOffset = element.getLastChild().getEnd() - 1;
                if (endOffset < text.length()) {
                    char ch = text.charAt(endOffset);
                    while (Character.isWhitespace(ch)) {
                        ch = text.charAt(--endOffset);
                    }
                }
                ++endOffset;
                String insertText = label = "</" + tagName + ">";
                if (CloseTagCodeAction.hasElements(element)) {
                    LineIndentInfo indentInfo = document.getLineIndentInfo(diagnosticRange.getStart().getLine());
                    insertText = indentInfo.getLineDelimiter() + indentInfo.getWhitespacesIndent() + insertText;
                }
                Position endPosition = document.positionAt(endOffset);
                CodeAction closeEndTagAction = CodeActionFactory.insert("Close with '" + label + "'", endPosition, insertText, document.getTextDocument(), diagnostic);
                codeActions.add(closeEndTagAction);
                break block7;
            }
            List<DOMNode> children = element.getChildren();
            for (DOMNode child : children) {
                DOMElement childElement;
                if (!child.isElement() || (childElement = (DOMElement)child).hasTagName() && !childElement.isOrphanEndTag()) continue;
                CodeAction removeAction = CloseTagCodeAction.removeTagCodeAction(childElement, document, diagnostic);
                codeActions.add(removeAction);
            }
        }
    }

    private static CodeAction insertGreaterThanCharacterCodeAction(DOMDocument document, Diagnostic diagnostic, Position position) {
        CodeAction autoCloseAction = CodeActionFactory.insert("Close with '>'", position, ">", document.getTextDocument(), diagnostic);
        return autoCloseAction;
    }

    private static CodeAction removeTagCodeAction(DOMElement element, DOMDocument document, Diagnostic diagnostic) throws BadLocationException {
        String text = document.getText();
        Position startPosition = document.positionAt(element.getStart());
        Position endPosition = document.positionAt(element.getEnd());
        String contentToRemove = text.substring(element.getStart(), element.getEnd());
        CodeAction removeAction = CodeActionFactory.remove("Remove '" + contentToRemove + "'", new Range(startPosition, endPosition), document.getTextDocument(), diagnostic);
        return removeAction;
    }

    private static CodeAction replaceEndTagNameCodeAction(DOMElement element, String replaceTagName, Diagnostic diagnostic) {
        DOMDocument document = element.getOwnerDocument();
        Range replaceRange = XMLPositionUtility.selectEndTagName(element);
        String tagName = element.getTagName();
        if (tagName == null) {
            tagName = "</";
        }
        Object replaceText = replaceTagName;
        if (!element.isEndTagClosed()) {
            replaceText = (String)replaceText + ">";
        }
        return CodeActionFactory.replace("Replace '" + tagName + "' with '" + replaceTagName + "' closing tag", replaceRange, (String)replaceText, document.getTextDocument(), diagnostic);
    }

    private static boolean hasElements(DOMElement element) {
        for (DOMNode node : element.getChildren()) {
            if (!node.isElement()) continue;
            return true;
        }
        return false;
    }

    private static boolean isCharAt(String text, int offset, char ch) {
        if (text.length() <= offset) {
            return false;
        }
        return text.charAt(offset) == ch;
    }
}

