/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.guiutils;

import java.util.Properties;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.SWTUtils;
import org.eclipse.jst.jsf.common.ui.internal.utils.FavoriteConfigurations;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class FavoriteSection {
    private FavoriteConfigurations _favorites;
    private Combo _favoriteCombo;

    public FavoriteSection(AbstractUIPlugin plugin, String favoriteName) {
        this._favorites = new FavoriteConfigurations(plugin, favoriteName);
    }

    public Combo createFavoriteGroup(Composite parent, int horizontalSpan, int comboMinWidth) {
        Group favGroup = SWTUtils.createGroup(parent, JSFUICommonPlugin.getResourceString("favorites.group.label"), 4, horizontalSpan, 3);
        SWTUtils.createLabel((Composite)favGroup, JSFUICommonPlugin.getResourceString("favorites.label"), 1);
        this._favoriteCombo = SWTUtils.createCombo((Composite)favGroup, this._favorites.getFavoritesList(), 1, comboMinWidth, true);
        this._favoriteCombo.setToolTipText(JSFUICommonPlugin.getResourceString("favorites.tooltip"));
        this._favoriteCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Properties favProp;
                String favName = FavoriteSection.this._favoriteCombo.getText().trim();
                if (favName.length() > 0 && (favProp = FavoriteSection.this._favorites.getFavorite(FavoriteSection.this._favoriteCombo.getText().trim())) != null) {
                    FavoriteSection.this.setFavorites(favProp);
                }
            }
        });
        Button saveButton = SWTUtils.createPushButton((Composite)favGroup, JSFUICommonPlugin.getResourceString("button.save"));
        saveButton.setToolTipText(JSFUICommonPlugin.getResourceString("favorites.save.tooltip"));
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String favName = FavoriteSection.this._favoriteCombo.getText().trim();
                if (favName.length() == 0) {
                    favName = JSFUICommonPlugin.getResourceString("favorites.default");
                }
                Properties favProp = new Properties();
                FavoriteSection.this.saveFavorites(favProp);
                FavoriteSection.this._favorites.addFavorite(favName, favProp);
                FavoriteSection.this._favorites.saveFavorites();
                FavoriteSection.this._favoriteCombo.removeAll();
                String[] names = FavoriteSection.this._favorites.getFavoritesList();
                FavoriteSection.this._favoriteCombo.setItems(names);
                FavoriteSection.this._favoriteCombo.setText(favName);
            }
        });
        Button removeButton = SWTUtils.createPushButton((Composite)favGroup, JSFUICommonPlugin.getResourceString("button.remove"));
        removeButton.setToolTipText(JSFUICommonPlugin.getResourceString("favorites.remove.tooltip"));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String favName = FavoriteSection.this._favoriteCombo.getText().trim();
                if (favName.length() > 0) {
                    FavoriteSection.this._favorites.removeFavorite(favName);
                    FavoriteSection.this._favorites.saveFavorites();
                    FavoriteSection.this.removeFavorites();
                    FavoriteSection.this._favoriteCombo.removeAll();
                    String[] names = FavoriteSection.this._favorites.getFavoritesList();
                    FavoriteSection.this._favoriteCombo.setItems(names);
                }
            }
        });
        return this._favoriteCombo;
    }

    public abstract void setFavorites(Properties var1);

    public abstract void saveFavorites(Properties var1);

    public void removeFavorites() {
    }
}

