/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.diagnostics.DiagnosticsResult;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class XMLDiagnostics {
    private final XMLExtensionsRegistry extensionsRegistry;
    private static final Logger LOGGER = Logger.getLogger(XMLDiagnostics.class.getName());

    public XMLDiagnostics(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public DiagnosticsResult doDiagnostics(DOMDocument xmlDocument, XMLValidationSettings validationSettings, Map<String, Object> validationArgs, CancelChecker cancelChecker) {
        if (validationSettings != null && !validationSettings.isEnabled()) {
            return DiagnosticsResult.EMPTY;
        }
        DiagnosticsResult diagnostics = new DiagnosticsResult(validationArgs);
        this.doExtensionsDiagnostics(xmlDocument, diagnostics, validationSettings, validationArgs, cancelChecker);
        return diagnostics;
    }

    private void doExtensionsDiagnostics(DOMDocument xmlDocument, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, Map<String, Object> validationArgs, CancelChecker monitor) {
        for (IDiagnosticsParticipant diagnosticsParticipant : this.extensionsRegistry.getDiagnosticsParticipants()) {
            monitor.checkCanceled();
            try {
                diagnosticsParticipant.doDiagnostics(xmlDocument, diagnostics, validationSettings, monitor);
            }
            catch (CancellationException | CacheResourceDownloadingException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while processing diagnostics for the participant '" + diagnosticsParticipant.getClass().getName() + "'.", e);
            }
        }
    }
}

