/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.configurationservice;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.set.basis.constants.ToolboxConstants;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.configurationservice.UserConfigurationService;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class UserConfigurationServiceImpl
implements UserConfigurationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserConfigurationServiceImpl.class);
    private static final String FILENAME = "configuration.json";
    protected final ObjectMapper mapper = new ObjectMapper();
    protected UserConfiguration configuration;

    protected static File getFile() {
        return Paths.get(ToolboxConstants.TMP_BASE_DIR, FILENAME).toAbsolutePath().toFile();
    }

    protected UserConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void setConfiguration(UserConfiguration configuration) {
        this.configuration = configuration;
    }

    public UserConfigurationServiceImpl() {
        this.loadConfiguration();
        Services.setUserConfigurationService((UserConfigurationService)this);
    }

    protected void loadConfiguration() {
        if (this.configuration != null) {
            return;
        }
        File configurationFile = UserConfigurationServiceImpl.getFile();
        if (!configurationFile.exists()) {
            this.configuration = new UserConfiguration();
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = Files.newBufferedReader(configurationFile.toPath());){
                ObjectReader objectReader = this.mapper.readerFor((TypeReference)new TypeReference<UserConfiguration>(){});
                this.configuration = (UserConfiguration)objectReader.readValue(configurationFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.configuration = new UserConfiguration();
        }
    }

    protected void saveConfiguration() {
        File configurationFile = UserConfigurationServiceImpl.getFile();
        if (!configurationFile.exists()) {
            if (!configurationFile.getParentFile().exists()) {
                configurationFile.getParentFile().mkdirs();
            }
            try {
                if (!configurationFile.createNewFile()) {
                    LOGGER.error("Cannot write to file {}", (Object)FILENAME);
                    return;
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot write to file {}", (Object)FILENAME);
                return;
            }
        }
        try {
            this.mapper.writerWithDefaultPrettyPrinter().writeValue(configurationFile, (Object)this.configuration);
        }
        catch (IOException e) {
            LOGGER.error("Cannot save user configuration");
        }
    }

    public Set<String> getKnownVersions() throws IOException {
        if (this.configuration.versions == null) {
            this.configuration.versions = new HashSet<String>();
        }
        return this.configuration.versions;
    }

    public void addKnownVersions(String version) throws IOException {
        this.configuration.versions.add(version);
        this.saveConfiguration();
    }

    public void setLastFileOpenPath(Path path) {
        this.configuration.lastFileOpenPath = path;
        this.saveConfiguration();
    }

    public void setLastExportPath(Path path) {
        this.configuration.lastFileExportPath = path.toFile().isFile() ? path.getParent() : path;
        this.saveConfiguration();
    }

    public Optional<Path> getLastFileOpenPath() {
        return Optional.ofNullable(this.configuration.lastFileOpenPath);
    }

    public Path getLastExportPath() {
        if (this.configuration.lastFileExportPath == null) {
            return ToolboxConfiguration.getDefaultPath();
        }
        return this.configuration.lastFileExportPath;
    }

    protected static class UserConfiguration {
        public Set<String> versions = new HashSet<String>();
        public Path lastFileOpenPath;
        public Path lastFileExportPath;
        @JsonAnyGetter
        @JsonAnySetter
        private final Map<String, Object> extraValues = new LinkedHashMap<String, Object>();

        protected UserConfiguration() {
        }
    }
}

