/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize.command;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;

public class MultiColumnResizeCommandHandler
extends AbstractLayerCommandHandler<MultiColumnResizeCommand> {
    private final DataLayer dataLayer;

    public MultiColumnResizeCommandHandler(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public Class<MultiColumnResizeCommand> getCommandClass() {
        return MultiColumnResizeCommand.class;
    }

    @Override
    protected boolean doCommand(MultiColumnResizeCommand command) {
        int[] columnPositions;
        int[] nArray = columnPositions = command.getColumnPositionsArray();
        int n = columnPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int columnPosition = nArray[n2];
            int newColumnWidth = command.downScaleValue() ? this.dataLayer.downScaleColumnWidth(command.getColumnWidth(columnPosition)) : command.getColumnWidth(columnPosition);
            this.dataLayer.setColumnWidthByPosition(columnPosition, newColumnWidth, false);
            ++n2;
        }
        List<Range> ranges = PositionUtil.getRanges(columnPositions);
        for (Range range : ranges) {
            this.dataLayer.fireLayerEvent(new ColumnResizeEvent((ILayer)this.dataLayer, range));
        }
        return true;
    }
}

