/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl.siteplan;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class SiteplanXSLExtension {

    public static final class FoldingMark
    extends Record {
        private final RegionPosition position;
        private final List<Double> distances;
        private final double extent;
        private final double markWidth;
        public static final double DEFAULT_EXTENT_TOP_BOTTOM_RIGHT = 10.0;
        public static final double DEFAULT_EXTENT_LEFT = 20.0;
        public static final double DEFAULT_MARK_WIDTH = 5.0;

        public FoldingMark(RegionPosition position, List<Double> distances, double extent, double markWidth) {
            this.position = position;
            this.distances = distances;
            this.extent = extent;
            this.markWidth = markWidth;
        }

        public FoldingMark(RegionPosition position, double ... distance) {
            LinkedList<Double> linkedList = new LinkedList<Double>(Arrays.stream(distance).boxed().toList());
            this(position, linkedList, switch (position) {
                case RegionPosition.START -> 20.0;
                default -> 10.0;
            }, 5.0);
        }

        public RegionPosition position() {
            return this.position;
        }

        public List<Double> distances() {
            return this.distances;
        }

        public double extent() {
            return this.extent;
        }

        public double markWidth() {
            return this.markWidth;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FoldingMark.class, "position;distances;extent;markWidth", "position", "distances", "extent", "markWidth"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FoldingMark.class, "position;distances;extent;markWidth", "position", "distances", "extent", "markWidth"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FoldingMark.class, "position;distances;extent;markWidth", "position", "distances", "extent", "markWidth"}, this, object);
        }
    }

    public static enum PageDIN {
        A3("A3", 420.0, 297.0),
        A2("A2", 594.0, 420.0),
        A1("A1", 841.0, 594.0),
        A0("A0", 1189.0, 841.0);

        private final double pageWidth;
        private final double pageHeight;
        private final String pageDIN;

        private PageDIN(String din, double width, double height) {
            this.pageHeight = height;
            this.pageWidth = width;
            this.pageDIN = din;
        }

        public double getPageWidth() {
            return this.pageWidth;
        }

        public double getPageHeight() {
            return this.pageHeight;
        }

        public String toString() {
            return this.pageDIN;
        }
    }

    public record RegionBody(double width, double height) {
    }

    public static enum RegionPosition {
        BEFORE("region-before"),
        AFTER("region-after"),
        START("region-start"),
        END("region-end"),
        BODY("region-body");

        private final String regionName;

        private RegionPosition(String name) {
            this.regionName = name;
        }

        public String getRegionTag() {
            return "fo:" + this.regionName;
        }

        public String getRegionName() {
            return this.regionName;
        }
    }

    public record SignificantInformation(double width, double height) {
        private static final double DEFAULT_HEIGHT = 10.0;

        public SignificantInformation(double width) {
            this(width, 10.0);
        }
    }

    public record TitleBoxRegion(RegionPosition position, double extent, double freefeldSize) {
        public static final double TITLEBOX_WIDTH = 180.0;
        public static final double TITLEBOX_HEIGHT = 75.0;
    }
}

