/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.overviewplan.track;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.feature.overviewplan.track.CyclePath;
import org.eclipse.set.feature.overviewplan.track.TOPKanteMetaData;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.utils.graph.AsDirectedTopGraph;
import org.eclipse.set.utils.math.IntegerExtensions;
import org.jgrapht.alg.shortestpath.AllDirectedPaths;
import org.jgrapht.graph.DirectedPseudograph;
import org.jgrapht.graph.builder.GraphBuilder;

public class TopKanteDirectedGraph {
    DirectedPseudograph<TOP_Knoten, AsDirectedTopGraph.DirectedTOPEdge<TOPKanteMetaData>> graph = new DirectedPseudograph(AsDirectedTopGraph.DirectedTOPEdge.class);

    public void addEdge(TOPKanteMetaData md, boolean inPathDirection) {
        this.graph.addVertex((Object)md.getTopNodeA());
        this.graph.addVertex((Object)md.getTopNodeB());
        this.graph.addEdge((Object)md.getTopNodeA(), (Object)md.getTopNodeB(), (Object)new AsDirectedTopGraph.DirectedTOPEdge((Object)md, inPathDirection));
        this.graph.addEdge((Object)md.getTopNodeA(), (Object)md.getTopNodeB(), (Object)new AsDirectedTopGraph.DirectedTOPEdge((Object)md, !inPathDirection));
    }

    public void addEdge(TOPKanteMetaData md) {
        this.graph.addVertex((Object)md.getTopNodeA());
        this.graph.addVertex((Object)md.getTopNodeB());
        this.graph.addEdge((Object)md.getTopNodeA(), (Object)md.getTopNodeB(), (Object)new AsDirectedTopGraph.DirectedTOPEdge((Object)md, true));
        this.graph.addEdge((Object)md.getTopNodeB(), (Object)md.getTopNodeA(), (Object)new AsDirectedTopGraph.DirectedTOPEdge((Object)md, false));
    }

    public List<CyclePath> findAllCyclePaths(TOPKanteMetaData edge) {
        if (!edge.getCyclePaths().isEmpty()) {
            return edge.getCyclePaths();
        }
        TOP_Knoten from = edge.getTopNodeA();
        TOP_Knoten to = edge.getTopNodeB();
        AllDirectedPaths allDirectedPaths = new AllDirectedPaths(this.cloneGraph(edge));
        ArrayList<CyclePath> result = new ArrayList<CyclePath>();
        List paths = allDirectedPaths.getAllPaths((Object)from, (Object)to, true, null);
        paths.forEach(path -> {
            LinkedList<AsDirectedTopGraph.DirectedTOPEdge<TOPKanteMetaData>> edgesList = new LinkedList<AsDirectedTopGraph.DirectedTOPEdge<TOPKanteMetaData>>();
            AsDirectedTopGraph.DirectedTOPEdge firstEdge = (AsDirectedTopGraph.DirectedTOPEdge)this.graph.getEdge((Object)from, (Object)to);
            edgesList.add(firstEdge);
            boolean direction = firstEdge.inTopDirection();
            int i = 0;
            while (i < path.getEdgeList().size()) {
                AsDirectedTopGraph.DirectedTOPEdge nextEdge = (AsDirectedTopGraph.DirectedTOPEdge)path.getEdgeList().get(i);
                if (((TOPKanteMetaData)firstEdge.edge()).isSameDirection((TOPKanteMetaData)nextEdge.edge())) {
                    edgesList.add((AsDirectedTopGraph.DirectedTOPEdge<TOPKanteMetaData>)new AsDirectedTopGraph.DirectedTOPEdge((Object)((TOPKanteMetaData)nextEdge.edge()), direction));
                } else {
                    edgesList.add((AsDirectedTopGraph.DirectedTOPEdge<TOPKanteMetaData>)new AsDirectedTopGraph.DirectedTOPEdge((Object)((TOPKanteMetaData)nextEdge.edge()), !direction));
                    direction = !direction;
                }
                firstEdge = nextEdge;
                ++i;
            }
            result.add(new CyclePath(edgesList));
        });
        return result;
    }

    public void findTopKanteLength(TOPKanteMetaData md) {
        List<CyclePath> allPathsBetween = this.findAllCyclePaths(md);
        if (allPathsBetween.isEmpty()) {
            md.setLength(1);
            return;
        }
        allPathsBetween.sort((p1, p2) -> Integer.compare(p1.getOpositeDirectionEdge().size(), p2.getOpositeDirectionEdge().size()));
        allPathsBetween.forEach(path -> {
            MachtTopEdgeLength matchLength = TopKanteDirectedGraph.isMatchLength(path);
            while (!matchLength.isMatch) {
                this.setTopKanteLength(matchLength.notMatchEdges(), matchLength.differentLength);
                matchLength = TopKanteDirectedGraph.isMatchLength(path);
            }
            path.getEdges().forEach(edge -> {
                if (!((TOPKanteMetaData)edge.edge()).alreadyRegistedLength()) {
                    ((TOPKanteMetaData)edge.edge()).setLength(1);
                }
            });
        });
    }

    private void setTopKanteLength(List<TOPKanteMetaData> edges, int different) {
        List<TOPKanteMetaData> notRegisterLengthEdges = edges.stream().filter(edge -> !edge.alreadyRegistedLength()).toList();
        List<TOPKanteMetaData> shouldUpdateLengthEdges = notRegisterLengthEdges.isEmpty() ? edges : notRegisterLengthEdges;
        TOPKanteMetaData matchEdge = this.getRelevantEdge(shouldUpdateLengthEdges, different);
        if (matchEdge != null) {
            return;
        }
        HashMap tmpMap = new HashMap();
        edges.forEach(edge -> {
            Integer n = tmpMap.put(edge, edge.getLength());
        });
        int splitCount = 2;
        while (splitCount > different) {
            List sumCombinations = IntegerExtensions.findSumCombination((int)different, (int)splitCount);
            for (int[] combination : sumCombinations) {
                HashMap<TOPKanteMetaData, Integer> matchEdges = new HashMap<TOPKanteMetaData, Integer>();
                int j = 0;
                while (j < splitCount) {
                    int value = combination[j];
                    TOPKanteMetaData machtEdge = this.getRelevantEdge(tmpMap.keySet().stream().filter(edge -> !matchEdges.containsKey(edge)).toList(), value);
                    if (machtEdge != null) {
                        matchEdges.put(machtEdge, value);
                    }
                    ++j;
                }
                if (matchEdges.size() == splitCount) break;
                matchEdges.keySet().forEach(edge -> edge.setLength((Integer)tmpMap.get(edge)));
            }
            ++splitCount;
        }
    }

    private TOPKanteMetaData getRelevantEdge(List<TOPKanteMetaData> edges, int different) {
        List<Pair> pathWithAlreadyRegistedLength = edges.stream().map(edge -> {
            List<CyclePath> allCyclePaths = this.findAllCyclePaths((TOPKanteMetaData)edge);
            List<CyclePath> pathsWithAlreadRegistedLengthEdge = allCyclePaths.stream().filter(path -> path.getEdges().stream().filter(e -> e.edge() != edge).allMatch(e -> ((TOPKanteMetaData)e.edge()).alreadyRegistedLength())).toList();
            return new Pair(edge, pathsWithAlreadRegistedLengthEdge);
        }).toList();
        List<Pair> pathWithoutAlreaydRegistedLength = pathWithAlreadyRegistedLength.stream().filter(e -> ((List)e.getSecond()).isEmpty()).toList();
        if (!pathWithoutAlreaydRegistedLength.isEmpty()) {
            TOPKanteMetaData matchEdge = (TOPKanteMetaData)pathWithoutAlreaydRegistedLength.get(0).getFirst();
            matchEdge.setLength(matchEdge.getLength() + different);
            return matchEdge;
        }
        TOPKanteMetaData matchEdge = null;
        for (Pair pair : pathWithAlreadyRegistedLength) {
            TOPKanteMetaData edge2 = (TOPKanteMetaData)pair.getFirst();
            int tmpLength = edge2.getLength();
            edge2.setLength(different + tmpLength);
            boolean isRelevantLength = ((List)pair.getSecond()).stream().map(TopKanteDirectedGraph::isMatchLength).anyMatch(MachtTopEdgeLength::isMatch);
            if (isRelevantLength) {
                matchEdge = edge2;
                break;
            }
            edge2.setLength(tmpLength);
        }
        return matchEdge;
    }

    private static MachtTopEdgeLength isMatchLength(CyclePath path) {
        int backwardLength;
        List<TOPKanteMetaData> forwardEdges = path.getSameDirectionEdge();
        List<TOPKanteMetaData> backwardEdges = path.getOpositeDirectionEdge();
        int forwardLength = CyclePath.getPathLength(forwardEdges);
        if (forwardLength != (backwardLength = CyclePath.getPathLength(backwardEdges))) {
            return new MachtTopEdgeLength(false, forwardLength < backwardLength ? forwardEdges : backwardEdges, Math.abs(backwardLength - forwardLength));
        }
        return new MachtTopEdgeLength(true, Collections.emptyList(), 0);
    }

    private DirectedPseudograph<TOP_Knoten, AsDirectedTopGraph.DirectedTOPEdge<TOPKanteMetaData>> cloneGraph(TOPKanteMetaData md) {
        GraphBuilder builder = DirectedPseudograph.createBuilder(AsDirectedTopGraph.DirectedTOPEdge.class);
        builder.addGraph(this.graph);
        DirectedPseudograph clone = (DirectedPseudograph)builder.build();
        if (md != null) {
            clone.removeEdge((Object)md.getTopNodeA(), (Object)md.getTopNodeB());
            clone.removeEdge((Object)md.getTopNodeB(), (Object)md.getTopNodeA());
        }
        return clone;
    }

    record MachtTopEdgeLength(boolean isMatch, List<TOPKanteMetaData> notMatchEdges, int differentLength) {
    }
}

