/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.table;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.swt.TableControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.table.DefaultTableViewerCompositeBuilder;
import org.eclipse.emfforms.spi.swt.table.TableViewerCompositeBuilder;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.viewmodel.ToolboxViewModelService;
import org.eclipse.set.utils.emfforms.Annotations;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class TableControlCustomSWTRenderer
extends TableControlSWTRenderer {
    private static final String PROPERTIES_KEY = "properties";
    private static final String PROPERTIES_SPLIT_PATTERN = " *, *";
    private static final String PROPERTY_HIDE_HEADING = "hideHeading";
    private static final String VIEWER_CONSUMER_KEY = "viewerConsumer";
    private final boolean hideHeading;
    private final Consumer<ColumnViewer> viewerConsumer;

    private static boolean isSet(String properties, String value) {
        if (properties == null) {
            return false;
        }
        List<String> propertyList = Arrays.asList(properties.split(PROPERTIES_SPLIT_PATTERN));
        return propertyList.contains(value);
    }

    @Inject
    public TableControlCustomSWTRenderer(VTableControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabindingEMF emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsEditSupport emfFormsEditSupport, EMFFormsLocalizationService localizationService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, imageRegistryService, emfFormsEditSupport, localizationService);
        Consumer consumer;
        ToolboxViewModelService toolboxViewModelService = Services.getToolboxViewModelService();
        String consumerKey = Annotations.getViewModelValue((VElement)vElement, (String)VIEWER_CONSUMER_KEY);
        this.viewerConsumer = consumer = (Consumer)toolboxViewModelService.get(consumerKey);
        String properties = Annotations.getViewModelValue((VElement)vElement, (String)PROPERTIES_KEY);
        this.hideHeading = TableControlCustomSWTRenderer.isSet(properties, PROPERTY_HIDE_HEADING);
    }

    protected TableViewerCompositeBuilder createTableViewerCompositeBuilder() {
        if (this.hideHeading) {
            return new DefaultTableViewerCompositeBuilder(){

                public Optional<Label> getTitleLabel() {
                    return Optional.empty();
                }

                protected Label createTitleLabel(Composite parentComposite, Color background) {
                    return null;
                }

                protected Label createValidationLabel(Composite topComposite) {
                    return null;
                }
            };
        }
        return super.createTableViewerCompositeBuilder();
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Control control = super.renderControl(gridCell, parent);
        if (this.viewerConsumer != null) {
            this.viewerConsumer.accept((ColumnViewer)this.getTableViewer());
        }
        return control;
    }
}

