/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.MissingSupplier;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedElement;
import org.eclipse.set.basis.graph.DirectedElementImpl;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Begrenzung_A_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Begrenzung_B_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.ENUMTOPAnschluss;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.GEO_Laenge_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Gleis.Gleis_Lichtraum;
import org.eclipse.set.model.planpro.Verweise.ID_TOP_Kante_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_TOP_Knoten_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.ContainerExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CollectionExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Distance;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.eclipse.set.ppmodel.extensions.utils.SetExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopKanteExtensions
extends BasisObjektExtensions {
    private static final BigDecimal TOLERANCE = BigDecimal.valueOf(0.002);
    private static final Logger logger = LoggerFactory.getLogger(TopKanteExtensions.class);
    private static Cache cache;

    public static TOP_Knoten getTOPKnotenA(TOP_Kante topKante) {
        ID_TOP_Knoten_TypeClass _iDTOPKnotenA = topKante.getIDTOPKnotenA();
        TOP_Knoten _value = null;
        if (_iDTOPKnotenA != null) {
            _value = _iDTOPKnotenA.getValue();
        }
        return _value;
    }

    public static TOP_Knoten getTOPKnotenB(TOP_Kante topKante) {
        ID_TOP_Knoten_TypeClass _iDTOPKnotenB = topKante.getIDTOPKnotenB();
        TOP_Knoten _value = null;
        if (_iDTOPKnotenB != null) {
            _value = _iDTOPKnotenB.getValue();
        }
        return _value;
    }

    public static List<GEO_Kante> getGeoKanten(TOP_Kante topKante) {
        Functions.Function1 _function = k -> {
            TOP_Kante _pKante = GeoKanteExtensions.topKante(k);
            return Objects.equals(_pKante, topKante);
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)topKante).getGEOKante(), (Functions.Function1)_function));
    }

    public static GEO_Kante getGeoKanteAtKnoten(TOP_Kante topKante, TOP_Knoten topKnoten) {
        boolean _greaterThan;
        GEO_Knoten geoKnoten = TopKnotenExtensions.getGEOKnoten(topKnoten);
        List<GEO_Kante> geoKanten = GeoKnotenExtensions.getGeoKantenOnParentKante(geoKnoten, (Basis_Objekt)topKante);
        int _size = geoKanten.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The TOP_Knoten: ");
            String _wert = topKnoten.getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(" on TOP_Kante: ");
            String _wert_1 = topKante.getIdentitaet().getWert();
            _builder.append(_wert_1);
            _builder.append(" reference to more than one GEO_Kante");
            throw new IllegalArgumentException(_builder.toString());
        }
        return geoKanten.get(0);
    }

    public static List<DirectedElement<GEO_Kante>> getGeoKanten(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> directedTopEdge) {
        GEO_Knoten start;
        TOP_Knoten _tail = null;
        if (directedTopEdge != null) {
            _tail = (TOP_Knoten)directedTopEdge.getTail();
        }
        GEO_Knoten _gEOKnoten = null;
        if (_tail != null) {
            _gEOKnoten = TopKnotenExtensions.getGEOKnoten(_tail);
        }
        if ((start = _gEOKnoten) == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        return TopKanteExtensions.getGeoKanten(directedTopEdge, start, result);
    }

    public static GeoPosition getCoordinate(TOP_Kante topKante, BigDecimal abstand, BigDecimal seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        TOP_Knoten topKnotenA = TopKanteExtensions.getTOPKnotenA(topKante);
        return TopKanteExtensions.getCoordinate(topKante, topKnotenA, abstand, seitlicherAbstand, wirkrichtung);
    }

    public static GeoPosition getCoordinate(TOP_Kante topKante, TOP_Knoten topStart, BigDecimal abstand, BigDecimal seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        boolean _greaterThan;
        BigDecimal lengthTopKante;
        Functions.Function2 _function;
        GEO_Knoten start = TopKnotenExtensions.getGEOKnoten(topStart);
        List<GEO_Kante> geoKantenOnTopKante = TopKanteExtensions.getGeoKanten(topKante);
        BigDecimal lengthGeoKanten = (BigDecimal)org.eclipse.xtext.xbase.lib.IterableExtensions.fold(geoKantenOnTopKante, (Object)BigDecimal.ZERO, (Functions.Function2)(_function = (l, k) -> {
            BigDecimal _wert = k.getGEOKanteAllg().getGEOLaenge().getWert();
            return l.add(_wert);
        }));
        BigDecimal difference = lengthGeoKanten.subtract(lengthTopKante = topKante.getTOPKanteAllg().getTOPLaenge().getWert()).abs();
        boolean bl = _greaterThan = difference.compareTo(TOLERANCE) > 0;
        if (_greaterThan) {
            logger.debug("lengthTopKante={}", (Object)lengthTopKante);
            logger.debug("lengthGeoKanten={}", (Object)lengthGeoKanten);
            logger.debug("geoKantenOnTopKante={}", (Object)geoKantenOnTopKante.size());
            logger.warn("Difference of GEO Kanten length and TOP Kante length for TOP Kante {} greater than tolerance {} ({}).", new Object[]{topKante.getIdentitaet().getWert(), TOLERANCE, difference});
        }
        BigDecimal _multiply = abstand.multiply(lengthGeoKanten);
        BigDecimal relativeAbstand = _multiply.divide(lengthTopKante, MathContext.DECIMAL128);
        return GeoKnotenExtensions.getCoordinate(start, null, (Basis_Objekt)topKante, relativeAbstand, seitlicherAbstand, wirkrichtung);
    }

    public static boolean isConnectedTo(TOP_Kante topKante, TOP_Kante otherTopKante) {
        try {
            TOP_Knoten _connectionTo = TopKanteExtensions.connectionTo(topKante, otherTopKante);
            return _connectionTo != null;
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static boolean isConnectedTo(TOP_Kante topKante, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        boolean _not;
        Functions.Function1 _function;
        TOP_Kante _topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
        boolean _equals = Objects.equals(_topKante, topKante);
        if (_equals) {
            return true;
        }
        List<TOP_Kante> adjacentTopKanten = TopKanteExtensions.getAdjacentTopKanten(topKante);
        List qualifiedAdjacentTopKanten = org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter(adjacentTopKanten, (Functions.Function1)(_function = t -> TopKanteExtensions.isOnProperEndOf(singlePoint, t, topKante))));
        boolean _isEmpty = qualifiedAdjacentTopKanten.isEmpty();
        boolean bl = _not = !_isEmpty;
        return _not;
    }

    public static TOP_Knoten connectionTo(TOP_Kante topKante, TOP_Kante otherTopKante) {
        Functions.Function1 _function;
        Object _xblockexpression = null;
        TOP_Knoten _tOPKnotenA = TopKanteExtensions.getTOPKnotenA(topKante);
        TOP_Knoten _tOPKnotenB = TopKanteExtensions.getTOPKnotenB(topKante);
        List thisKnoten = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TOP_Knoten[]{_tOPKnotenA, _tOPKnotenB}));
        TOP_Knoten _tOPKnotenA_1 = TopKanteExtensions.getTOPKnotenA(otherTopKante);
        TOP_Knoten _tOPKnotenB_1 = TopKanteExtensions.getTOPKnotenB(otherTopKante);
        List otherKnoten = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TOP_Knoten[]{_tOPKnotenA_1, _tOPKnotenB_1}));
        Iterable commonKnoten = org.eclipse.xtext.xbase.lib.IterableExtensions.filter(otherKnoten, (Functions.Function1)(_function = k -> thisKnoten.contains(k)));
        int size = org.eclipse.xtext.xbase.lib.IterableExtensions.size((Iterable)commonKnoten);
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return ((TOP_Knoten[])Conversions.unwrapArray((Object)commonKnoten, TOP_Knoten.class))[0];
        }
        Object _xifexpression = null;
        if (size > 1) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Ambiguous connection for ");
            String _wert = topKante.getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(" and ");
            String _wert_1 = otherTopKante.getIdentitaet().getWert();
            _builder.append(_wert_1);
            throw new IllegalArgumentException(_builder.toString());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Gleis_Lichtraum getGleisLichtraum(TOP_Kante topKante) {
        boolean _tripleNotEquals;
        Functions.Function1 _function = l -> {
            Functions.Function1 _function_1 = it -> BereichObjektExtensions.getTopKante(it);
            return ListExtensions.map((List)l.getBereichObjektTeilbereich(), (Functions.Function1)_function_1).contains(topKante);
        };
        Iterable lichtraeume = org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)topKante).getGleisLichtraum(), (Functions.Function1)_function);
        boolean _isEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)lichtraeume);
        if (_isEmpty) {
            return null;
        }
        int _size = org.eclipse.xtext.xbase.lib.IterableExtensions.size((Iterable)lichtraeume);
        boolean bl = _tripleNotEquals = _size != 1;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Unexpected number of Gleis Lichtr\u00e4ume for Top-Kante: topKante=");
            String _wert = topKante.getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(" size=");
            int _size_1 = org.eclipse.xtext.xbase.lib.IterableExtensions.size((Iterable)lichtraeume);
            _builder.append((Object)_size_1);
            throw new IllegalArgumentException(_builder.toString());
        }
        return ((Gleis_Lichtraum[])Conversions.unwrapArray((Object)lichtraeume, Gleis_Lichtraum.class))[0];
    }

    public static List<TOP_Kante> getAdjacentTopKanten(TOP_Kante topKante, Iterable<TOP_Kante> topKanten) {
        TopKanteExtensions.createCache();
        MissingSupplier _function = () -> TopKanteExtensions.calcAdjacentTopKanten(topKante, topKanten);
        return (List)cache.get(TopKanteExtensions.getCacheKey(topKante), _function);
    }

    public static void createCache() {
        if (cache == null) {
            cache = Services.getCacheService().getCache("toolbox.cache.topkante-to-adjacent-topkanten");
        }
    }

    public static String getCacheKey(TOP_Kante edge) {
        StringConcatenation _builder = new StringConcatenation();
        String _cacheString = BasisAttributExtensions.getContainer((EObject)edge).getCacheString();
        _builder.append(_cacheString);
        _builder.append("/");
        String _wert = edge.getIdentitaet().getWert();
        _builder.append(_wert);
        return _builder.toString();
    }

    private static List<TOP_Kante> calcAdjacentTopKanten(TOP_Kante topKante, Iterable<TOP_Kante> topKanten) {
        Functions.Function1 _function = t -> !Objects.equals(t, topKante) && TopKanteExtensions.isConnectedTo(t, topKante);
        return org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter(topKanten, (Functions.Function1)_function));
    }

    public static List<TOP_Kante> getAdjacentTopKanten(TOP_Kante topKante) {
        return TopKanteExtensions.getAdjacentTopKanten(topKante, BasisAttributExtensions.getContainer((EObject)topKante).getTOPKante());
    }

    public static List<Punkt_Objekt_TOP_Kante_AttributeGroup> getConnected(TOP_Kante topKante) {
        CacheService cacheService = Services.getCacheService();
        Cache cache = cacheService.getCache("toolbox.cache.topkante-to-singlepoints", BasisAttributExtensions.getContainer((EObject)topKante).getCacheString());
        String _wert = topKante.getIdentitaet().getWert();
        PunktObjektTopKanteLoader _punktObjektTopKanteLoader = new PunktObjektTopKanteLoader(topKante);
        Object _get = cache.get(_wert, (MissingSupplier)_punktObjektTopKanteLoader);
        return (List)_get;
    }

    private static List<Punkt_Objekt_TOP_Kante_AttributeGroup> findPunktObjektTopKanten(TOP_Kante topKante) {
        Functions.Function1 _function = it -> PunktObjektExtensions.getSinglePoints(it);
        Functions.Function1 _function_1 = it -> TopKanteExtensions.isConnectedTo(topKante, it);
        return org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)Iterables.concat((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map(ContainerExtensions.getPunktObjekte(BasisAttributExtensions.getContainer((EObject)topKante)), (Functions.Function1)_function)), (Functions.Function1)_function_1));
    }

    public static BigDecimal getAbstand(TOP_Kante topKante, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        boolean _not;
        TOP_Kante _topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
        boolean _equals = Objects.equals(_topKante, topKante);
        if (_equals) {
            return singlePoint.getAbstand().getWert();
        }
        Set<TOP_Knoten> topKnotenSet = SetExtensions.intersection(PunktObjektTopKanteExtensions.getTopKnoten(singlePoint), TopKanteExtensions.getTOPKnoten(topKante));
        boolean _isEmpty = topKnotenSet.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            int _size = topKnotenSet.size();
            boolean _equals_1 = _size == 1;
            Assert.isTrue((boolean)_equals_1);
            TOP_Knoten topKnoten = (TOP_Knoten)org.eclipse.xtext.xbase.lib.IterableExtensions.head(topKnotenSet);
            return TopKanteExtensions.getAbstand(topKante, topKnoten);
        }
        String _identitaet = PunktObjektTopKanteExtensions.getIdentitaet(singlePoint);
        throw new IllegalArgumentException(_identitaet);
    }

    public static Pair<BigDecimal, BigDecimal> getAbstand(TOP_Kante topKante, Bereich_Objekt_Teilbereich_AttributeGroup tb) {
        ID_TOP_Kante_TypeClass _iDTOPKante = tb.getIDTOPKante();
        boolean _equals = Objects.equals(_iDTOPKante, topKante);
        if (_equals) {
            Begrenzung_A_TypeClass _begrenzungA = null;
            if (tb != null) {
                _begrenzungA = tb.getBegrenzungA();
            }
            BigDecimal _wert = null;
            if (_begrenzungA != null) {
                _wert = _begrenzungA.getWert();
            }
            Begrenzung_B_TypeClass _begrenzungB = null;
            if (tb != null) {
                _begrenzungB = tb.getBegrenzungB();
            }
            BigDecimal _wert_1 = null;
            if (_begrenzungB != null) {
                _wert_1 = _begrenzungB.getWert();
            }
            return Pair.of((Object)_wert, (Object)_wert_1);
        }
        throw new IllegalArgumentException();
    }

    public static BigDecimal getAbstand(TOP_Kante topKante, TOP_Knoten topKnoten) {
        TOP_Knoten _tOPKnotenA = TopKanteExtensions.getTOPKnotenA(topKante);
        boolean _equals = Objects.equals(_tOPKnotenA, topKnoten);
        if (_equals) {
            return BigDecimal.ZERO;
        }
        TOP_Knoten _tOPKnotenB = TopKanteExtensions.getTOPKnotenB(topKante);
        boolean _equals_1 = Objects.equals(_tOPKnotenB, topKnoten);
        if (_equals_1) {
            return topKante.getTOPKanteAllg().getTOPLaenge().getWert();
        }
        String _wert = topKnoten.getIdentitaet().getWert();
        throw new IllegalArgumentException(_wert);
    }

    public static BigDecimal getAbstand(TOP_Kante topKante, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint1, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint2) {
        BigDecimal d1 = TopKanteExtensions.getAbstand(topKante, singlePoint1);
        BigDecimal d2 = TopKanteExtensions.getAbstand(topKante, singlePoint2);
        BigDecimal _max = d1.max(d2);
        BigDecimal _min = d1.min(d2);
        return _max.subtract(_min);
    }

    public static Pair<BigDecimal, BigDecimal> getAbstand(TOP_Kante topKante, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint1, Bereich_Objekt_Teilbereich_AttributeGroup tb) {
        BigDecimal d1 = TopKanteExtensions.getAbstand(topKante, singlePoint1);
        Pair<BigDecimal, BigDecimal> d2 = TopKanteExtensions.getAbstand(topKante, tb);
        BigDecimal _max = ((BigDecimal)d2.getKey()).max(d1);
        BigDecimal _min = ((BigDecimal)d2.getKey()).min(d1);
        BigDecimal distanceA = _max.subtract(_min);
        BigDecimal _max_1 = ((BigDecimal)d2.getValue()).max(d1);
        BigDecimal _min_1 = ((BigDecimal)d2.getValue()).min(d1);
        BigDecimal distanceB = _max_1.subtract(_min_1);
        return Pair.of((Object)distanceA, (Object)distanceB);
    }

    public static BigDecimal getAbstand(TOP_Kante topKante, Punkt_Objekt punktObjekt1, Punkt_Objekt punktObjekt2) {
        Functions.Function1 _function = it -> TopKanteExtensions.isConnectedTo(topKante, it);
        Functions.Function1 _function_1 = it -> TopKanteExtensions.isConnectedTo(topKante, it);
        return TopKanteExtensions.getAbstand(topKante, (Punkt_Objekt_TOP_Kante_AttributeGroup)CollectionExtensions.getUnique(org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt1), (Functions.Function1)_function))), (Punkt_Objekt_TOP_Kante_AttributeGroup)CollectionExtensions.getUnique(org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt2), (Functions.Function1)_function_1))));
    }

    public static Pair<BigDecimal, BigDecimal> getAbstand(TOP_Kante topKante, Punkt_Objekt punktObjekt1, Bereich_Objekt_Teilbereich_AttributeGroup tb) {
        Functions.Function1 _function = it -> TopKanteExtensions.isConnectedTo(topKante, it);
        return TopKanteExtensions.getAbstand(topKante, (Punkt_Objekt_TOP_Kante_AttributeGroup)CollectionExtensions.getUnique(org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt1), (Functions.Function1)_function))), tb);
    }

    public static BigDecimal getAbstand(TOP_Kante topKante, TOP_Knoten topKnoten, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        TOP_Knoten _tOPKnotenA = TopKanteExtensions.getTOPKnotenA(topKante);
        boolean _equals = Objects.equals(topKnoten, _tOPKnotenA);
        if (_equals) {
            return TopKanteExtensions.getAbstand(topKante, singlePoint);
        }
        TOP_Knoten _tOPKnotenB = TopKanteExtensions.getTOPKnotenB(topKante);
        boolean _equals_1 = Objects.equals(topKnoten, _tOPKnotenB);
        if (_equals_1) {
            BigDecimal _laenge = TopKanteExtensions.getLaenge(topKante);
            BigDecimal _abstand = TopKanteExtensions.getAbstand(topKante, singlePoint);
            return _laenge.subtract(_abstand);
        }
        String _string = topKnoten.toString();
        throw new IllegalArgumentException(_string);
    }

    public static BigDecimal getAbstand(TOP_Kante topKante, GEO_Knoten geoKnoten) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        Functions.Function1 _function = it -> TopKanteExtensions.getGeoKanten(topKante).contains(it);
        boolean isGeoKnotenOnTopKkante = org.eclipse.xtext.xbase.lib.IterableExtensions.exists(GeoKnotenExtensions.getGeoKanten(geoKnoten), (Functions.Function1)_function);
        if (!isGeoKnotenOnTopKkante) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("GeoKnoten: ");
            String _wert = geoKnoten.getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(" isn't belong to TOP_Kante: ");
            String _wert_1 = topKante.getIdentitaet().getWert();
            _builder.append(_wert_1);
            _builder.append(" ");
            throw new IllegalArgumentException(_builder.toString());
        }
        GEO_Knoten _value = TopKanteExtensions.getTOPKnotenA(topKante).getIDGEOKnoten().getValue();
        boolean bl = _tripleEquals = _value == geoKnoten;
        if (_tripleEquals) {
            return BigDecimal.ZERO;
        }
        GEO_Knoten _value_1 = TopKanteExtensions.getTOPKnotenB(topKante).getIDGEOKnoten().getValue();
        boolean bl2 = _tripleEquals_1 = _value_1 == geoKnoten;
        if (_tripleEquals_1) {
            return TopKanteExtensions.getLaenge(topKante);
        }
        BigDecimal distance = TopKanteExtensions.getAbstand(TopKanteExtensions.getGeoKanten(topKante), TopKanteExtensions.getTOPKnotenA(topKante).getIDGEOKnoten().getValue(), geoKnoten, BigDecimal.ZERO);
        return distance;
    }

    private static BigDecimal getAbstand(List<GEO_Kante> geoKanten, GEO_Knoten startKnoten, GEO_Knoten targetKnoten, BigDecimal distance) {
        if (startKnoten == targetKnoten || startKnoten == null || targetKnoten == null) {
            return distance;
        }
        Functions.Function1 _function = it -> geoKanten.contains(it);
        GEO_Kante geoKante = (GEO_Kante)IterableExtensions.getFirstOrNull(org.eclipse.xtext.xbase.lib.IterableExtensions.filter(GeoKnotenExtensions.getGeoKanten(startKnoten), (Functions.Function1)_function));
        if (geoKante == null) {
            throw new IllegalArgumentException();
        }
        GEO_Knoten _xifexpression = null;
        GEO_Knoten _value = geoKante.getIDGEOKnotenA().getValue();
        boolean _tripleEquals = _value == startKnoten;
        _xifexpression = _tripleEquals ? geoKante.getIDGEOKnotenB().getValue() : geoKante.getIDGEOKnotenA().getValue();
        GEO_Knoten nextKnoten = _xifexpression;
        Functions.Function1 _function_1 = it -> it != geoKante;
        List remainingGeoKanten = org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter(geoKanten, (Functions.Function1)_function_1));
        BigDecimal _elvis = null;
        GEO_Kante_Allg_AttributeGroup _gEOKanteAllg = geoKante.getGEOKanteAllg();
        GEO_Laenge_TypeClass _gEOLaenge = null;
        if (_gEOKanteAllg != null) {
            _gEOLaenge = _gEOKanteAllg.getGEOLaenge();
        }
        BigDecimal _wert = null;
        if (_gEOLaenge != null) {
            _wert = _gEOLaenge.getWert();
        }
        _elvis = _wert != null ? _wert : BigDecimal.ZERO;
        BigDecimal _plus = distance.add(_elvis);
        return TopKanteExtensions.getAbstand(remainingGeoKanten, nextKnoten, targetKnoten, _plus);
    }

    protected static BigDecimal _getAbstandDispatch(TOP_Kante topKante, Basis_Objekt basisObjekt1, Basis_Objekt basisObjekt2) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Unexpected Argumenttypes ");
        String _simpleName = basisObjekt1.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(", ");
        String _simpleName_1 = basisObjekt2.getClass().getSimpleName();
        _builder.append(_simpleName_1);
        throw new IllegalArgumentException(_builder.toString());
    }

    protected static BigDecimal _getAbstandDispatch(TOP_Kante topKante, Punkt_Objekt punktObject1, Punkt_Objekt punktObjekt2) {
        return TopKanteExtensions.getAbstand(topKante, punktObject1, punktObjekt2);
    }

    public static Pair<BigDecimal, BigDecimal> getAbstandBO(TOP_Kante topKante, Punkt_Objekt punktObject, Bereich_Objekt_Teilbereich_AttributeGroup tb) {
        return TopKanteExtensions.getAbstand(topKante, punktObject, tb);
    }

    protected static BigDecimal _getAbstandDispatch(TOP_Kante topKante, TOP_Knoten topKnoten, Punkt_Objekt punktObjekt) {
        Functions.Function1 _function = it -> TopKanteExtensions.isConnectedTo(topKante, it);
        return TopKanteExtensions.getAbstand(topKante, topKnoten, (Punkt_Objekt_TOP_Kante_AttributeGroup)CollectionExtensions.getUnique(org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function))));
    }

    protected static BigDecimal _getAbstandDispatch(TOP_Kante topKante, Punkt_Objekt punktObjekt, TOP_Knoten topKnoten) {
        Functions.Function1 _function = it -> TopKanteExtensions.isConnectedTo(topKante, it);
        return TopKanteExtensions.getAbstand(topKante, topKnoten, (Punkt_Objekt_TOP_Kante_AttributeGroup)CollectionExtensions.getUnique(org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function))));
    }

    public static BigDecimal getLaenge(TOP_Kante topKante) {
        return topKante.getTOPKanteAllg().getTOPLaenge().getWert();
    }

    public static boolean intersect(TOP_Kante topKante, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        boolean _isEmpty = TopKanteExtensions.intersection(topKante, PunktObjektTopKanteExtensions.getSinglePoints(singlePoint)).isEmpty();
        return !_isEmpty;
    }

    public static Set<Punkt_Objekt_TOP_Kante_AttributeGroup> intersection(TOP_Kante topKante, Collection<Punkt_Objekt_TOP_Kante_AttributeGroup> singlePoints) {
        Functions.Function1 _function = it -> {
            ID_TOP_Kante_TypeClass _iDTOPKante = it.getIDTOPKante();
            String _wert = null;
            if (_iDTOPKante != null) {
                _wert = _iDTOPKante.getWert();
            }
            String _wert_1 = topKante.getIdentitaet().getWert();
            return Objects.equals(_wert, _wert_1);
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter(singlePoints, (Functions.Function1)_function));
    }

    public static ENUMTOPAnschluss getTOPAnschluss(TOP_Kante topKante, TOP_Knoten topKnoten) {
        boolean _equals_1;
        boolean _equals;
        ID_TOP_Knoten_TypeClass idA = topKante.getIDTOPKnotenA();
        ID_TOP_Knoten_TypeClass idB = topKante.getIDTOPKnotenB();
        String _wert = topKnoten.getIdentitaet().getWert();
        String _wert_1 = null;
        if (idA != null) {
            _wert_1 = idA.getWert();
        }
        if (_equals = Objects.equals(_wert, _wert_1)) {
            return topKante.getTOPKanteAllg().getTOPAnschlussA().getWert();
        }
        String _wert_2 = topKnoten.getIdentitaet().getWert();
        String _wert_3 = null;
        if (idB != null) {
            _wert_3 = idB.getWert();
        }
        if (_equals_1 = Objects.equals(_wert_2, _wert_3)) {
            return topKante.getTOPKanteAllg().getTOPAnschlussB().getWert();
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("topKnoten=");
        String _wert_4 = topKnoten.getIdentitaet().getWert();
        _builder.append(_wert_4);
        throw new IllegalArgumentException(_builder.toString());
    }

    public static ENUMTOPAnschluss getTOPAnschlussA(TOP_Kante topKante) {
        return topKante.getTOPKanteAllg().getTOPAnschlussA().getWert();
    }

    public static ENUMTOPAnschluss getTOPAnschlussB(TOP_Kante topKante) {
        return topKante.getTOPKanteAllg().getTOPAnschlussB().getWert();
    }

    public static TOP_Knoten opposite(TOP_Kante topKante, TOP_Knoten topKnoten) {
        boolean _equals_1;
        boolean _equals;
        ID_TOP_Knoten_TypeClass idA = topKante.getIDTOPKnotenA();
        ID_TOP_Knoten_TypeClass idB = topKante.getIDTOPKnotenB();
        String _wert = topKnoten.getIdentitaet().getWert();
        String _wert_1 = null;
        if (idA != null) {
            _wert_1 = idA.getWert();
        }
        if (_equals = Objects.equals(_wert, _wert_1)) {
            return TopKanteExtensions.getTOPKnotenB(topKante);
        }
        String _wert_2 = topKnoten.getIdentitaet().getWert();
        String _wert_3 = null;
        if (idB != null) {
            _wert_3 = idB.getWert();
        }
        if (_equals_1 = Objects.equals(_wert_2, _wert_3)) {
            return TopKanteExtensions.getTOPKnotenA(topKante);
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("topKnoten=");
        String _wert_4 = topKnoten.getIdentitaet().getWert();
        _builder.append(_wert_4);
        throw new IllegalArgumentException(_builder.toString());
    }

    public static boolean isRoute(TOP_Kante topKante, TOP_Kante destination, TOP_Knoten transition) {
        ENUMTOPAnschluss anschlussOrigin = TopKanteExtensions.getTOPAnschluss(topKante, transition);
        ENUMTOPAnschluss anschlussDestination = TopKanteExtensions.getTOPAnschluss(destination, transition);
        boolean _isPoint = TopKanteExtensions.isPoint(anschlussOrigin);
        if (_isPoint) {
            return TopKanteExtensions.isBranch(anschlussDestination);
        }
        boolean _isBranch = TopKanteExtensions.isBranch(anschlussOrigin);
        if (_isBranch) {
            return TopKanteExtensions.isPoint(anschlussDestination);
        }
        return false;
    }

    public static List<TOP_Knoten> getTOPKnoten(TOP_Kante topKante) {
        LinkedList<TOP_Knoten> result = new LinkedList<TOP_Knoten>();
        result.add(TopKanteExtensions.getTOPKnotenA(topKante));
        result.add(TopKanteExtensions.getTOPKnotenB(topKante));
        return result;
    }

    public static List<W_Kr_Gsp_Element> getWKrGspElemente(TOP_Kante topKante) {
        LinkedList result = Lists.newLinkedList();
        result.add(TopKnotenExtensions.getWKrGspElement(TopKanteExtensions.getTOPKnotenA(topKante)));
        result.add(TopKnotenExtensions.getWKrGspElement(TopKanteExtensions.getTOPKnotenB(topKante)));
        return result;
    }

    private static boolean isPoint(ENUMTOPAnschluss anschluss) {
        return Objects.equals(anschluss, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_SPITZE);
    }

    private static boolean isBranch(ENUMTOPAnschluss anschluss) {
        return Objects.equals(anschluss, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS) || Objects.equals(anschluss, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS);
    }

    private static boolean isOnProperEndOf(Punkt_Objekt_TOP_Kante_AttributeGroup p, TOP_Kante adjacentTopKante, TOP_Kante originTopKante) {
        boolean _notEquals;
        TOP_Kante _topKante = PunktObjektTopKanteExtensions.getTopKante(p);
        boolean bl = _notEquals = !Objects.equals(_topKante, adjacentTopKante);
        if (_notEquals) {
            return false;
        }
        BigDecimal abstand = p.getAbstand().getWert();
        TOP_Knoten A = TopKanteExtensions.getTOPKnotenA(adjacentTopKante);
        TOP_Knoten B = TopKanteExtensions.getTOPKnotenB(adjacentTopKante);
        TOP_Knoten C = TopKanteExtensions.connectionTo(adjacentTopKante, originTopKante);
        boolean _equals = Objects.equals(A, C);
        if (_equals) {
            return TopKanteExtensions.isApproxEqual(abstand, BigDecimal.ZERO);
        }
        boolean _equals_1 = Objects.equals(B, C);
        if (_equals_1) {
            return TopKanteExtensions.isApproxEqual(abstand, TopKanteExtensions.getLaenge(adjacentTopKante));
        }
        return false;
    }

    private static boolean isApproxEqual(BigDecimal a, BigDecimal b) {
        int _compare = new Distance().compare(a, b);
        return _compare == 0;
    }

    private static List<DirectedElement<GEO_Kante>> getGeoKanten(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> directedTopEdge, GEO_Knoten start, List<DirectedElement<GEO_Kante>> result) {
        boolean _tripleEquals;
        TOP_Knoten _head = null;
        if (directedTopEdge != null) {
            _head = (TOP_Knoten)directedTopEdge.getHead();
        }
        GEO_Knoten _gEOKnoten = null;
        if (_head != null) {
            _gEOKnoten = TopKnotenExtensions.getGEOKnoten(_head);
        }
        boolean bl = _tripleEquals = start == _gEOKnoten;
        if (_tripleEquals) {
            return result;
        }
        List<GEO_Kante> startEdges = GeoKnotenExtensions.getGeoKantenOnParentKante(start, (Basis_Objekt)directedTopEdge.getElement());
        Functions.Function1 _function = it -> (GEO_Kante)it.getElement();
        startEdges.removeAll(ListExtensions.map(result, (Functions.Function1)_function));
        boolean _isEmpty = startEdges.isEmpty();
        if (_isEmpty) {
            return result;
        }
        int _size = startEdges.size();
        boolean _equals = _size == 1;
        Assert.isTrue((boolean)_equals);
        GEO_Kante startEdge = startEdges.get(0);
        GEO_Knoten _geoKnotenA = GeoKanteExtensions.getGeoKnotenA(startEdge);
        boolean _tripleEquals_1 = _geoKnotenA == start;
        DirectedElementImpl directedStartEdge = new DirectedElementImpl((Object)startEdge, _tripleEquals_1);
        result.add((DirectedElement<GEO_Kante>)directedStartEdge);
        return TopKanteExtensions.getGeoKanten(directedTopEdge, GeoKanteExtensions.getOpposite(startEdge, start), result);
    }

    public static Iterable<Pair<GEO_Kante, BigDecimal>> getGeoKantenWithDistance(TOP_Kante topKante) {
        TOP_Knoten topKnotenA = TopKanteExtensions.getTOPKnotenA(topKante);
        GEO_Knoten start = TopKnotenExtensions.getGEOKnoten(topKnotenA);
        return GeoKnotenExtensions.getGeoKantenWithDistance(start, topKante);
    }

    public static BigDecimal getAbstandDispatch(TOP_Kante topKante, Basis_Objekt punktObject1, Basis_Objekt punktObjekt2) {
        if (punktObject1 instanceof Punkt_Objekt && punktObjekt2 instanceof Punkt_Objekt) {
            return TopKanteExtensions._getAbstandDispatch(topKante, (Punkt_Objekt)punktObject1, (Punkt_Objekt)punktObjekt2);
        }
        if (punktObject1 instanceof Punkt_Objekt && punktObjekt2 instanceof TOP_Knoten) {
            return TopKanteExtensions._getAbstandDispatch(topKante, (Punkt_Objekt)punktObject1, (TOP_Knoten)punktObjekt2);
        }
        if (punktObject1 instanceof TOP_Knoten && punktObjekt2 instanceof Punkt_Objekt) {
            return TopKanteExtensions._getAbstandDispatch(topKante, (TOP_Knoten)punktObject1, (Punkt_Objekt)punktObjekt2);
        }
        if (punktObject1 != null && punktObjekt2 != null) {
            return TopKanteExtensions._getAbstandDispatch(topKante, punktObject1, punktObjekt2);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(topKante, punktObject1, punktObjekt2).toString());
    }

    private static class PunktObjektTopKanteLoader
    implements MissingSupplier<Object> {
        private final TOP_Kante topKante;

        public PunktObjektTopKanteLoader(TOP_Kante topKante) {
            this.topKante = topKante;
        }

        public Object get() {
            return TopKanteExtensions.findPunktObjektTopKanten(this.topKante);
        }
    }
}

