/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class ScrolledCompositeTab
extends ExampleTab {
    private ScrolledComposite composite;
    private Composite content;
    private Button showFocusedControl;
    private Button alwaysShowScrollBars;

    public ScrolledCompositeTab(CTabFolder topFolder) {
        super(topFolder, "ScrolledComposite");
        this.setDefaultStyle(2816);
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048, true);
        this.createStyleButton("H_SCROLL", 256, true);
        this.createStyleButton("V_SCROLL", 512, true);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.alwaysShowScrollBars = this.createAlwaysShowScrollBarsButton();
        this.showFocusedControl = this.createShowFocusedControlButton();
        this.createShowControlButton();
        this.createFocusControlButton();
        this.createOriginControl();
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.composite = new ScrolledComposite(parent, this.getStyle());
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.content = new Composite((Composite)this.composite, 0);
        this.content.setLayout((Layout)new GridLayout(5, true));
        int i = 0;
        while (i < 100) {
            Button b = new Button(this.content, 8);
            b.setText("Button " + i);
            GridData data = new GridData();
            data.widthHint = 120;
            b.setLayoutData((Object)data);
            ++i;
        }
        this.composite.setContent((Control)this.content);
        this.composite.setExpandHorizontal(true);
        this.composite.setExpandVertical(true);
        if (this.alwaysShowScrollBars != null) {
            this.composite.setAlwaysShowScrollBars(this.alwaysShowScrollBars.getSelection());
        }
        if (this.showFocusedControl != null) {
            this.composite.setShowFocusedControl(this.showFocusedControl.getSelection());
        }
        this.composite.setMinSize(this.content.computeSize(-1, -1));
        this.composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ScrolledCompositeTab.this.composite.setMinSize(ScrolledCompositeTab.this.content.computeSize(-1, -1));
            }
        });
        this.composite.setOrigin(50, 50);
        this.registerControl((Control)this.composite);
    }

    private void createShowControlButton() {
        Button btnA = new Button(this.styleComp, 8);
        btnA.setText("Show Button 89");
        btnA.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrolledCompositeTab.this.composite.showControl(ScrolledCompositeTab.this.content.getChildren()[89]);
            }
        });
    }

    private void createFocusControlButton() {
        Button btnA = new Button(this.styleComp, 8);
        btnA.setText("Focus Button 89");
        btnA.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrolledCompositeTab.this.content.getChildren()[89].setFocus();
            }
        });
    }

    private Button createAlwaysShowScrollBarsButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Always Show ScrollBars");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ScrolledCompositeTab.this.composite.setAlwaysShowScrollBars(button.getSelection());
            }
        });
        return button;
    }

    private Button createShowFocusedControlButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Show Focused Control");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ScrolledCompositeTab.this.composite.setShowFocusedControl(button.getSelection());
            }
        });
        return button;
    }

    private void createOriginControl() {
        Composite comp = new Composite(this.styleComp, 0);
        RowLayout layout = new RowLayout(256);
        layout.center = true;
        comp.setLayout((Layout)layout);
        Label lblX = new Label(comp, 0);
        lblX.setText("Scroll to X:");
        final Text txtX = new Text(comp, 2048);
        txtX.setText("0");
        Util.textSizeAdjustment(lblX, (Control)txtX);
        Label lblY = new Label(comp, 0);
        lblY.setText("Y:");
        final Text txtY = new Text(comp, 2048);
        txtY.setText("0");
        Util.textSizeAdjustment(lblY, (Control)txtY);
        Button btnSelect = new Button(comp, 8);
        btnSelect.setText("OK");
        btnSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int x = Integer.parseInt(txtX.getText());
                    int y = Integer.parseInt(txtY.getText());
                    ScrolledCompositeTab.this.composite.setOrigin(x, y);
                }
                catch (Exception exception) {}
            }
        });
    }
}

