/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.application.EntryPointFactory;
import org.eclipse.rap.rwt.internal.lifecycle.DefaultEntryPointFactory;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

public class EntryPointManager {
    private final Map<String, EntryPointRegistration> entryPoints = new HashMap<String, EntryPointRegistration>();

    public void register(String path, Class<? extends EntryPoint> type, Map<String, String> properties) {
        ParamCheck.notNull(path, "path");
        EntryPointManager.checkValidPath(path);
        this.doRegister(path, new DefaultEntryPointFactory(type), properties);
    }

    public void register(String path, EntryPointFactory entryPointFactory, Map<String, String> properties) {
        ParamCheck.notNull(path, "path");
        ParamCheck.notNull(entryPointFactory, "entryPointFactory");
        EntryPointManager.checkValidPath(path);
        this.doRegister(path, entryPointFactory, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAll() {
        Map<String, EntryPointRegistration> map = this.entryPoints;
        synchronized (map) {
            this.entryPoints.clear();
        }
    }

    public EntryPointRegistration getEntryPointRegistration(HttpServletRequest request) {
        String path = request.getServletPath();
        EntryPointRegistration result = this.getRegistrationByPath(path);
        if (result == null) {
            throw new IllegalArgumentException("Entry point not found: " + path);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPointRegistration getRegistrationByPath(String servletPath) {
        String normalizedPath = "".equals(servletPath) ? "/" : servletPath;
        Map<String, EntryPointRegistration> map = this.entryPoints;
        synchronized (map) {
            return this.entryPoints.get(normalizedPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getServletPaths() {
        Map<String, EntryPointRegistration> map = this.entryPoints;
        synchronized (map) {
            return new ArrayList<String>(this.entryPoints.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegister(String path, EntryPointFactory factory, Map<String, String> properties) {
        Map<String, EntryPointRegistration> map = this.entryPoints;
        synchronized (map) {
            this.checkPathAvailable(path);
            this.entryPoints.put(path, new EntryPointRegistration(factory, properties));
        }
    }

    private static void checkValidPath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path must start with '/': " + path);
        }
        if (path.substring(1).contains("/")) {
            throw new IllegalArgumentException("Nested paths not supported: " + path);
        }
    }

    private void checkPathAvailable(String path) {
        if (this.entryPoints.containsKey(path)) {
            throw new IllegalArgumentException("Entry point already registered for path " + path);
        }
    }
}

