/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class LabelProvider
extends BaseLabelProvider
implements ILabelProvider {
    @Override
    public Image getImage(Object element) {
        return null;
    }

    @Override
    public String getText(Object element) {
        return element == null ? "" : element.toString();
    }

    public static LabelProvider createTextProvider(final Function<Object, String> textFunction) {
        Objects.requireNonNull(textFunction);
        return new LabelProvider(){

            @Override
            public String getText(Object e) {
                return (String)textFunction.apply(e);
            }
        };
    }

    public static LabelProvider createImageProvider(final Function<Object, Image> imageFunction) {
        Objects.requireNonNull(imageFunction);
        return new LabelProvider(){

            @Override
            public Image getImage(Object e) {
                return (Image)imageFunction.apply(e);
            }
        };
    }

    public static LabelProvider createTextImageProvider(final Function<Object, String> textFunction, final Function<Object, Image> imageFunction) {
        Objects.requireNonNull(textFunction);
        Objects.requireNonNull(imageFunction);
        return new LabelProvider(){

            @Override
            public String getText(Object e) {
                return (String)textFunction.apply(e);
            }

            @Override
            public Image getImage(Object e) {
                return (Image)imageFunction.apply(e);
            }
        };
    }
}

