/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.preferences;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.FileSettingStore;
import org.eclipse.rap.rwt.service.SettingStore;
import org.eclipse.rap.rwt.service.SettingStoreFactory;
import org.osgi.framework.Bundle;

public final class WorkbenchFileSettingStoreFactory
implements SettingStoreFactory {
    public SettingStore createSettingStore(String storeId) {
        ParamCheck.notNullOrEmpty((String)storeId, (String)"storeId");
        FileSettingStore result = new FileSettingStore(this.getWorkDir());
        try {
            result.loadById(storeId);
        }
        catch (IOException exception) {
            String message = String.valueOf(exception.getMessage());
            RWT.getRequest().getSession().getServletContext().log(message, (Throwable)exception);
        }
        return result;
    }

    private File getWorkDir() {
        File result = this.getWorkDirFromEnvironment();
        if (result == null) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.rap.ui");
            IPath stateLoc = Platform.getStateLocation((Bundle)bundle);
            File parentDir = stateLoc.toFile();
            result = new File(parentDir, FileSettingStore.class.getName());
        }
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    private File getWorkDirFromEnvironment() {
        String path = System.getProperty("org.eclipse.rap.rwt.service.FileSettingStore.dir");
        return path != null ? new File(path) : null;
    }
}

