/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.Namespace;

public abstract class AbstractCommand {
    protected static final String CONTAINER_LINE_FORMAT = "%1$-45s|%2$-40s|%3$s";
    protected static final String CONTAINER_INSPECT_FORMAT = "ID=%s\n\tNamespace=%s\n\tClass=%s\n\tConnectedTo=%s\n\tConnectNamespace=%s\n\tConfig=%s";
    protected static final String NAMESPACE_LINE_FORMAT = "%s";
    protected static final String NAMESPACE_INSPECT_FORMAT = "ID=%s\n\tUriScheme=%s\n\tClass=%s\n\tDescription=%s\n\tInstanceArgTypes=%s";
    protected static final String CTD_LINE_FORMAT = "%s";
    protected static final String CTD_INSPECT_FORMAT = "ID=%s\n\tDescription=%s\n\tSupportedConfigs=%s\n\tSupportedIntents=%s\n\tInstanceArgTypes=%s\n\tAdapters=%s\n\tHidden=%b\n\tServer=%b";

    protected abstract IContainerManager getContainerManager();

    protected abstract IIDFactory getIDFactory();

    protected List<IContainer> getContainers() {
        return Arrays.asList((IContainer[])this.getContainerManager().getAllContainers().clone());
    }

    protected List<Namespace> getNamespaces() {
        return new ArrayList<Namespace>(this.getIDFactory().getNamespaces());
    }

    protected List<ContainerTypeDescription> getConfigs() {
        return new ArrayList<ContainerTypeDescription>(this.getContainerManager().getContainerFactory().getDescriptions());
    }

    protected void consoleLine(CommandSession cs, String format, Object ... args) {
        cs.getConsole().format(format, args);
    }

    protected ContainerTypeDescription getContainerTypeDescription(ID containerID) {
        return this.getContainerManager().getContainerTypeDescription(containerID);
    }

    protected IContainer getContainerForId(String id) {
        IContainer[] iContainerArray = (IContainer[])this.getContainerManager().getAllContainers().clone();
        int n = iContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer c = iContainerArray[n2];
            if (c.getID().getName().equals(id)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    protected String printClassArrays(Class<?>[][] types) {
        if (types == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < types.length) {
            Class<?>[] paramTypes = types[i];
            sb.append("(");
            int j = 0;
            while (j < paramTypes.length) {
                Class<?> pType = paramTypes[j];
                sb.append(pType.getName());
                if (j + 1 < paramTypes.length) {
                    sb.append(",");
                }
                ++j;
            }
            sb.append(")");
            if (i + 1 < types.length) {
                sb.append(";");
            }
            ++i;
        }
        return sb.toString();
    }

    protected String formatLine(String format, Object ... args) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Formatter f = new Formatter();){
            f.format(format, args);
            return f.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected String formatContainer(IContainer c, int level, Converter escape) {
        ID cID = c.getID();
        ID conID = c.getConnectedID();
        String conIDStr = conID == null ? "" : conID.getName();
        Class<?> cClass = c.getClass();
        switch (level) {
            case 1: {
                return this.formatLine(CONTAINER_LINE_FORMAT, cID.getName(), cClass.getSimpleName(), conIDStr);
            }
            case 0: {
                return this.formatLine(CONTAINER_INSPECT_FORMAT, cID.getName(), cID.getNamespace().getName(), cClass.getName(), conIDStr, c.getConnectNamespace().getName(), this.getContainerTypeDescription(cID).getName());
            }
        }
        return null;
    }

    protected String formatNamespace(Namespace ns, int level, Converter escape) {
        switch (level) {
            case 2: {
                return null;
            }
            case 1: {
                return this.formatLine("%s", ns.getName());
            }
            case 0: {
                return this.formatLine(NAMESPACE_INSPECT_FORMAT, ns.getName(), ns.getScheme(), ns.getClass().getName(), ns.getDescription(), this.printClassArrays(ns.getSupportedParameterTypes()));
            }
        }
        return null;
    }

    protected String formatConfig(ContainerTypeDescription ctd, int level, Converter escape) {
        switch (level) {
            case 2: {
                return null;
            }
            case 1: {
                return this.formatLine("%s", ctd.getName());
            }
            case 0: {
                return this.formatLine(CTD_INSPECT_FORMAT, ctd.getName(), ctd.getDescription(), this.printStringArray(ctd.getSupportedConfigs()), this.printStringArray(ctd.getSupportedIntents()), this.printClassArrays(ctd.getSupportedParameterTypes()), this.printStringArray(ctd.getSupportedAdapterTypes()), ctd.isHidden(), ctd.isServer());
            }
        }
        return null;
    }

    protected String printStringArray(String[] strarr) {
        return strarr == null ? "" : Arrays.asList(strarr).toString();
    }
}

