/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;
import org.xbill.DNS.WireParseException;

final class TypeBitmap
implements Serializable {
    private static final long serialVersionUID = -125354057735389003L;
    private final TreeSet<Integer> types = new TreeSet();

    private TypeBitmap() {
    }

    public TypeBitmap(int[] array) {
        this();
        for (int value : array) {
            Type.check(value);
            this.types.add(value);
        }
    }

    public TypeBitmap(DNSInput in) throws WireParseException {
        this();
        int lastWindowBlockNumber = -1;
        while (in.remaining() > 0) {
            if (in.remaining() < 2) {
                throw new WireParseException("invalid bitmap descriptor");
            }
            int windowBlockNumber = TypeBitmap.getWindowBlockNumber(in, lastWindowBlockNumber);
            int mapLength = TypeBitmap.getMapLength(in);
            for (int i = 0; i < mapLength; ++i) {
                int bitmapByte = in.readU8();
                for (int j = 0; j < 8 && bitmapByte > 0; ++j) {
                    if ((bitmapByte & 1 << 7 - j) == 0) continue;
                    this.types.add(windowBlockNumber * 256 + i * 8 + j);
                }
            }
        }
    }

    private static int getWindowBlockNumber(DNSInput in, int lastWindowBlockNumber) throws WireParseException {
        int windowBlockNumber = in.readU8();
        if (windowBlockNumber < lastWindowBlockNumber) {
            throw new WireParseException("invalid ordering");
        }
        return windowBlockNumber;
    }

    private static int getMapLength(DNSInput in) throws WireParseException {
        int mapLength = in.readU8();
        if (mapLength > in.remaining()) {
            throw new WireParseException("invalid bitmap");
        }
        return mapLength;
    }

    public TypeBitmap(Tokenizer st) throws IOException {
        this();
        Tokenizer.Token t;
        while ((t = st.get()).isString()) {
            int typecode = Type.value(t.value());
            if (typecode < 0) {
                throw st.exception("Invalid type: " + t.value());
            }
            this.types.add(typecode);
        }
        st.unget();
    }

    public int[] toArray() {
        int[] array = new int[this.types.size()];
        int n = 0;
        for (Integer type : this.types) {
            array[n++] = type;
        }
        return array;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Integer> it = this.types.iterator();
        while (it.hasNext()) {
            int t = it.next();
            sb.append(Type.string(t));
            if (!it.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private static void mapToWire(DNSOutput out, TreeSet<Integer> map, int mapbase) {
        int arraymax = map.last() & 0xFF;
        int arraylength = arraymax / 8 + 1;
        int[] array = new int[arraylength];
        out.writeU8(mapbase);
        out.writeU8(arraylength);
        for (int typecode : map) {
            int n = (typecode & 0xFF) / 8;
            array[n] = array[n] | 1 << 7 - typecode % 8;
        }
        for (int j = 0; j < arraylength; ++j) {
            out.writeU8(array[j]);
        }
    }

    public void toWire(DNSOutput out) {
        if (this.types.isEmpty()) {
            return;
        }
        int mapbase = -1;
        TreeSet<Integer> map = new TreeSet<Integer>();
        for (Integer type : this.types) {
            int t = type;
            int base = t >> 8;
            if (base != mapbase) {
                if (!map.isEmpty()) {
                    TypeBitmap.mapToWire(out, map, mapbase);
                    map.clear();
                }
                mapbase = base;
            }
            map.add(t);
        }
        TypeBitmap.mapToWire(out, map, mapbase);
    }

    public boolean empty() {
        return this.types.isEmpty();
    }

    public boolean contains(int typecode) {
        return this.types.contains(typecode);
    }
}

