/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclientjava;

import java.io.IOException;
import java.net.Authenticator;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.BrowseFileTransferException;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemRequest;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.AuthScope;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.Credentials;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.DefaultNTLMProxyHandler;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.ECFHttpClientFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.HttpClientProxyCredentialProvider;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.HttpHost;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.IHttpClientContext;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.IHttpClientFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.INTLMProxyHandler;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.Messages;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.NTLMProxyDetector;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.UsernamePasswordCredentials;
import org.eclipse.ecf.provider.filetransfer.browse.AbstractFileSystemBrowser;
import org.eclipse.ecf.provider.filetransfer.browse.URLRemoteFile;
import org.eclipse.ecf.provider.filetransfer.httpclientjava.HttpClientOptions;
import org.eclipse.ecf.provider.filetransfer.httpclientjava.HttpClientRetrieveFileTransfer;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.osgi.util.NLS;

public class HttpClientFileSystemBrowser
extends AbstractFileSystemBrowser {
    private static final List<ThreadLocal<DateFormat>> DATE_PATTERNS = List.of(ThreadLocal.withInitial(() -> new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH)), ThreadLocal.withInitial(() -> new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.ENGLISH)), ThreadLocal.withInitial(() -> new SimpleDateFormat("EEE MMMd HH:mm:ss yyyy", Locale.ENGLISH)));
    public static final String LAST_MODIFIED_HEADER = "Last-Modified";
    public static final String CACHE_CONTROL_HEADER = "Cache-Control";
    public static final String CONTENT_LENGTH_HEADER = "Content-Length";
    protected static final int DEFAULT_CONNECTION_TIMEOUT = HttpClientOptions.BROWSE_DEFAULT_CONNECTION_TIMEOUT;
    private static final String USERNAME_PREFIX = "Username:";
    private JREProxyHelper proxyHelper = null;
    protected String username = null;
    protected String password = null;
    protected HttpClient httpClient = null;
    private HttpClientProxyCredentialProvider credentialsProvider;
    protected volatile IHttpClientContext httpContext;
    private volatile CompletableFuture<HttpResponse<Void>> asyncRequest;

    public HttpClientFileSystemBrowser(HttpClient httpClient, IFileID directoryOrFileID, IRemoteFileSystemListener listener, URL directoryOrFileURL, IConnectContext connectContext, Proxy proxy) {
        super(directoryOrFileID, listener, directoryOrFileURL, connectContext, proxy);
        Assert.isNotNull((Object)httpClient);
        this.httpClient = httpClient;
        this.credentialsProvider = new HttpClientProxyCredentialProvider(){

            @Override
            protected Proxy getECFProxy() {
                return HttpClientFileSystemBrowser.this.getProxy();
            }

            @Override
            protected boolean allowNTLMAuthentication() {
                DefaultNTLMProxyHandler.setSeenNTLM();
                return ECFHttpClientFactory.getNTLMProxyHandler(HttpClientFileSystemBrowser.this.httpContext).allowNTLMAuthentication(null);
            }
        };
        IHttpClientFactory httpClientFactory = Activator.getDefault().getHttpClientFactory();
        Authenticator contextCredentialsProvider = ECFHttpClientFactory.modifyCredentialsProvider(this.credentialsProvider);
        this.httpContext = httpClientFactory.newClientContext();
        this.httpContext.setCredentialsProvider(contextCredentialsProvider);
        this.proxyHelper = new JREProxyHelper();
    }

    protected IRemoteFileSystemRequest createRemoteFileSystemRequest() {
        return new HttpClientRemoteFileSystemRequest();
    }

    protected void cancel() {
        if (this.isCanceled()) {
            return;
        }
        this.setCanceled(this.getException());
        super.cancel();
        if (this.asyncRequest != null) {
            this.asyncRequest.cancel(true);
        }
    }

    protected void setupProxies() {
        if (this.proxy == null) {
            try {
                this.proxy = ProxySetupHelper.getSocksProxy((URL)this.directoryOrFile);
                if (this.proxy == null) {
                    this.proxy = ProxySetupHelper.getProxy((String)this.directoryOrFile.toExternalForm());
                }
            }
            catch (NoClassDefFoundError e) {
                Activator.logNoProxyWarning(e);
            }
        }
        if (this.proxy != null) {
            this.setupProxy(this.proxy);
        }
    }

    protected void cleanUp() {
        this.clearProxy();
        this.asyncRequest = null;
        super.cleanUp();
    }

    protected void runRequest() throws Exception {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclientjava", (String)"org.eclipse.ecf.provider.filetransfer/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"runRequest");
        String urlString = this.directoryOrFile.toString();
        HttpRequest.Builder requestConfigBuilder = Activator.getDefault().getHttpClientFactory().newRequestConfig(this.httpContext, null);
        requestConfigBuilder.timeout(Duration.ofMillis(DEFAULT_CONNECTION_TIMEOUT));
        requestConfigBuilder.uri(new URI(urlString));
        requestConfigBuilder.method("HEAD", HttpRequest.BodyPublishers.noBody());
        this.setupProxies();
        this.setupAuthentication(urlString);
        int maxAge = Integer.getInteger("org.eclipse.ecf.http.cache.max-age", 0);
        requestConfigBuilder.header(CACHE_CONTROL_HEADER, "max-age=" + maxAge);
        this.setupBasicAuthentication(requestConfigBuilder);
        HttpRequest request = requestConfigBuilder.build();
        long lastModified = 0L;
        OptionalLong fileLength = OptionalLong.empty();
        int code = -1;
        try {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclientjava", (String)("browse=" + urlString));
            this.asyncRequest = this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.discarding());
            HttpResponse<Void> response = this.asyncRequest.join();
            code = response.statusCode();
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclientjava", (String)("browse resp=" + code));
            boolean ntlmProxyFound = NTLMProxyDetector.detectNTLMProxy(this.httpContext);
            if (ntlmProxyFound) {
                this.getNTLMProxyHandler(this.httpContext).handleNTLMProxy(this.getProxy(), code);
            }
            if (NTLMProxyDetector.detectSPNEGOProxy(this.httpContext)) {
                this.getNTLMProxyHandler(this.httpContext).handleSPNEGOProxy(this.getProxy(), code);
            }
            if (code != 200) {
                if (code == 404) {
                    throw new BrowseFileTransferException(NLS.bind((String)"File not found: {0}", (Object)urlString), code);
                }
                if (code == 401) {
                    throw new BrowseFileTransferException(Messages.HttpClientRetrieveFileTransfer_Unauthorized, code);
                }
                if (code == 403) {
                    throw new BrowseFileTransferException("Forbidden", code);
                }
                if (code == 407) {
                    throw new BrowseFileTransferException(Messages.HttpClientRetrieveFileTransfer_Proxy_Auth_Required, code);
                }
                throw new BrowseFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_ERROR_GENERAL_RESPONSE_CODE, (Object)code), code);
            }
            fileLength = response.headers().firstValueAsLong(CONTENT_LENGTH_HEADER);
            lastModified = HttpClientFileSystemBrowser.getLastModifiedTimeFromHeader(response.headers());
            this.remoteFiles = new IRemoteFile[1];
            this.remoteFiles[0] = new URLRemoteFile(lastModified, fileLength.orElse(-1L), this.fileID);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof CompletionException) {
                t = e.getCause();
            }
            Trace.throwing((String)"org.eclipse.ecf.provider.filetransfer.httpclientjava", (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/throwing", ((Object)((Object)this)).getClass(), (String)"runRequest", (Throwable)t);
            BrowseFileTransferException ex = (BrowseFileTransferException)(t instanceof BrowseFileTransferException ? t : new BrowseFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)urlString), t, code));
            throw ex;
        }
    }

    private void setupBasicAuthentication(HttpRequest.Builder requestConfigBuilder) {
        if (this.username != null) {
            byte[] credentials = Base64.getEncoder().encode((String.valueOf(this.username) + ":" + this.password).getBytes(StandardCharsets.UTF_8));
            requestConfigBuilder.header("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
        }
    }

    private INTLMProxyHandler getNTLMProxyHandler(IHttpClientContext httpContext) {
        Object value = httpContext.getAttribute(ECFHttpClientFactory.NTLM_PROXY_HANDLER_ATTR);
        if (value instanceof INTLMProxyHandler) {
            return (INTLMProxyHandler)value;
        }
        return Activator.getDefault().getNTLMProxyHandler();
    }

    public static long getLastModifiedTimeFromHeader(HttpHeaders httpHeaders) throws IOException {
        String lastModifiedHeader = httpHeaders.firstValue(LAST_MODIFIED_HEADER).orElse(null);
        if (lastModifiedHeader == null) {
            return 0L;
        }
        if (lastModifiedHeader.length() > 1 && lastModifiedHeader.startsWith("'") && lastModifiedHeader.endsWith("'")) {
            lastModifiedHeader = lastModifiedHeader.substring(1, lastModifiedHeader.length() - 1);
        }
        for (ThreadLocal<DateFormat> dateFormat : DATE_PATTERNS) {
            try {
                return dateFormat.get().parse(lastModifiedHeader).getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw new IOException(Messages.HttpClientRetrieveFileTransfer_EXCEPITION_INVALID_LAST_MODIFIED_FROM_SERVER);
    }

    Proxy getProxy() {
        return this.proxy;
    }

    protected Credentials getFileRequestCredentials() throws UnsupportedCallbackException, IOException {
        if (this.connectContext == null) {
            return null;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return null;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        this.password = (String)passwordCallback.getObject();
        return new UsernamePasswordCredentials(this.username, this.password == null ? null : this.password.toCharArray());
    }

    protected void setupAuthentication(String urlString) throws UnsupportedCallbackException, IOException {
        Credentials credentials = null;
        if (this.username == null) {
            credentials = this.getFileRequestCredentials();
        }
        if (credentials != null && this.username != null) {
            AuthScope authScope = new AuthScope(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString));
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclientjava", (String)("browse credentials=" + credentials));
            this.credentialsProvider.setCredentials(authScope, credentials);
        }
    }

    protected void setupProxy(Proxy proxy) {
        if (proxy.getType().equals(Proxy.Type.HTTP)) {
            ProxyAddress address = proxy.getAddress();
            this.httpContext.setProxy(new HttpHost(address.getHostName(), address.getPort()));
        } else if (proxy.getType().equals(Proxy.Type.SOCKS)) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclientjava", (String)("browse socksproxy=" + proxy.getAddress()));
            this.httpContext.setProxy(null);
            this.proxyHelper.setupProxy(proxy);
        }
    }

    protected void clearProxy() {
        this.httpContext.setProxy(null);
    }

    class HttpClientRemoteFileSystemRequest
    extends AbstractFileSystemBrowser.RemoteFileSystemRequest {
        HttpClientRemoteFileSystemRequest() {
            super((AbstractFileSystemBrowser)HttpClientFileSystemBrowser.this);
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == null) {
                return null;
            }
            if (adapter.isInstance((Object)this)) {
                return adapter.cast((Object)this);
            }
            return null;
        }

        public void cancel() {
            HttpClientFileSystemBrowser.this.cancel();
        }
    }
}

