/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.predicates;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.functions.URIFunctions;
import org.polarsys.reqcycle.uri.model.IBusinessObject;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class IsInScopePredicate
implements Predicate<Pair<Link, Reachable>> {
    private IScope scope;
    private static IReachableManager manager = (IReachableManager)ZigguratInject.make(IReachableManager.class);

    public IsInScopePredicate(IScope scope) {
        this.scope = scope;
    }

    public boolean apply(Pair<Link, Reachable> arg0) {
        Reachable[] toTest;
        if (this.scope == null) {
            return true;
        }
        HashSet inScope = Sets.newHashSet(this.scope.getReachables());
        Function function = URIFunctions.newTrimFragmentFunction();
        Reachable[] reachableArray = toTest = new Reachable[]{(Reachable)function.apply((Object)arg0.getFirst().getSources().iterator().next()), (Reachable)function.apply((Object)arg0.getFirst().getTargets().iterator().next()), (Reachable)function.apply((Object)arg0.getFirst().getId())};
        int n = toTest.length;
        int n2 = 0;
        while (n2 < n) {
            Reachable r = reachableArray[n2];
            if (!inScope.contains(r)) {
                try {
                    ReachableObject object = manager.getHandlerFromReachable(r).getFromReachable(r);
                    IBusinessObject bo = (IBusinessObject)object.getAdapter(IBusinessObject.class);
                    if (bo == null || bo.exists()) {
                        return false;
                    }
                }
                catch (IReachableHandlerException iReachableHandlerException) {
                    System.out.println(" reachable issue");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return true;
    }
}

