/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.tikaparsing.picture;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PictureParser
extends AbstractParser {
    private String documentPath = null;
    private static final long serialVersionUID = 3947600565993469728L;

    public PictureParser(String docPath) {
        this.documentPath = docPath;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return Sets.newHashSet((Object[])new MediaType[]{MediaType.application((String)"/xhtml:html/xhtml:body/descendant::node()")});
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (this.documentPath != null) {
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String workspaceLocation = myWorkspaceRoot.getLocation().toOSString();
            String lastPart = this.documentPath.replace(workspaceLocation, "");
            Path path = new Path(lastPart);
            String projectName = path.segment(0);
            if (projectName != null) {
                IProject currentProject = myWorkspaceRoot.getProject(projectName);
                Path location = new Path(lastPart);
                IFile imageFile = currentProject.getFile(String.valueOf(location.lastSegment()) + "_" + metadata.get("resourceName"));
                try {
                    imageFile.create(stream, true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("strange: project is null for document path " + this.documentPath + " : bug?");
            }
        } else {
            System.out.println("document path is null. Pb with initialization of parser");
            return;
        }
    }
}

