/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf;

import java.awt.Color;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.apache.pdfbox.util.PositionWrapper;
import org.apache.pdfbox.util.ResourceLoader;
import org.apache.pdfbox.util.TextNormalize;
import org.apache.pdfbox.util.TextPosition;
import org.apache.pdfbox.util.TextPositionComparator;

public class Doc2ModelTextStripper
extends PDFStreamEngine {
    private static final String thisClassName;
    private static float DEFAULT_INDENT_THRESHOLD;
    private static float DEFAULT_DROP_THRESHOLD;
    protected final String systemLineSeparator;
    private String lineSeparator;
    private String pageSeparator;
    private String wordSeparator;
    private String paragraphStart;
    private String paragraphEnd;
    private String pageStart;
    private String pageEnd;
    private String articleStart;
    private String articleEnd;
    private int currentPageNo;
    private int startPage;
    private int endPage;
    private PDOutlineItem startBookmark;
    private int startBookmarkPageNumber;
    private PDOutlineItem endBookmark;
    private int endBookmarkPageNumber;
    private boolean suppressDuplicateOverlappingText;
    private boolean shouldSeparateByBeads;
    private boolean sortByPosition;
    private boolean addMoreFormatting;
    private float indentThreshold;
    private float dropThreshold;
    private float spacingTolerance;
    private float averageCharTolerance;
    private List<PDThreadBead> pageArticles;
    protected Vector<List<TextPosition>> charactersByArticle;
    private Map<String, List<TextPosition>> characterListMapping;
    protected String outputEncoding;
    protected PDDocument document;
    protected Writer output;
    private TextNormalize normalize;
    private boolean _inStyle;
    private StylizedTextPosition _previousTextPosition;
    private String previousLine;
    private static final float ENDOFLASTTEXTX_RESET_VALUE = -1.0f;
    private static final float MAXYFORLINE_RESET_VALUE = -3.4028235E38f;
    private static final float EXPECTEDSTARTOFNEXTWORDX_RESET_VALUE = -3.4028235E38f;
    private static final float MAXHEIGHTFORLINE_RESET_VALUE = -1.0f;
    private static final float MINYTOPFORLINE_RESET_VALUE = Float.MAX_VALUE;
    private static final float LASTWORDSPACING_RESET_VALUE = -1.0f;
    private static final String[] HEADER_LIST_ITEM_EXPRESSIONS;
    private List<Pattern> headerOrListPatterns;

    static {
        float f;
        thisClassName = Doc2ModelTextStripper.class.getSimpleName().toLowerCase();
        DEFAULT_INDENT_THRESHOLD = 2.0f;
        DEFAULT_DROP_THRESHOLD = 2.5f;
        String prop = String.valueOf(thisClassName) + ".indent";
        String s = System.getProperty(prop);
        if (s != null && s.length() > 0) {
            try {
                DEFAULT_INDENT_THRESHOLD = f = Float.parseFloat(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((s = System.getProperty(prop = String.valueOf(thisClassName) + ".drop")) != null && s.length() > 0) {
            try {
                DEFAULT_DROP_THRESHOLD = f = Float.parseFloat(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        HEADER_LIST_ITEM_EXPRESSIONS = new String[]{"\\d+\\.\\d+\\.\\d+.+", "\\d+\\-\\d+\\-\\d+.+", "\\d+\\*\\d+\\*\\d+.+", "\\d+\\.\\d+.+", "\\d+\\-\\d+.+", "\\d+\\*\\d+.+", "\\d+.+", "[A-Z]\\-.+", "[A-Z]\\..+", "[A-Z]\\*.+", "[a-z]\\-.+", "[a-z]\\..+", "[a-z]\\*.+", "[IVXL]+\\-.+", "[IVXL]+\\..+", "[IVXL]+\\*.+", "[ivxl]+\\-.+", "[ivxl]+\\..+", "[ivxl]+\\*.+"};
    }

    public Doc2ModelTextStripper() throws IOException {
        super(ResourceLoader.loadProperties((String)"org/apache/pdfbox/resources/PageDrawer.properties", (boolean)true));
        this.lineSeparator = this.systemLineSeparator = System.getProperty("line.separator");
        this.pageSeparator = this.systemLineSeparator;
        this.wordSeparator = " ";
        this.paragraphStart = "";
        this.paragraphEnd = "";
        this.pageStart = "";
        this.pageEnd = this.pageSeparator;
        this.articleStart = "";
        this.articleEnd = "";
        this.currentPageNo = 0;
        this.startPage = 1;
        this.endPage = Integer.MAX_VALUE;
        this.startBookmark = null;
        this.startBookmarkPageNumber = -1;
        this.endBookmark = null;
        this.endBookmarkPageNumber = -1;
        this.suppressDuplicateOverlappingText = true;
        this.shouldSeparateByBeads = true;
        this.sortByPosition = false;
        this.addMoreFormatting = false;
        this.indentThreshold = DEFAULT_INDENT_THRESHOLD;
        this.dropThreshold = DEFAULT_DROP_THRESHOLD;
        this.spacingTolerance = 0.5f;
        this.averageCharTolerance = 0.3f;
        this.pageArticles = null;
        this.charactersByArticle = new Vector();
        this.characterListMapping = new HashMap<String, List<TextPosition>>();
        this.normalize = null;
        this._inStyle = false;
        this._previousTextPosition = null;
        this.previousLine = "";
        this.headerOrListPatterns = null;
        this.outputEncoding = null;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public Doc2ModelTextStripper(Properties props) throws IOException {
        super(props);
        this.lineSeparator = this.systemLineSeparator = System.getProperty("line.separator");
        this.pageSeparator = this.systemLineSeparator;
        this.wordSeparator = " ";
        this.paragraphStart = "";
        this.paragraphEnd = "";
        this.pageStart = "";
        this.pageEnd = this.pageSeparator;
        this.articleStart = "";
        this.articleEnd = "";
        this.currentPageNo = 0;
        this.startPage = 1;
        this.endPage = Integer.MAX_VALUE;
        this.startBookmark = null;
        this.startBookmarkPageNumber = -1;
        this.endBookmark = null;
        this.endBookmarkPageNumber = -1;
        this.suppressDuplicateOverlappingText = true;
        this.shouldSeparateByBeads = true;
        this.sortByPosition = false;
        this.addMoreFormatting = false;
        this.indentThreshold = DEFAULT_INDENT_THRESHOLD;
        this.dropThreshold = DEFAULT_DROP_THRESHOLD;
        this.spacingTolerance = 0.5f;
        this.averageCharTolerance = 0.3f;
        this.pageArticles = null;
        this.charactersByArticle = new Vector();
        this.characterListMapping = new HashMap<String, List<TextPosition>>();
        this.normalize = null;
        this._inStyle = false;
        this._previousTextPosition = null;
        this.previousLine = "";
        this.headerOrListPatterns = null;
        this.outputEncoding = null;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public Doc2ModelTextStripper(String encoding) throws IOException {
        super(ResourceLoader.loadProperties((String)"org/apache/pdfbox/resources/PDFTextStripper.properties", (boolean)true));
        this.lineSeparator = this.systemLineSeparator = System.getProperty("line.separator");
        this.pageSeparator = this.systemLineSeparator;
        this.wordSeparator = " ";
        this.paragraphStart = "";
        this.paragraphEnd = "";
        this.pageStart = "";
        this.pageEnd = this.pageSeparator;
        this.articleStart = "";
        this.articleEnd = "";
        this.currentPageNo = 0;
        this.startPage = 1;
        this.endPage = Integer.MAX_VALUE;
        this.startBookmark = null;
        this.startBookmarkPageNumber = -1;
        this.endBookmark = null;
        this.endBookmarkPageNumber = -1;
        this.suppressDuplicateOverlappingText = true;
        this.shouldSeparateByBeads = true;
        this.sortByPosition = false;
        this.addMoreFormatting = false;
        this.indentThreshold = DEFAULT_INDENT_THRESHOLD;
        this.dropThreshold = DEFAULT_DROP_THRESHOLD;
        this.spacingTolerance = 0.5f;
        this.averageCharTolerance = 0.3f;
        this.pageArticles = null;
        this.charactersByArticle = new Vector();
        this.characterListMapping = new HashMap<String, List<TextPosition>>();
        this.normalize = null;
        this._inStyle = false;
        this._previousTextPosition = null;
        this.previousLine = "";
        this.headerOrListPatterns = null;
        this.outputEncoding = encoding;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public String getText(PDDocument doc) throws IOException {
        StringWriter outputStream = new StringWriter();
        this.writeText(doc, (Writer)outputStream);
        return outputStream.toString();
    }

    public String getText(COSDocument doc) throws IOException {
        return this.getText(new PDDocument(doc));
    }

    public void writeText(COSDocument doc, Writer outputStream) throws IOException {
        this.writeText(new PDDocument(doc), outputStream);
    }

    public void resetEngine() {
        super.resetEngine();
        this.currentPageNo = 0;
    }

    public void writeText(PDDocument doc, Writer outputStream) throws IOException {
        this.resetEngine();
        this.document = doc;
        this.output = outputStream;
        if (this.getAddMoreFormatting()) {
            this.paragraphEnd = this.lineSeparator;
            this.pageStart = this.lineSeparator;
            this.articleStart = this.lineSeparator;
            this.articleEnd = this.lineSeparator;
        }
        this.startDocument(this.document);
        if (this.document.isEncrypted()) {
            try {
                this.document.decrypt("");
            }
            catch (CryptographyException e) {
                throw new WrappedIOException("Error decrypting document, details: ", (Throwable)e);
            }
            catch (InvalidPasswordException e) {
                throw new WrappedIOException("Error: document is encrypted", (Throwable)e);
            }
        }
        this.processPages(this.document.getDocumentCatalog().getAllPages());
        this.endDocument(this.document);
    }

    protected void processPages(List<COSObjectable> pages) throws IOException {
        if (this.startBookmark != null) {
            this.startBookmarkPageNumber = this.getPageNumber(this.startBookmark, pages);
        }
        if (this.endBookmark != null) {
            this.endBookmarkPageNumber = this.getPageNumber(this.endBookmark, pages);
        }
        if (this.startBookmarkPageNumber == -1 && this.startBookmark != null && this.endBookmarkPageNumber == -1 && this.endBookmark != null && this.startBookmark.getCOSObject() == this.endBookmark.getCOSObject()) {
            this.startBookmarkPageNumber = 0;
            this.endBookmarkPageNumber = 0;
        }
        for (PDPage pDPage : pages) {
            PDStream contentStream = pDPage.getContents();
            ++this.currentPageNo;
            if (contentStream == null) continue;
            COSStream contents = contentStream.getStream();
            this.processPage(pDPage, contents);
        }
    }

    private int getPageNumber(PDOutlineItem bookmark, List<COSObjectable> allPages) throws IOException {
        int pageNumber = -1;
        PDPage page = bookmark.findDestinationPage(this.document);
        if (page != null) {
            pageNumber = allPages.indexOf(page) + 1;
        }
        return pageNumber;
    }

    protected void startDocument(PDDocument pdf) throws IOException {
    }

    protected void endDocument(PDDocument pdf) throws IOException {
    }

    protected void processPage(PDPage page, COSStream content) throws IOException {
        if (!(this.currentPageNo < this.startPage || this.currentPageNo > this.endPage || this.startBookmarkPageNumber != -1 && this.currentPageNo < this.startBookmarkPageNumber || this.endBookmarkPageNumber != -1 && this.currentPageNo > this.endBookmarkPageNumber)) {
            this.startPage(page);
            this.pageArticles = page.getThreadBeads();
            int numberOfArticleSections = 1 + this.pageArticles.size() * 2;
            if (!this.shouldSeparateByBeads) {
                numberOfArticleSections = 1;
            }
            int originalSize = this.charactersByArticle.size();
            this.charactersByArticle.setSize(numberOfArticleSections);
            int i = 0;
            while (i < numberOfArticleSections) {
                if (numberOfArticleSections < originalSize) {
                    this.charactersByArticle.get(i).clear();
                } else {
                    this.charactersByArticle.set(i, new ArrayList());
                }
                ++i;
            }
            this.characterListMapping.clear();
            this.processStream(page, page.findResources(), content);
            this.writePage();
            this.endPage(page);
        }
    }

    protected void startArticle() throws IOException {
        this.startArticle(true);
    }

    protected void startArticle(boolean isltr) throws IOException {
        this.output.write(this.getArticleStart());
    }

    protected void endArticle() throws IOException {
        this.output.write(this.getArticleEnd());
    }

    protected void startPage(PDPage page) throws IOException {
    }

    protected void endPage(PDPage page) throws IOException {
    }

    protected void writePage() throws IOException {
        float maxYForLine = -3.4028235E38f;
        float minYTopForLine = Float.MAX_VALUE;
        float endOfLastTextX = -1.0f;
        float lastWordSpacing = -1.0f;
        float maxHeightForLine = -1.0f;
        PositionWrapper lastPosition = null;
        PositionWrapper lastLineStartPosition = null;
        boolean startOfPage = true;
        boolean startOfArticle = true;
        if (this.charactersByArticle.size() > 0) {
            this.writePageStart();
        }
        int i = 0;
        while (i < this.charactersByArticle.size()) {
            List<TextPosition> textList = this.charactersByArticle.get(i);
            if (this.getSortByPosition()) {
                TextPositionComparator comparator = new TextPositionComparator();
                Collections.sort(textList, comparator);
            }
            Iterator<TextPosition> textIter = textList.iterator();
            int ltrCnt = 0;
            int rtlCnt = 0;
            while (textIter.hasNext()) {
                TextPosition position = textIter.next();
                String stringValue = position.getCharacter();
                int a = 0;
                while (a < stringValue.length()) {
                    byte dir = Character.getDirectionality(stringValue.charAt(a));
                    if (dir == 0 || dir == 14 || dir == 15) {
                        ++ltrCnt;
                    } else if (dir == 1 || dir == 2 || dir == 16 || dir == 17) {
                        ++rtlCnt;
                    }
                    ++a;
                }
            }
            boolean isRtlDominant = rtlCnt > ltrCnt;
            this.startArticle(!isRtlDominant);
            startOfArticle = true;
            boolean hasRtl = rtlCnt > 0;
            ArrayList<TextPosition> line = new ArrayList<TextPosition>();
            new ArrayList();
            textIter = textList.iterator();
            float previousAveCharWidth = -1.0f;
            while (textIter.hasNext()) {
                float positionHeight;
                float positionWidth;
                float positionY;
                float positionX;
                TextPosition position = textIter.next();
                PositionWrapper current = new PositionWrapper(position);
                String characterValue = position.getCharacter();
                if (lastPosition != null && (position.getFont() != lastPosition.getTextPosition().getFont() || position.getFontSize() != lastPosition.getTextPosition().getFontSize())) {
                    previousAveCharWidth = -1.0f;
                }
                if (this.getSortByPosition()) {
                    positionX = position.getXDirAdj();
                    positionY = position.getYDirAdj();
                    positionWidth = position.getWidthDirAdj();
                    positionHeight = position.getHeightDir();
                } else {
                    positionX = position.getX();
                    positionY = position.getY();
                    positionWidth = position.getWidth();
                    positionHeight = position.getHeight();
                }
                int wordCharCount = position.getIndividualWidths().length;
                float wordSpacing = position.getWidthOfSpace();
                float deltaSpace = 0.0f;
                deltaSpace = wordSpacing == 0.0f || wordSpacing == Float.NaN ? Float.MAX_VALUE : (lastWordSpacing < 0.0f ? wordSpacing * this.getSpacingTolerance() : (wordSpacing + lastWordSpacing) / 2.0f * this.getSpacingTolerance());
                float averageCharWidth = -1.0f;
                averageCharWidth = previousAveCharWidth < 0.0f ? positionWidth / (float)wordCharCount : (previousAveCharWidth + positionWidth / (float)wordCharCount) / 2.0f;
                float deltaCharWidth = averageCharWidth * this.getAverageCharTolerance();
                float expectedStartOfNextWordX = -3.4028235E38f;
                if (endOfLastTextX != -1.0f) {
                    expectedStartOfNextWordX = deltaCharWidth > deltaSpace ? endOfLastTextX + deltaSpace : endOfLastTextX + deltaCharWidth;
                }
                if (lastPosition != null) {
                    if (startOfArticle) {
                        lastPosition.setArticleStart();
                        startOfArticle = false;
                    }
                    if (!this.overlap(positionY, positionHeight, maxYForLine, maxHeightForLine)) {
                        String str = this.writeLine(line, isRtlDominant, hasRtl, isRtlDominant);
                        line.clear();
                        lastLineStartPosition = this.handleLineSeparation(current, lastPosition, lastLineStartPosition, maxHeightForLine, str);
                        endOfLastTextX = -1.0f;
                        expectedStartOfNextWordX = -3.4028235E38f;
                        maxYForLine = -3.4028235E38f;
                        maxHeightForLine = -1.0f;
                        minYTopForLine = Float.MAX_VALUE;
                    }
                    if (expectedStartOfNextWordX != -3.4028235E38f && expectedStartOfNextWordX < positionX && lastPosition.getTextPosition().getCharacter() != null && !lastPosition.getTextPosition().getCharacter().endsWith(" ")) {
                        line.add(WordSeparator.getSeparator());
                    }
                }
                if (positionY >= maxYForLine) {
                    maxYForLine = positionY;
                }
                endOfLastTextX = positionX + positionWidth;
                if (characterValue != null) {
                    if (startOfPage && lastPosition == null) {
                        this.writeParagraphStart();
                    }
                    line.add(position);
                }
                maxHeightForLine = Math.max(maxHeightForLine, positionHeight);
                minYTopForLine = Math.min(minYTopForLine, positionY - positionHeight);
                lastPosition = current;
                if (startOfPage) {
                    lastPosition.setParagraphStart();
                    lastPosition.setLineStart();
                    lastLineStartPosition = lastPosition;
                    startOfPage = false;
                }
                lastWordSpacing = wordSpacing;
                previousAveCharWidth = averageCharWidth;
            }
            if (line.size() > 0) {
                this.writeLine(line, isRtlDominant, hasRtl, isRtlDominant);
                if (this._inStyle) {
                    this._inStyle = false;
                }
                this.writeStyleEnd();
                this.writeParagraphEnd();
            }
            this.endArticle();
            ++i;
        }
        this.writePageEnd();
    }

    private boolean overlap(float y1, float height1, float y2, float height2) {
        return this.within(y1, y2, 0.1f) || y2 <= y1 && y2 >= y1 - height1 || y1 <= y2 && y1 >= y2 - height2;
    }

    protected void writePageSeperator() throws IOException {
        this.output.write(this.getPageSeparator());
        this.output.flush();
    }

    protected void writeLineSeparator() throws IOException {
        this.output.write(this.getLineSeparator());
    }

    protected void writeWordSeparator() throws IOException {
        this.output.write(this.getWordSeparator());
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        this.output.write(text.getCharacter());
    }

    protected void writeString(String text) throws IOException {
        this.output.write(text);
    }

    private boolean within(float first, float second, float variance) {
        return second < first + variance && second > first - variance;
    }

    protected void processTextPosition(TextPosition rawtext) {
        int i;
        StylizedTextPosition text = this.processStyle(rawtext);
        boolean showCharacter = true;
        if (this.suppressDuplicateOverlappingText) {
            showCharacter = false;
            String textCharacter = text.getCharacter();
            float textX = text.getX();
            float textY = text.getY();
            List<TextPosition> sameTextCharacters = this.characterListMapping.get(textCharacter);
            if (sameTextCharacters == null) {
                sameTextCharacters = new ArrayList<TextPosition>();
                this.characterListMapping.put(textCharacter, sameTextCharacters);
            }
            boolean suppressCharacter = false;
            float tolerance = text.getWidth() / (float)textCharacter.length() / 3.0f;
            i = 0;
            while (i < sameTextCharacters.size() && textCharacter != null) {
                TextPosition character = sameTextCharacters.get(i);
                String charCharacter = character.getCharacter();
                float charX = character.getX();
                float charY = character.getY();
                if (charCharacter != null && this.within(charX, textX, tolerance) && this.within(charY, textY, tolerance)) {
                    suppressCharacter = true;
                }
                ++i;
            }
            if (!suppressCharacter) {
                sameTextCharacters.add(text);
                showCharacter = true;
            }
        }
        if (showCharacter) {
            int foundArticleDivisionIndex = -1;
            int notFoundButFirstLeftAndAboveArticleDivisionIndex = -1;
            int notFoundButFirstLeftArticleDivisionIndex = -1;
            int notFoundButFirstAboveArticleDivisionIndex = -1;
            float x = text.getX();
            float y = text.getY();
            if (this.shouldSeparateByBeads) {
                i = 0;
                while (i < this.pageArticles.size() && foundArticleDivisionIndex == -1) {
                    PDThreadBead bead = this.pageArticles.get(i);
                    if (bead != null) {
                        PDRectangle rect = bead.getRectangle();
                        if (rect.contains(x, y)) {
                            foundArticleDivisionIndex = i * 2 + 1;
                        } else if ((x < rect.getLowerLeftX() || y < rect.getUpperRightY()) && notFoundButFirstLeftAndAboveArticleDivisionIndex == -1) {
                            notFoundButFirstLeftAndAboveArticleDivisionIndex = i * 2;
                        } else if (x < rect.getLowerLeftX() && notFoundButFirstLeftArticleDivisionIndex == -1) {
                            notFoundButFirstLeftArticleDivisionIndex = i * 2;
                        } else if (y < rect.getUpperRightY() && notFoundButFirstAboveArticleDivisionIndex == -1) {
                            notFoundButFirstAboveArticleDivisionIndex = i * 2;
                        }
                    } else {
                        foundArticleDivisionIndex = 0;
                    }
                    ++i;
                }
            } else {
                foundArticleDivisionIndex = 0;
            }
            int articleDivisionIndex = -1;
            articleDivisionIndex = foundArticleDivisionIndex != -1 ? foundArticleDivisionIndex : (notFoundButFirstLeftAndAboveArticleDivisionIndex != -1 ? notFoundButFirstLeftAndAboveArticleDivisionIndex : (notFoundButFirstLeftArticleDivisionIndex != -1 ? notFoundButFirstLeftArticleDivisionIndex : (notFoundButFirstAboveArticleDivisionIndex != -1 ? notFoundButFirstAboveArticleDivisionIndex : this.charactersByArticle.size() - 1)));
            List<TextPosition> textList = this.charactersByArticle.get(articleDivisionIndex);
            if (textList.isEmpty()) {
                textList.add(text);
            } else {
                TextPosition previousTextPosition = textList.get(textList.size() - 1);
                if (text.isDiacritic() && previousTextPosition.contains((TextPosition)text)) {
                    previousTextPosition.mergeDiacritic((TextPosition)text, this.normalize);
                } else if (previousTextPosition.isDiacritic() && text.contains(previousTextPosition)) {
                    text.mergeDiacritic(previousTextPosition, this.normalize);
                    textList.remove(textList.size() - 1);
                    textList.add(text);
                } else {
                    textList.add(text);
                }
            }
        }
    }

    protected void writeStyleStart(Color fontColor, float fontSize, boolean bold) throws IOException {
    }

    protected void writeStyleEnd() throws IOException {
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPageValue) {
        this.startPage = startPageValue;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPageValue) {
        this.endPage = endPageValue;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setPageSeparator(String separator) {
        this.pageSeparator = separator;
    }

    public String getWordSeparator() {
        return this.wordSeparator;
    }

    public void setWordSeparator(String separator) {
        this.wordSeparator = separator;
    }

    public String getPageSeparator() {
        return this.pageSeparator;
    }

    public boolean getSuppressDuplicateOverlappingText() {
        return this.suppressDuplicateOverlappingText;
    }

    protected int getCurrentPageNo() {
        return this.currentPageNo;
    }

    protected Writer getOutput() {
        return this.output;
    }

    protected Vector<List<TextPosition>> getCharactersByArticle() {
        return this.charactersByArticle;
    }

    public void setSuppressDuplicateOverlappingText(boolean suppressDuplicateOverlappingTextValue) {
        this.suppressDuplicateOverlappingText = suppressDuplicateOverlappingTextValue;
    }

    public boolean getSeparateByBeads() {
        return this.shouldSeparateByBeads;
    }

    public void setShouldSeparateByBeads(boolean aShouldSeparateByBeads) {
        this.shouldSeparateByBeads = aShouldSeparateByBeads;
    }

    public PDOutlineItem getEndBookmark() {
        return this.endBookmark;
    }

    public void setEndBookmark(PDOutlineItem aEndBookmark) {
        this.endBookmark = aEndBookmark;
    }

    public PDOutlineItem getStartBookmark() {
        return this.startBookmark;
    }

    public void setStartBookmark(PDOutlineItem aStartBookmark) {
        this.startBookmark = aStartBookmark;
    }

    public boolean getAddMoreFormatting() {
        return this.addMoreFormatting;
    }

    public void setAddMoreFormatting(boolean newAddMoreFormatting) {
        this.addMoreFormatting = newAddMoreFormatting;
    }

    public boolean getSortByPosition() {
        return this.sortByPosition;
    }

    public void setSortByPosition(boolean newSortByPosition) {
        this.sortByPosition = newSortByPosition;
    }

    public float getSpacingTolerance() {
        return this.spacingTolerance;
    }

    public void setSpacingTolerance(float spacingToleranceValue) {
        this.spacingTolerance = spacingToleranceValue;
    }

    public float getAverageCharTolerance() {
        return this.averageCharTolerance;
    }

    public void setAverageCharTolerance(float averageCharToleranceValue) {
        this.averageCharTolerance = averageCharToleranceValue;
    }

    public float getIndentThreshold() {
        return this.indentThreshold;
    }

    public void setIndentThreshold(float indentThreshold) {
        this.indentThreshold = indentThreshold;
    }

    public float getDropThreshold() {
        return this.dropThreshold;
    }

    public void setDropThreshold(float dropThreshold) {
        this.dropThreshold = dropThreshold;
    }

    public String getParagraphStart() {
        return this.paragraphStart;
    }

    public void setParagraphStart(String s) {
        this.paragraphStart = s;
    }

    public String getParagraphEnd() {
        return this.paragraphEnd;
    }

    public void setParagraphEnd(String s) {
        this.paragraphEnd = s;
    }

    public String getPageStart() {
        return this.pageStart;
    }

    public void setPageStart(String pageStart) {
        this.pageStart = pageStart;
    }

    public String getPageEnd() {
        return this.pageEnd;
    }

    public void setPageEnd(String pageEnd) {
        this.pageEnd = pageEnd;
    }

    public String getArticleStart() {
        return this.articleStart;
    }

    public void setArticleStart(String articleStart) {
        this.articleStart = articleStart;
    }

    public String getArticleEnd() {
        return this.articleEnd;
    }

    public void setArticleEnd(String articleEnd) {
        this.articleEnd = articleEnd;
    }

    public String inspectFontEncoding(String str) {
        if (!this.sortByPosition || str == null || str.length() < 2) {
            return str;
        }
        int i = 0;
        while (i < str.length()) {
            if (Character.getDirectionality(str.charAt(i)) != 2) {
                return str;
            }
            ++i;
        }
        StringBuilder reversed = new StringBuilder(str.length());
        int i2 = str.length() - 1;
        while (i2 >= 0) {
            reversed.append(str.charAt(i2));
            --i2;
        }
        return reversed.toString();
    }

    protected PositionWrapper handleLineSeparation(PositionWrapper current, PositionWrapper lastPosition, PositionWrapper lastLineStartPosition, float maxHeightForLine, String str) throws IOException {
        current.setLineStart();
        this.isParagraphSeparation(current, lastPosition, lastLineStartPosition, maxHeightForLine, str);
        lastLineStartPosition = current;
        if (current.isParagraphStart()) {
            if (lastPosition.isArticleStart()) {
                this.writeParagraphStart();
            } else {
                this.writeLineSeparator();
                this.writeParagraphSeparator();
            }
        } else {
            this.writeLineSeparator();
        }
        return lastLineStartPosition;
    }

    protected void isParagraphSeparation(PositionWrapper position, PositionWrapper lastPosition, PositionWrapper lastLineStartPosition, float maxHeightForLine, String str) {
        boolean result = false;
        if (lastLineStartPosition == null || this.previousLine.replaceAll("\\s", "").isEmpty()) {
            result = true;
        } else {
            Pattern currentPattern;
            float yGap = Math.abs(position.getTextPosition().getYDirAdj() - lastPosition.getTextPosition().getYDirAdj());
            float xGap = position.getTextPosition().getXDirAdj() - lastLineStartPosition.getTextPosition().getXDirAdj();
            if (yGap > this.getDropThreshold() * maxHeightForLine) {
                result = true;
            } else if (xGap > this.getIndentThreshold() * position.getTextPosition().getWidthOfSpace()) {
                position.setHangingIndent();
                result = true;
            } else if (xGap < -position.getTextPosition().getWidthOfSpace()) {
                result = true;
            } else if (!result && (currentPattern = Doc2ModelTextStripper.matchPattern(str, this.getHeaderOrListItemPatterns())) != null) {
                result = true;
            }
        }
        this.previousLine = str;
        if (result) {
            position.setParagraphStart();
        }
    }

    protected void writeParagraphSeparator() throws IOException {
        if (this._inStyle) {
            this._inStyle = false;
        }
        this.writeStyleEnd();
        this.writeParagraphEnd();
        this.writeParagraphStart();
    }

    protected void writeParagraphStart() throws IOException {
        this.output.write(this.getParagraphStart());
    }

    protected void writeParagraphEnd() throws IOException {
        this.output.write(this.getParagraphEnd());
    }

    protected void writePageStart() throws IOException {
        this.output.write(this.getPageStart());
    }

    protected void writePageEnd() throws IOException {
        this.output.write(this.getPageEnd());
    }

    protected void setHeaderOrListItemPatterns(List<Pattern> patterns) {
        this.headerOrListPatterns = patterns;
    }

    protected List<Pattern> getHeaderOrListItemPatterns() {
        if (this.headerOrListPatterns == null) {
            this.headerOrListPatterns = new ArrayList<Pattern>();
            String[] stringArray = HEADER_LIST_ITEM_EXPRESSIONS;
            int n = HEADER_LIST_ITEM_EXPRESSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String expression = stringArray[n2];
                Pattern p = Pattern.compile(expression);
                this.headerOrListPatterns.add(p);
                ++n2;
            }
        }
        return this.headerOrListPatterns;
    }

    protected static final Pattern matchPattern(String s, List<Pattern> patterns) {
        Pattern matchedPattern = null;
        for (Pattern p : patterns) {
            if (!p.matcher(s).matches()) continue;
            return p;
        }
        return matchedPattern;
    }

    private String writeLine(List<TextPosition> line, boolean isRtlDominant, boolean hasRtl, boolean isRtlDominant2) throws IOException {
        LinkedList<String> normalized = new LinkedList<String>();
        StringBuilder lineBuilder = new StringBuilder();
        for (TextPosition text : line) {
            if (text instanceof WordSeparator) {
                String lineStr = lineBuilder.toString();
                if (hasRtl) {
                    lineStr = this.normalize.makeLineLogicalOrder(lineStr, isRtlDominant);
                }
                lineStr = this.normalize.normalizePres(lineStr);
                normalized.add(lineStr);
                lineBuilder = new StringBuilder();
                continue;
            }
            StylizedTextPosition stxt = (StylizedTextPosition)text;
            if (stxt.getCharacter().replaceAll("\\s", "").length() > 0) {
                if (this._inStyle) {
                    if (!stxt.hasSameStyle(this._previousTextPosition)) {
                        int i;
                        if (lineBuilder.length() > 0) {
                            String lineStr = lineBuilder.toString();
                            if (hasRtl) {
                                lineStr = this.normalize.makeLineLogicalOrder(lineStr, isRtlDominant);
                            }
                            lineStr = this.normalize.normalizePres(lineStr);
                            normalized.add(lineStr);
                        }
                        int numberOfStrings = normalized.size();
                        if (isRtlDominant) {
                            i = numberOfStrings - 1;
                            while (i >= 0) {
                                if (i < numberOfStrings - 1) {
                                    this.writeWordSeparator();
                                }
                                this.writeString((String)normalized.get(i));
                                --i;
                            }
                        } else {
                            i = 0;
                            while (i < numberOfStrings) {
                                this.writeString((String)normalized.get(i));
                                if (!isRtlDominant && i < numberOfStrings - 1) {
                                    this.writeWordSeparator();
                                }
                                ++i;
                            }
                        }
                        normalized.clear();
                        lineBuilder = new StringBuilder();
                        this.writeStyleEnd();
                        this.writeStyleStart(stxt.getFontColor(), stxt.getFontSizeInPt(), stxt.isBold());
                    }
                } else {
                    this._inStyle = true;
                    this.writeStyleStart(stxt.getFontColor(), stxt.getFontSizeInPt(), stxt.isBold());
                }
                this._previousTextPosition = stxt;
            }
            lineBuilder.append(stxt.getCharacter());
        }
        if (lineBuilder.length() > 0) {
            String lineStr = lineBuilder.toString();
            if (hasRtl) {
                lineStr = this.normalize.makeLineLogicalOrder(lineStr, isRtlDominant);
            }
            lineStr = this.normalize.normalizePres(lineStr);
            normalized.add(lineStr);
        }
        int numberOfStrings = normalized.size();
        if (isRtlDominant) {
            int i = numberOfStrings - 1;
            while (i >= 0) {
                if (i < numberOfStrings - 1) {
                    this.writeWordSeparator();
                }
                this.writeString((String)normalized.get(i));
                --i;
            }
        } else {
            int i = 0;
            while (i < numberOfStrings) {
                this.writeString((String)normalized.get(i));
                if (!isRtlDominant && i < numberOfStrings - 1) {
                    this.writeWordSeparator();
                }
                ++i;
            }
        }
        normalized.clear();
        this.writeStyleEnd();
        return lineBuilder.toString();
    }

    private List<String> normalize(List<TextPosition> line, boolean isRtlDominant, boolean hasRtl) {
        LinkedList<String> normalized = new LinkedList<String>();
        StringBuilder lineBuilder = new StringBuilder();
        for (TextPosition text : line) {
            if (text instanceof WordSeparator) {
                String lineStr = lineBuilder.toString();
                if (hasRtl) {
                    lineStr = this.normalize.makeLineLogicalOrder(lineStr, isRtlDominant);
                }
                lineStr = this.normalize.normalizePres(lineStr);
                normalized.add(lineStr);
                lineBuilder = new StringBuilder();
                continue;
            }
            lineBuilder.append(text.getCharacter());
        }
        if (lineBuilder.length() > 0) {
            String lineStr = lineBuilder.toString();
            if (hasRtl) {
                lineStr = this.normalize.makeLineLogicalOrder(lineStr, isRtlDominant);
            }
            lineStr = this.normalize.normalizePres(lineStr);
            normalized.add(lineStr);
        }
        return normalized;
    }

    protected StylizedTextPosition processStyle(TextPosition text) {
        StylizedTextPosition ret = new StylizedTextPosition(text, new Color(0));
        try {
            Color color = this.getGraphicsState().getStrokingColor().getJavaColor();
            ret = new StylizedTextPosition(text, color);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return ret;
    }

    public class StylizedTextPosition
    extends TextPosition {
        private TextPosition _text;
        private Color _fontColor = new Color(0);

        public StylizedTextPosition(TextPosition text, Color fontColor) {
            this._text = text;
            this._fontColor = fontColor;
        }

        public boolean hasSameStyle(StylizedTextPosition stext) {
            return stext.getFontSize() == this._text.getFontSize() && stext._fontColor.getRGB() == this._fontColor.getRGB() && stext.isBold() == this.isBold();
        }

        public boolean isBold() {
            PDFontDescriptor descriptor = this._text.getFont().getFontDescriptor();
            if (descriptor != null) {
                return this._text.getFont().getFontDescriptor().getFontWeight() > 400.0f;
            }
            return false;
        }

        public Color getFontColor() {
            return this._fontColor;
        }

        public String toString() {
            return this._text.toString();
        }

        public boolean contains(TextPosition arg0) {
            return this._text.contains(arg0);
        }

        public String getCharacter() {
            return this._text.getCharacter();
        }

        public int[] getCodePoints() {
            return this._text.getCodePoints();
        }

        public float getDir() {
            return this._text.getDir();
        }

        public PDFont getFont() {
            return this._text.getFont();
        }

        public float getFontSize() {
            return this._text.getFontSize();
        }

        public float getFontSizeInPt() {
            return this._text.getFontSizeInPt();
        }

        public float getHeight() {
            return this._text.getHeight();
        }

        public float getHeightDir() {
            return this._text.getHeightDir();
        }

        public float[] getIndividualWidths() {
            return this._text.getIndividualWidths();
        }

        public Matrix getTextPos() {
            return this._text.getTextPos();
        }

        public float getWidth() {
            return this._text.getWidth();
        }

        public float getWidthDirAdj() {
            return this._text.getWidthDirAdj();
        }

        public float getWidthOfSpace() {
            return this._text.getWidthOfSpace();
        }

        public float getWordSpacing() {
            return this._text.getWordSpacing();
        }

        public float getX() {
            return this._text.getX();
        }

        public float getXDirAdj() {
            return this._text.getXDirAdj();
        }

        public float getXScale() {
            return this._text.getXScale();
        }

        public float getY() {
            return this._text.getY();
        }

        public float getYDirAdj() {
            return this._text.getYDirAdj();
        }

        public float getYScale() {
            return this._text.getYScale();
        }

        public boolean isDiacritic() {
            return this._text.isDiacritic();
        }

        public void mergeDiacritic(TextPosition arg0, TextNormalize arg1) {
            this._text.mergeDiacritic(arg0, arg1);
        }
    }

    private static final class WordSeparator
    extends TextPosition {
        private static final WordSeparator separator = new WordSeparator();

        private WordSeparator() {
        }

        public static final WordSeparator getSeparator() {
            return separator;
        }
    }
}

