/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.iterators.collectors;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.polarsys.reqcycle.utils.iterators.Activator;
import org.polarsys.reqcycle.utils.iterators.collectors.Harvester;
import org.polarsys.reqcycle.utils.iterators.exceptions.CannotHandleException;
import org.polarsys.reqcycle.utils.iterators.exceptions.CollectionAbortedException;
import org.polarsys.reqcycle.utils.iterators.handlers.ResultHandler;
import org.polarsys.reqcycle.utils.iterators.pickers.IPicker;

public class WidthHarvester
extends Harvester {
    public WidthHarvester(Object startingElement) {
        super(startingElement);
    }

    @Override
    public void collect(ResultHandler<Object> handler) throws CollectionAbortedException {
        this.collectWidthWise(handler, this.start);
    }

    protected void collectWidthWise(ResultHandler<Object> handler, Object element) throws CollectionAbortedException {
        List currentLayer = Collections.singletonList(element);
        Iterable nextLayer = Collections.EMPTY_LIST;
        while (currentLayer != null && !Iterables.isEmpty(currentLayer)) {
            for (Object currentElement : currentLayer) {
                try {
                    handler.handleResult(currentElement);
                    for (IPicker picker : this.getPickers()) {
                        Iterable<?> nexts = picker.getNexts(currentElement);
                        if (nexts == null) continue;
                        nextLayer = Iterables.concat((Iterable)nextLayer, nexts);
                    }
                }
                catch (CannotHandleException cannotHandleException) {
                }
                catch (Exception e) {
                    Activator.logError(e);
                }
            }
            currentLayer = nextLayer;
            nextLayer = Collections.EMPTY_LIST;
        }
    }
}

