/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.iterators.collectors;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.polarsys.reqcycle.utils.iterators.collectors.IHarvester;
import org.polarsys.reqcycle.utils.iterators.exceptions.CollectionAbortedException;
import org.polarsys.reqcycle.utils.iterators.handlers.ResultHandler;
import org.polarsys.reqcycle.utils.iterators.pickers.ArcPicker;
import org.polarsys.reqcycle.utils.iterators.pickers.IArc;
import org.polarsys.reqcycle.utils.iterators.pickers.IPicker;

public class ArcHarvester
implements IHarvester {
    private IHarvester basicHarvester;
    private Object startingElement;
    private Iterable<IPicker> pickers;

    public ArcHarvester(IHarvester basicHarvester, Iterable<IPicker> basicPickers) {
        this.basicHarvester = basicHarvester;
        this.pickers = basicPickers;
        LinkedList arcPickers = Lists.newLinkedList();
        for (IPicker basicPicker : basicPickers) {
            ArcPicker arcPicker = new ArcPicker(basicPicker);
            arcPickers.add(arcPicker);
        }
        this.basicHarvester.setPickers(arcPickers);
    }

    @Override
    public void collect(ResultHandler<Object> handler) throws CollectionAbortedException {
        this.basicHarvester.collect(handler);
    }

    @Override
    public Object getStartingElement() {
        return this.startingElement;
    }

    @Override
    public void setStartingElement(Object startingElement) {
        this.startingElement = startingElement;
        StartingArc startingArc = new StartingArc(startingElement);
        this.basicHarvester.setStartingElement(startingArc);
    }

    @Override
    public Iterable<IPicker> getPickers() {
        return this.pickers;
    }

    @Override
    public void setPickers(Iterable<IPicker> basicPickers) {
        this.pickers = basicPickers;
        LinkedList arcPickers = Lists.newLinkedList();
        for (IPicker basicPicker : basicPickers) {
            ArcPicker arcPicker = new ArcPicker(basicPicker);
            arcPickers.add(arcPicker);
        }
        this.basicHarvester.setPickers(arcPickers);
    }

    public class StartingArc
    implements IArc {
        Object startingElement;

        public StartingArc(Object startingElement) {
            this.startingElement = startingElement;
        }

        @Override
        public Object getOrigin() {
            return null;
        }

        @Override
        public Object getDestination() {
            return this.startingElement;
        }
    }
}

