/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.inject;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SortedSetMultimap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.InjectorFactory;

public class BindingManager {
    private static String EXT_POINT = "binding";

    public static void registerBindings() {
        IConfigurationElement[] elements;
        HashMap map = new HashMap();
        Supplier<SortedSet<PriorityClass>> factory = new Supplier<SortedSet<PriorityClass>>(){

            public SortedSet<PriorityClass> get() {
                TreeSet<PriorityClass> sorted = new TreeSet<PriorityClass>(new Comparator<PriorityClass>(){

                    @Override
                    public int compare(PriorityClass o1, PriorityClass o2) {
                        int result = new Integer(o1.priority).compareTo(o2.priority);
                        if (result == 0 && !o1.equals(o2)) {
                            result = -1;
                        }
                        return result;
                    }
                });
                return sorted;
            }
        };
        SortedSetMultimap multi = Multimaps.newSortedSetMultimap(map, (Supplier)factory);
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.reqcycle.utils.inject", EXT_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String theInterface = e.getAttribute("interface");
            String theImpl = e.getAttribute("impl");
            String name = e.getAttribute("name");
            Class theInterfaceC = BindingManager.loadClass(e, theInterface);
            Class theImplC = BindingManager.loadClass(e, theImpl);
            int priority = 0;
            String prio = e.getAttribute("priority");
            if (prio != null && prio.length() > 0) {
                try {
                    priority = Integer.parseInt(prio);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (theInterfaceC != null && theImplC != null && theInterfaceC.isAssignableFrom(theImplC)) {
                PriorityClass priorityClass = new PriorityClass();
                priorityClass.aClass = theImplC;
                priorityClass.priority = priority;
                priorityClass.name = name;
                multi.put((Object)theInterfaceC, (Object)priorityClass);
            }
            ++n2;
        }
        for (Class c : multi.keys()) {
            PriorityClass last = null;
            for (PriorityClass pc : multi.get((Object)c)) {
                if (pc.name != null && pc.name.length() > 0) {
                    InjectorFactory.getDefault().addBinding(c).implementedBy(pc.aClass).named(pc.name);
                }
                last = pc;
            }
            if (last == null) continue;
            InjectorFactory.getDefault().addBinding(c).implementedBy(last.aClass);
        }
    }

    private static Class loadClass(IConfigurationElement e, String theClass) {
        try {
            return Platform.getBundle((String)e.getContributor().getName()).loadClass(theClass);
        }
        catch (InvalidRegistryObjectException e1) {
            e1.printStackTrace();
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    private static class PriorityClass {
        public String name;
        public Class aClass;
        public int priority;

        private PriorityClass() {
        }
    }
}

