/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.uri.utils;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IObjectHandler;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ReachableUtils {
    public static <T> T getAdapter(Object o, Class<T> aclass) {
        Object result = null;
        if (o instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)o;
            result = adaptable.getAdapter(aclass);
        }
        if (result == null) {
            result = Platform.getAdapterManager().getAdapter(o, aclass);
        }
        return (T)result;
    }

    public static String hashStream(InputStream stream) {
        String md5Str = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buf = new byte[10240];
            while (stream.read(buf) >= 0) {
                md.update(buf);
            }
            stream.close();
            byte[] res = md.digest();
            StringBuffer hexString = new StringBuffer();
            int i = 0;
            while (i < res.length) {
                hexString.append(Integer.toHexString(0xFF & res[i]));
                ++i;
            }
            md5Str = hexString.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {}
        return md5Str;
    }

    public static ReachableObject getReachableObject(IResource res) {
        try {
            IReachableManager manager = (IReachableManager)ZigguratInject.make(IReachableManager.class);
            IObjectHandler handler = manager.getHandlerFromObject(res);
            if (handler != null) {
                return handler.getFromObject(res);
            }
        }
        catch (IReachableHandlerException iReachableHandlerException) {}
        return null;
    }

    public static Reachable getReachable(IResource res) {
        ReachableObject ro = ReachableUtils.getReachableObject(res);
        if (ro == null) {
            return null;
        }
        return ro.getReachable();
    }
}

