/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.ui.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.core.util.PredicatesUtil;
import org.polarsys.reqcycle.predicates.persistance.util.IPredicatesConfManager;
import org.polarsys.reqcycle.predicates.ui.dialogs.AbstractCustomDialog;
import org.polarsys.reqcycle.predicates.ui.dialogs.CheckBoxInputDialog;
import org.polarsys.reqcycle.predicates.ui.dialogs.ComboInputDialog;
import org.polarsys.reqcycle.predicates.ui.presentation.PredicatesEditor;
import org.polarsys.reqcycle.predicates.ui.providers.PredicatesTableLabelProvider;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class PredicatesUIHelper {
    static IPredicatesConfManager predicatesConfManager = (IPredicatesConfManager)ZigguratInject.make(IPredicatesConfManager.class);
    static ILogger logger = (ILogger)ZigguratInject.make(ILogger.class);

    private PredicatesUIHelper() {
    }

    public static Collection<IPredicate> openPredicatesChooser(Collection<IPredicate> preSelection, String title, String msg, Boolean multiSelection) {
        Collection storedPredicates = predicatesConfManager.getPredicates(false);
        return PredicatesUIHelper.openPredicatesChooser(storedPredicates, preSelection, title, msg, multiSelection);
    }

    public static Collection<IPredicate> openPredicatesChooser(Collection<IPredicate> input, Collection<IPredicate> preSelection, String title, String msg, Boolean multiSelection) {
        AbstractCustomDialog dialog;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (multiSelection.booleanValue()) {
            dialog = new CheckBoxInputDialog(display.getActiveShell(), title, msg, input, null, preSelection);
            ((CheckBoxInputDialog)dialog).setLabelProvider(new PredicatesTableLabelProvider());
        } else {
            dialog = new ComboInputDialog(display.getActiveShell(), title, msg, input, null, true);
            ((ComboInputDialog)dialog).setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IPredicate) {
                        return ((IPredicate)element).getDisplayName();
                    }
                    return super.getText(element);
                }
            });
        }
        if (dialog.open() == 0) {
            ArrayList<IPredicate> predicates = new ArrayList<IPredicate>();
            for (Object obj : dialog.getSelectedItems()) {
                if (!(obj instanceof IPredicate)) continue;
                predicates.add((IPredicate)obj);
            }
            return predicates;
        }
        return null;
    }

    public static IPredicate selectRootPredicate() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        final AdapterFactoryLabelProvider adapterLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        ComboInputDialog dialog = new ComboInputDialog(display.getActiveShell(), "Root Predicate", "Select a root predicate", PredicatesUtil.getDefaultPredicates(), null);
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return adapterLabelProvider.getText(element);
            }
        });
        if (dialog.open() == 0) {
            return (IPredicate)dialog.getSelectedItem();
        }
        return null;
    }

    public static void openNewPredicateEditor() {
        IPredicate selectedPredicate = PredicatesUIHelper.selectRootPredicate();
        if (selectedPredicate != null) {
            PredicatesUIHelper.openEditor(Collections.emptyList(), selectedPredicate);
        }
    }

    public static void editPredicate() {
        Collection<IPredicate> predicates = PredicatesUIHelper.openPredicatesChooser(null, "", "", false);
        if (predicates != null && !predicates.isEmpty()) {
            PredicatesUIHelper.openEditor(null, predicates.iterator().next());
        }
    }

    public static void openEditor(Object input, IPredicate rootPredicate) {
        try {
            String prefix = "predicate";
            String name = null;
            if (rootPredicate != null && rootPredicate.getDisplayName() != null) {
                name = rootPredicate.getDisplayName();
                prefix = String.valueOf(name) + "_" + prefix;
            }
            File f = File.createTempFile(prefix, ".predicates");
            Runtime.getRuntime().addShutdownHook(new ShutDownHook(f));
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            PredicatesEditor editor = (PredicatesEditor)IDE.openEditor((IWorkbenchPage)page, (URI)f.toURI(), (String)"org.polarsys.reqcycle.predicates.ui.presentation.PredicatesEditorID", (boolean)true);
            editor.setDirty(false);
            editor.setRootPredicate((IPredicate)EcoreUtil.copy((EObject)rootPredicate));
            if (input != null) {
                editor.setInput(input);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
            logger.error("Unable to open the predicates Editor : " + e.getMessage());
            logger.error(e.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Unable to create the predicates temporary file : " + e.getMessage());
            logger.error(e.toString());
        }
    }

    public static String openInputDialog(Shell shell) {
        InputDialog savePredicateDialog = new InputDialog(shell, "Predicate name", "Enter the name of the new predicate", null, new IInputValidator(){

            public String isValid(String newText) {
                if (!Pattern.compile("\\w+[-\\w]*", 2).matcher(newText).matches()) {
                    return "The name of the predicate is not valid.";
                }
                if (predicatesConfManager.isPredicateNameAlreadyUsed(newText)) {
                    return "This predicate's name is already used.";
                }
                return null;
            }
        });
        if (savePredicateDialog.open() == 0) {
            return savePredicateDialog.getValue();
        }
        return null;
    }

    private static class ShutDownHook
    extends Thread {
        private final File file;

        public ShutDownHook(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            try {
                if (this.file.exists()) {
                    this.file.delete();
                }
            }
            catch (Exception exception) {}
        }
    }
}

