/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.ui.dialogs;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.polarsys.reqcycle.styling.manager.IStylingManager;
import org.polarsys.reqcycle.styling.model.Styling.Basic;
import org.polarsys.reqcycle.styling.model.Styling.Default;
import org.polarsys.reqcycle.styling.model.Styling.StylingFactory;
import org.polarsys.reqcycle.styling.model.Styling.StylingModel;
import org.polarsys.reqcycle.styling.model.Styling.util.StylingAdapterFactory;
import org.polarsys.reqcycle.styling.ui.dialogs.CaseStyleEditorDialog;
import org.polarsys.reqcycle.styling.ui.dialogs.StyleModelNameDialog;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class StyleModelChooserDialog
extends TitleAreaDialog
implements IDoubleClickListener {
    private ListViewer listViewer;
    IStylingManager styleManager = (IStylingManager)ZigguratInject.make(IStylingManager.class);

    public StyleModelChooserDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32944);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Style configuration");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new FillLayout(256));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewer = new ListViewer(composite, 2560);
        this.listViewer.getList();
        this.listViewer.addDoubleClickListener((IDoubleClickListener)this);
        Composite composite_1 = new Composite(container, 0);
        composite_1.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        composite_1.setLayout((Layout)new GridLayout(1, false));
        Button btnAdd = new Button(composite_1, 0);
        btnAdd.setToolTipText("Add new style configuration");
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleModelNameDialog dialog = new StyleModelNameDialog(Display.getDefault().getActiveShell());
                if (dialog.open() == 0 && !dialog.getStyleModelName().equals("")) {
                    StylingModel newStylingModel = StylingFactory.eINSTANCE.createStylingModel();
                    newStylingModel.setModeName(dialog.getStyleModelName());
                    Default defaultStyle = StylingFactory.eINSTANCE.createDefault();
                    newStylingModel.setDefault(defaultStyle);
                    Basic basicStyle = StylingFactory.eINSTANCE.createBasic();
                    newStylingModel.setBasic(basicStyle);
                    StyleModelChooserDialog.this.styleManager.getStyling().getModels().add((Object)newStylingModel);
                    if (StyleModelChooserDialog.this.styleManager.getStyling().getModels().size() == 1) {
                        StyleModelChooserDialog.this.styleManager.setPreferredStylingModel(dialog.getStyleModelName());
                    }
                    StyleModelChooserDialog.this.listViewer.setInput((Object)StyleModelChooserDialog.this.styleManager.getStyling().getModels());
                    StyleModelChooserDialog.this.listViewer.setSelection((ISelection)new StructuredSelection((Object)newStylingModel));
                }
            }
        });
        btnAdd.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/add_obj.gif"));
        Button btnRemove = new Button(composite_1, 0);
        btnRemove.setToolTipText("Remove the selected style configuration");
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                StylingModel stylingModel;
                if (!StyleModelChooserDialog.this.listViewer.getSelection().isEmpty() && (stylingModel = (StylingModel)(selection = (IStructuredSelection)StyleModelChooserDialog.this.listViewer.getSelection()).getFirstElement()) != null) {
                    StyleModelChooserDialog.this.styleManager.getStyling().getModels().remove((Object)stylingModel);
                    if (StyleModelChooserDialog.this.styleManager.getPreferredStyleModel().equals(stylingModel.getModeName()) && StyleModelChooserDialog.this.styleManager.getStyling().getModels().size() != 0) {
                        StyleModelChooserDialog.this.styleManager.setPreferredStylingModel(((StylingModel)StyleModelChooserDialog.this.styleManager.getStyling().getModels().get(0)).getModeName());
                    }
                    StyleModelChooserDialog.this.listViewer.setInput((Object)StyleModelChooserDialog.this.styleManager.getStyling().getModels());
                }
            }
        });
        btnRemove.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/delete_obj.gif"));
        Button btnEdit = new Button(composite_1, 0);
        btnEdit.setToolTipText("Edit the selected style configuration");
        btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                StylingModel stylingModel;
                if (!StyleModelChooserDialog.this.listViewer.getSelection().isEmpty() && (stylingModel = (StylingModel)(selection = (IStructuredSelection)StyleModelChooserDialog.this.listViewer.getSelection()).getFirstElement()) != null) {
                    StyleModelChooserDialog.this.editSelectedStylingModel(stylingModel);
                }
            }
        });
        btnEdit.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/edit_obj.png"));
        new Label(composite_1, 0);
        Button btnUp = new Button(composite_1, 0);
        btnUp.setToolTipText("Move up the selected style configuration");
        btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                StylingModel stylingModel;
                if (!StyleModelChooserDialog.this.listViewer.getSelection().isEmpty() && (stylingModel = (StylingModel)(selection = (IStructuredSelection)StyleModelChooserDialog.this.listViewer.getSelection()).getFirstElement()) != null) {
                    int index = StyleModelChooserDialog.this.styleManager.getStyling().getModels().indexOf((Object)stylingModel);
                    if (index != 0) {
                        StyleModelChooserDialog.this.styleManager.getStyling().getModels().move(index, index - 1);
                    }
                    StyleModelChooserDialog.this.listViewer.setInput((Object)StyleModelChooserDialog.this.styleManager.getStyling().getModels());
                    StyleModelChooserDialog.this.listViewer.setSelection((ISelection)selection);
                }
            }
        });
        btnUp.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/prev_nav-1.gif"));
        Button btnDown = new Button(composite_1, 0);
        btnDown.setToolTipText("Move down the selected style configuration");
        btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                StylingModel stylingModel;
                if (!StyleModelChooserDialog.this.listViewer.getSelection().isEmpty() && (stylingModel = (StylingModel)(selection = (IStructuredSelection)StyleModelChooserDialog.this.listViewer.getSelection()).getFirstElement()) != null) {
                    int index = StyleModelChooserDialog.this.styleManager.getStyling().getModels().indexOf((Object)stylingModel);
                    if (index != StyleModelChooserDialog.this.styleManager.getStyling().getModels().size() - 1) {
                        StyleModelChooserDialog.this.styleManager.getStyling().getModels().move(index, index + 1);
                    }
                    StyleModelChooserDialog.this.listViewer.setInput((Object)StyleModelChooserDialog.this.styleManager.getStyling().getModels());
                    StyleModelChooserDialog.this.listViewer.setSelection((ISelection)selection);
                }
            }
        });
        btnDown.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/next_nav-1.gif"));
        Button btnSetPreferred = new Button(composite_1, 0);
        btnSetPreferred.setToolTipText("Activate the selected style configuration");
        btnSetPreferred.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                StylingModel stylingModel;
                if (!StyleModelChooserDialog.this.listViewer.getSelection().isEmpty() && (stylingModel = (StylingModel)(selection = (IStructuredSelection)StyleModelChooserDialog.this.listViewer.getSelection()).getFirstElement()) != null) {
                    StyleModelChooserDialog.this.styleManager.setPreferredStylingModel(stylingModel.getModeName());
                    StyleModelChooserDialog.this.listViewer.setInput((Object)StyleModelChooserDialog.this.styleManager.getStyling().getModels());
                    StyleModelChooserDialog.this.listViewer.setSelection((ISelection)selection);
                }
            }
        });
        btnSetPreferred.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/set_pref.png"));
        this.initProviders(this.listViewer);
        return area;
    }

    private void initProviders(ListViewer listViewer) {
        StylingAdapterFactory adapterfactory = new StylingAdapterFactory();
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterfactory){

            public String getText(Object object) {
                if (object instanceof StylingModel) {
                    if (((StylingModel)object).getModeName().equals(StyleModelChooserDialog.this.styleManager.getPreferredStyleModel())) {
                        return String.valueOf(((StylingModel)object).getModeName()) + " (Selected)";
                    }
                    return ((StylingModel)object).getModeName();
                }
                return super.getText(object);
            }
        };
        ArrayContentProvider contentProvider = ArrayContentProvider.getInstance();
        listViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        listViewer.setContentProvider((IContentProvider)contentProvider);
        listViewer.setInput((Object)this.styleManager.getStyling().getModels());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(326, 394);
    }

    public StylingModel getPreferred() {
        String preferred = this.styleManager.getPreferredStyleModel();
        EList stylingModelList = this.styleManager.getStyling().getModels();
        int i = 0;
        while (i < stylingModelList.size()) {
            if (((StylingModel)stylingModelList.get(i)).getModeName().equals(preferred)) {
                return (StylingModel)stylingModelList.get(i);
            }
            ++i;
        }
        return null;
    }

    private void editSelectedStylingModel(StylingModel selected) {
        int dialogResult;
        CaseStyleEditorDialog editor = new CaseStyleEditorDialog(Display.getDefault().getActiveShell(), selected);
        String currentStylingModelName = selected.getModeName();
        boolean isDefault = false;
        if (this.styleManager.getPreferredStyleModel().equals(currentStylingModelName)) {
            isDefault = true;
        }
        if ((dialogResult = editor.open()) == 0) {
            if (isDefault) {
                this.styleManager.setPreferredStylingModel(selected.getModeName());
                this.listViewer.setInput((Object)this.styleManager.getStyling().getModels());
            }
        } else if (dialogResult == 1) {
            selected.setModeName(currentStylingModelName);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        StylingModel stylingModel;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.getFirstElement() instanceof StylingModel && (stylingModel = (StylingModel)selection.getFirstElement()) != null) {
            this.editSelectedStylingModel(stylingModel);
        }
    }
}

