/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.cache;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.traceability.builder.IBuildingTraceabilityEngine;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityBuilder;
import org.polarsys.reqcycle.traceability.builder.exceptions.BuilderException;
import org.polarsys.reqcycle.traceability.cache.Activator;
import org.polarsys.reqcycle.traceability.cache.predicates.FilterPredicate;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.exceptions.EngineException;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.StopCondition;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.model.scopes.CompositeScope;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.traceability.predicates.IsInScopePredicate;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.functions.URIFunctions;
import org.polarsys.reqcycle.uri.model.Reachable;

public abstract class AbstractCachedTraceabilityEngine
implements IBuildingTraceabilityEngine {
    private String cachePath = this.determineDataBasePath();
    public static String HIDDEN_PROJET_NAME = "reqCycleHiddenProject";
    @Inject
    ITraceabilityBuilder builder;
    @Inject
    protected IReachableManager manager;
    @Inject
    ILogger logger;
    private Set<Reachable> allTraceabilities = new HashSet<Reachable>();

    public AbstractCachedTraceabilityEngine() {
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
                AbstractCachedTraceabilityEngine.this.environmentClosed();
            }
        });
    }

    private String determineDataBasePath() {
        File f = new File(Activator.getDefault().getStateLocation().toString());
        File f2 = new File(String.valueOf(f.getAbsolutePath()) + "/" + HIDDEN_PROJET_NAME + "/");
        f2.mkdirs();
        return f2.getAbsolutePath();
    }

    protected String getCachePath() {
        return this.cachePath;
    }

    protected abstract void environmentClosed();

    protected void cacheCheck(Reachable traceable) {
        boolean debug = this.logger.isDebug("org.polarsys.reqcycle.traceability.cache/debug", (Plugin)Activator.getDefault());
        if (!this.isCacheOk(traceable)) {
            if (debug) {
                this.logger.trace(String.format("cache default for %s build starting", traceable.trimFragment().toString()));
            }
            this.build(traceable);
            if (debug) {
                this.logger.trace(String.format("build for %s ended", traceable.trimFragment().toString()));
            }
        } else if (debug) {
            this.logger.trace(String.format("cache for %s ok", traceable.trimFragment().toString()));
        }
    }

    public Iterator<Pair<Link, Reachable>> getTraceability(Request ... requests) throws EngineException {
        long timeInNanos = 0L;
        boolean debug = this.logger.isDebug("org.polarsys.reqcycle.traceability.cache/debug", (Plugin)Activator.getDefault());
        if (debug) {
            timeInNanos = System.nanoTime();
        }
        if (requests == null) {
            throw new EngineException("request can not be null");
        }
        boolean checkCache = this.isCacheCheckNeeded(requests);
        if (checkCache) {
            this.checkScope(this.getScope(requests));
        }
        if (debug) {
            if (checkCache) {
                long timeInMsc = (System.nanoTime() - timeInNanos) / 1000000L;
                this.logger.trace(String.format("Cache checked in %d ms", timeInMsc));
            } else {
                this.logger.trace(String.format("Cache checked disabled via request", new Object[0]));
            }
        }
        Object result = Iterators.emptyIterator();
        Request[] requestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            Iterable couples;
            Request request = requestArray[n2];
            IsInScopePredicate requestPredicate = new IsInScopePredicate(request.getScope());
            if (request.getFilter() != null) {
                requestPredicate = Predicates.and((Predicate)new FilterPredicate(request.getFilter()), (Predicate)requestPredicate);
            }
            if (!(couples = request.getCouples()).iterator().hasNext()) {
                if (request.getDepth() == Request.DEPTH.ONE) {
                    throw new EngineException("for a couple with source equals to null the request shall be infinite");
                }
                result = Iterators.concat((Iterator)result, this.doGetAllTraceability(request.getDirection(), (Predicate<Pair<Link, Reachable>>)requestPredicate));
            }
            for (Request.Couple c : couples) {
                if (c.getSource() == null) {
                    if (request.getDepth() == Request.DEPTH.ONE) {
                        throw new EngineException("for a couple with source equals to null the request shall be infinite");
                    }
                    result = Iterators.concat((Iterator)result, this.doGetAllTraceability(request.getDirection(), (Predicate<Pair<Link, Reachable>>)requestPredicate));
                    continue;
                }
                if (c.getStopCondition() == null) {
                    if (request.getDepth() == Request.DEPTH.INFINITE) {
                        result = Iterators.concat((Iterator)result, this.doGetTraceability(c.getSource(), request.getDirection(), (Predicate<Pair<Link, Reachable>>)requestPredicate));
                        continue;
                    }
                    if (request.getDepth() != Request.DEPTH.ONE) continue;
                    result = Iterators.concat((Iterator)result, this.doGetOneLevelTraceability(c.getSource(), request.getDirection(), (Predicate<Pair<Link, Reachable>>)requestPredicate));
                    continue;
                }
                result = request.getDepth() == Request.DEPTH.INFINITE ? Iterators.concat((Iterator)result, this.doGetTraceability(c.getSource(), c.getStopCondition(), request.getDirection(), (Predicate<Pair<Link, Reachable>>)requestPredicate)) : Iterators.concat((Iterator)result, this.doGetTraceability(c.getSource(), c.getStopCondition(), request.getDirection(), (Predicate<Pair<Link, Reachable>>)Predicates.and((Predicate)requestPredicate, (Predicate)new TargetEqualsPredicate(c.getStopCondition()))));
            }
            ++n2;
        }
        if (debug) {
            timeInNanos = System.nanoTime() - timeInNanos;
            long timeInMsc = timeInNanos / 1000000L;
            this.logger.trace(String.format("Traceability computed in %d ms (including cache check)", timeInMsc));
        }
        return result;
    }

    public boolean isCacheCheckNeeded(Request ... requests) {
        int nbFalse = 0;
        int i = 0;
        Request[] requestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            Request r = requestArray[n2];
            Object property = r.getProperty("optionCheckCache");
            boolean checkCache = true;
            if (property instanceof Boolean) {
                checkCache = (Boolean)property;
            }
            if (!checkCache) {
                ++nbFalse;
            }
            ++i;
            ++n2;
        }
        return nbFalse != i;
    }

    protected IScope getScope(Request[] requests) {
        CompositeScope compo = new CompositeScope(Iterables.transform(Arrays.asList(requests), (Function)new Function<Request, IScope>(){

            public IScope apply(Request r) {
                return r.getScope();
            }
        }));
        return compo;
    }

    protected void checkScope(IScope scope) {
        if (scope != null) {
            Iterator i = scope.getReachables();
            while (i.hasNext()) {
                Reachable next = (Reachable)i.next();
                this.cacheCheck(next);
            }
        }
    }

    protected abstract Iterator<Pair<Link, Reachable>> doGetAllTraceability(ITraceabilityEngine.DIRECTION var1, Predicate<Pair<Link, Reachable>> var2);

    protected abstract Iterator<Pair<Link, Reachable>> doGetTraceability(Reachable var1, ITraceabilityEngine.DIRECTION var2, Predicate<Pair<Link, Reachable>> var3);

    protected abstract Iterator<Pair<Link, Reachable>> doGetOneLevelTraceability(Reachable var1, ITraceabilityEngine.DIRECTION var2, Predicate<Pair<Link, Reachable>> var3);

    protected abstract Iterator<Pair<Link, Reachable>> doGetTraceability(Reachable var1, StopCondition var2, ITraceabilityEngine.DIRECTION var3, Predicate<Pair<Link, Reachable>> var4);

    protected void build(Reachable traceable) {
        try {
            Iterable<Link> links = this.getLinksForTraceable(traceable);
            this.builder.build(traceable, (ITraceabilityBuilder.IBuilderCallBack)this, false);
            Iterable<Link> newLinks = this.getLinksForTraceable(traceable);
            Iterable<Link> linksToTag = this.getLinksToTag(links, newLinks);
            this.tagDeletedRelationShips(linksToTag);
        }
        catch (BuilderException builderException) {}
    }

    protected abstract Iterable<Reachable> getEntriesFor(Reachable var1);

    protected Iterable<Link> getLinksToTag(Iterable<Link> oldLinks, Iterable<Link> newLinks) {
        if (newLinks == null) {
            newLinks = Sets.newHashSet();
        }
        if (oldLinks == null) {
            oldLinks = Sets.newHashSet();
        }
        final HashSet newLinkSet = Sets.newHashSet();
        return Iterables.filter((Iterable)oldLinks, (Predicate)new Predicate<Link>(){

            public boolean apply(Link l) {
                return !newLinkSet.contains(l);
            }
        });
    }

    protected abstract void tagDeletedRelationShips(Iterable<Link> var1);

    public abstract Iterable<Link> getLinksForTraceable(Reachable var1);

    protected abstract boolean isCacheOk(Reachable var1);

    public void newUpwardRelation(Object traceabilityObject, Object resource, Object source, List<? extends Object> targets, TType kind) {
        Function obj2RO = URIFunctions.newObject2ReachableFunction();
        Reachable resourceReachable = (Reachable)obj2RO.apply(resource);
        Reachable sourceR = (Reachable)obj2RO.apply(source);
        Reachable traceaReachable = (Reachable)obj2RO.apply(traceabilityObject);
        ArrayList targetsR = Lists.newArrayList((Iterable)Iterables.transform(targets, (Function)obj2RO));
        if (sourceR != null && Iterables.filter((Iterable)targetsR, (Predicate)Predicates.notNull()).iterator().hasNext()) {
            this.allTraceabilities.remove(traceaReachable);
            this.newUpwardRelation(traceaReachable, resourceReachable, sourceR, targetsR, kind);
        }
    }

    public abstract void newUpwardRelation(Reachable var1, Reachable var2, Reachable var3, List<Reachable> var4, TType var5);

    public void startBuild(Reachable reachable) {
        this.allTraceabilities = Sets.newHashSet(this.getEntriesFor(reachable));
    }

    public void endBuild(Reachable reachable) {
        for (Reachable r : this.allTraceabilities) {
            this.removeTraceabilityLink(r);
        }
        this.allTraceabilities.clear();
    }

    protected abstract void removeTraceabilityLink(Reachable var1);

    public void errorOccurs(Reachable reachable, Throwable t) {
        this.logger.error(t.getMessage());
        t.printStackTrace();
    }

    public boolean needsBuild(Reachable reachable) {
        return !this.isCacheOk(reachable);
    }

    private class TargetEqualsPredicate
    implements Predicate<Pair<Link, Reachable>> {
        private StopCondition condition;

        public TargetEqualsPredicate(StopCondition condition) {
            this.condition = condition;
        }

        public boolean apply(Pair<Link, Reachable> pair) {
            return this.condition.apply(pair);
        }
    }
}

