/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.core.util;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.Plugin;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.predicates.core.IPredicateEvaluator;
import org.polarsys.reqcycle.predicates.core.api.IListeningPredicate;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.uri.Activator;
import org.polarsys.reqcycle.uri.IReachableListener;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.functions.Object2Reachable;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

@Singleton
public class PredicateEvaluator
implements IPredicateEvaluator,
IReachableListener {
    @Inject
    ILogger logger;
    private static final Object2Reachable OBJECT2_REACHABLE = new Object2Reachable();
    private static String PREDICEVAL = "PredicateEvaluator ";
    IReachableListenerManager lManager = (IReachableListenerManager)ZigguratInject.make(IReachableListenerManager.class);
    IReachableManager rManager = (IReachableManager)ZigguratInject.make(IReachableManager.class);
    Cache<Reachable, Map<String, Boolean>> cache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    Multimap<Reachable, Reachable> resourceToChildren = HashMultimap.create();
    Multimap<Reachable, Reachable> bindings = HashMultimap.create();
    private Set<IPredicateEvaluator.IRefresh> refreshes = Sets.newHashSet();

    static {
        ZigguratInject.inject((Object[])new Object[]{OBJECT2_REACHABLE});
    }

    @Override
    public boolean match(IPredicate p, Object input) {
        if (p == null) {
            return false;
        }
        Reachable r = null;
        if (input instanceof Reachable) {
            r = (Reachable)input;
        } else {
            try {
                r = this.rManager.getHandlerFromObject(input).getFromObject(input).getReachable();
            }
            catch (IReachableHandlerException iReachableHandlerException) {}
        }
        if (r != null) {
            final Reachable reachable = r;
            try {
                Map map = (Map)this.cache.get((Object)r, (Callable)new Callable<Map<String, Boolean>>(){

                    @Override
                    public Map<String, Boolean> call() throws Exception {
                        if (PredicateEvaluator.this.logger.isDebug("org.polarsys.reqcycle.uri/debug", (Plugin)Activator.getDefault())) {
                            PredicateEvaluator.this.logger.trace(String.valueOf(PREDICEVAL) + "cache default for " + reachable.toString());
                        }
                        HashMap result = Maps.newHashMap();
                        PredicateEvaluator.this.listen(reachable);
                        return result;
                    }
                });
                Boolean result = (Boolean)map.get(p.getDisplayName());
                if (result == null) {
                    result = p.match(input);
                    if (p instanceof IListeningPredicate) {
                        IListeningPredicate listening = (IListeningPredicate)p;
                        for (Reachable toListen : Iterables.transform(listening.getObjectsToListen(), (Function)OBJECT2_REACHABLE)) {
                            this.listen(toListen);
                            if (toListen.equals((Object)r)) continue;
                            this.bindings.put((Object)toListen, (Object)r);
                        }
                    }
                    map.put(p.getDisplayName(), result);
                }
                return result;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return p.match(input);
    }

    private void listen(Reachable reachable) {
        this.lManager.addReachableListener(reachable, (IReachableListener)this);
        this.lManager.addReachableListener(reachable.trimFragment(), (IReachableListener)this);
        this.resourceToChildren.put((Object)reachable.trimFragment(), (Object)reachable);
    }

    public void hasChanged(Reachable[] reachable) {
        HashSet toRefresh = Sets.newHashSet(Arrays.asList(reachable));
        Reachable[] reachableArray = reachable;
        int n = reachable.length;
        int n2 = 0;
        while (n2 < n) {
            Reachable reachable2 = reachableArray[n2];
            if (this.logger.isDebug("org.polarsys.reqcycle.uri/debug", (Plugin)Activator.getDefault())) {
                this.logger.trace(String.valueOf(PREDICEVAL) + "change detected for " + reachable2.toString());
            }
            if (reachable2.getFragment() == null || reachable2.getFragment().length() == 0) {
                Collection list = this.resourceToChildren.get((Object)reachable2);
                for (Reachable child : list) {
                    toRefresh.add(child);
                    toRefresh.addAll(this.doHasChanged(child));
                    if (!this.logger.isDebug("org.polarsys.reqcycle.uri/debug", (Plugin)Activator.getDefault())) continue;
                    this.logger.trace(String.valueOf(PREDICEVAL) + "child invalidation for " + child.toString());
                }
                this.resourceToChildren.removeAll((Object)reachable2);
                this.lManager.removeReachableListener((IReachableListener)this, reachable2);
                this.cache.invalidate((Object)reachable2);
            } else {
                this.doHasChanged(reachable2);
            }
            ++n2;
        }
        for (IPredicateEvaluator.IRefresh iRefresh : this.refreshes) {
            iRefresh.hasChanged(toRefresh.toArray(new Reachable[0]));
        }
    }

    private Set<Reachable> doHasChanged(Reachable r) {
        HashSet toRefresh = Sets.newHashSet((Object[])new Reachable[]{r});
        this.cache.invalidate((Object)r);
        Collection fromBinding = this.bindings.get((Object)r);
        if (fromBinding != null) {
            for (Reachable binded : fromBinding) {
                this.cache.invalidate((Object)binded);
                toRefresh.add(binded);
            }
            this.bindings.removeAll((Object)r);
        }
        this.lManager.removeReachableListener((IReachableListener)this, r);
        return toRefresh;
    }

    @Override
    public void addRefresh(IPredicateEvaluator.IRefresh refresh) {
        this.refreshes.add(refresh);
    }

    @Override
    public void removeRefresh(IPredicateEvaluator.IRefresh refresh) {
        this.refreshes.remove(refresh);
    }
}

