/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.core.impl;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.polarsys.reqcycle.operations.IOperation;
import org.polarsys.reqcycle.operations.IReqCycleOperationManager;
import org.polarsys.reqcycle.operations.ReqCycleOperation;
import org.polarsys.reqcycle.predicates.core.IPredicateEvaluator;
import org.polarsys.reqcycle.predicates.core.PredicatesPackage;
import org.polarsys.reqcycle.predicates.core.api.BooleanParameter;
import org.polarsys.reqcycle.predicates.core.api.EObjectParameter;
import org.polarsys.reqcycle.predicates.core.api.IListeningPredicate;
import org.polarsys.reqcycle.predicates.core.api.IntParameter;
import org.polarsys.reqcycle.predicates.core.api.OperationPredicate;
import org.polarsys.reqcycle.predicates.core.api.Parameter;
import org.polarsys.reqcycle.predicates.core.api.StringParameter;
import org.polarsys.reqcycle.predicates.core.impl.IPredicateContainerImpl;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class OperationPredicateImpl
extends IPredicateContainerImpl
implements OperationPredicate {
    IReqCycleOperationManager reqCycleOperationlManager = (IReqCycleOperationManager)ZigguratInject.make(IReqCycleOperationManager.class);
    IPredicateEvaluator predicateEvaluator = (IPredicateEvaluator)ZigguratInject.make(IPredicateEvaluator.class);
    Set<Object> toListen = Sets.newHashSet();
    protected static final String OPERATION_NAME_EDEFAULT = null;
    protected String operationName = OPERATION_NAME_EDEFAULT;
    protected EList<Parameter> parameters;

    protected OperationPredicateImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PredicatesPackage.Literals.OPERATION_PREDICATE;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public void setOperationName(String newOperationName) {
        String oldOperationName = this.operationName;
        this.operationName = newOperationName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldOperationName, (Object)this.operationName));
        }
    }

    @Override
    public EList<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new EObjectContainmentEList(Parameter.class, (InternalEObject)this, 3);
        }
        return this.parameters;
    }

    @Override
    public EList<Object> getObjectsToListen() {
        return new BasicEList(this.toListen);
    }

    @Override
    public boolean match(Object input) {
        if (this.getOperationName() != null) {
            Class[] listTypes = new Class[this.getParameters().size() + 1];
            Object[] listValues = new Object[this.getParameters().size() + 1];
            listValues[0] = input;
            listTypes[0] = input.getClass();
            int i = 0;
            while (i < this.getParameters().size()) {
                Parameter p = (Parameter)this.getParameters().get(i);
                if (p instanceof StringParameter) {
                    listTypes[i + 1] = String.class;
                } else if (p instanceof IntParameter) {
                    listTypes[i + 1] = Integer.class;
                } else if (p instanceof BooleanParameter) {
                    listTypes[i + 1] = Boolean.class;
                } else if (p instanceof EObjectParameter) {
                    listTypes[i + 1] = EObject.class;
                } else {
                    return false;
                }
                listValues[i + 1] = p.getObjectValue();
                ++i;
            }
            ReqCycleOperation op = this.reqCycleOperationlManager.getOperation(this.operationName, listTypes);
            if (op != null) {
                Object obj = op.execute(listValues);
                if (obj instanceof IOperation.Result) {
                    IOperation.Result result = (IOperation.Result)obj;
                    Collection objectsToListen = result.getObjectsToListen();
                    if (objectsToListen != null) {
                        this.toListen = Sets.newHashSet((Iterable)objectsToListen);
                    }
                    if (Boolean.class.equals((Object)result.getResultType())) {
                        return (Boolean)result.getResult();
                    }
                    if (this.getResultPredicate() != null) {
                        return this.predicateEvaluator.match(this.getResultPredicate(), result.getResult());
                    }
                    return false;
                }
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                if (this.getResultPredicate() != null) {
                    return this.predicateEvaluator.match(this.getResultPredicate(), obj);
                }
            }
        }
        return false;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getParameters()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getOperationName();
            }
            case 3: {
                return this.getParameters();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setOperationName((String)newValue);
                return;
            }
            case 3: {
                this.getParameters().clear();
                this.getParameters().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setOperationName(OPERATION_NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getParameters().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return OPERATION_NAME_EDEFAULT == null ? this.operationName != null : !OPERATION_NAME_EDEFAULT.equals(this.operationName);
            }
            case 3: {
                return this.parameters != null && !this.parameters.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == IListeningPredicate.class) {
            switch (baseOperationID) {
                case 1: {
                    return 1;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.getObjectsToListen();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (operationName: ");
        result.append(this.operationName);
        result.append(')');
        return result.toString();
    }
}

