/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ui.numberspropseditor.internal.components;

import org.eclipse.swt.widgets.Composite;
import org.polarsys.reqcycle.ui.eattrpropseditor.api.AbstractPropsTextEditorComponent;

public class FloatPropsEditorComponent
extends AbstractPropsTextEditorComponent<Float> {
    private String errorMessage;

    public FloatPropsEditorComponent(String attributeName, Composite parent, int style) {
        super(attributeName, Float.class, parent, style);
    }

    protected Float convertFromString(String textValue) {
        try {
            return Float.valueOf(Float.parseFloat(textValue));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected boolean isTextValid(String textValue) {
        try {
            Float.parseFloat(textValue);
            return true;
        }
        catch (NumberFormatException e) {
            this.errorMessage = "Not a float. " + e.getMessage();
            return false;
        }
    }

    protected String getErrorMessage() {
        return this.errorMessage;
    }
}

