/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.Cell;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.CellsGroup;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.Line;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.SpreadSheetElement;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.StylizedCell;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.SubRow;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.SubRowScore;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.SubRowScoreComparator;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.SubRowSimple;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.Table;
import org.xml.sax.SAXException;

public class AdvancedTikaHSSFListener
implements HSSFListener {
    private SSTRecord sstRecord;
    private FormulaRecord stringFormulaRecord;
    private short previousSid;
    private FormatTrackingHSSFListener formatListener;
    private List<String> sheetNames = new ArrayList<String>();
    private short currentSheetIndex;
    private SortedMap<Point, Cell> currentSheet = null;
    private List<Cell> extraTextCells = new ArrayList<Cell>();
    private List<FontRecord> fontRecords = new ArrayList<FontRecord>();
    private List<ExtendedFormatRecord> extendedFormatRecords = new ArrayList<ExtendedFormatRecord>();
    private List<MergeCellsRecord> mergesCellsRecords = new ArrayList<MergeCellsRecord>();
    private Exception exception = null;
    private List<Line> _lines_read = new LinkedList<Line>();
    private int _index = 0;
    private LinkedList<SpreadSheetElement> _spreadSheetElements = new LinkedList();

    public AdvancedTikaHSSFListener(Locale locale) {
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)this, locale);
    }

    public List<SpreadSheetElement> processFile(NPOIFSFileSystem filesystem, boolean listenForAllRecords) throws IOException, SAXException, TikaException {
        return this.processFile(filesystem.getRoot(), listenForAllRecords);
    }

    public List<SpreadSheetElement> processFile(DirectoryNode root, boolean listenForAllRecords) throws IOException, SAXException, TikaException {
        HSSFRequest hssfRequest = new HSSFRequest();
        if (listenForAllRecords) {
            hssfRequest.addListenerForAllRecords((HSSFListener)this.formatListener);
        } else {
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)2057);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)10);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)34);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)140);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)133);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)252);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)6);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)516);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)253);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)515);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)519);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)1054);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)224);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)659);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)49);
            hssfRequest.addListener((HSSFListener)this.formatListener, (short)229);
        }
        DocumentInputStream documentInputStream = root.createDocumentInputStream("Workbook");
        HSSFEventFactory eventFactory = new HSSFEventFactory();
        try {
            eventFactory.processEvents(hssfRequest, (InputStream)documentInputStream);
        }
        catch (EncryptedDocumentException e) {
            throw new org.apache.tika.exception.EncryptedDocumentException((Throwable)e);
        }
        return this._spreadSheetElements;
    }

    public void processRecord(Record record) {
        if (this.exception == null) {
            try {
                this.internalProcessRecord(record);
            }
            catch (TikaException te) {
                this.exception = te;
            }
            catch (IOException ie) {
                this.exception = ie;
            }
            catch (SAXException se) {
                this.exception = se;
            }
        }
    }

    private void internalProcessRecord(Record record) throws SAXException, TikaException, IOException {
        switch (record.getSid()) {
            case 2057: {
                BOFRecord bof = (BOFRecord)record;
                if (bof.getType() == 5) {
                    this.currentSheetIndex = (short)-1;
                    break;
                }
                if (bof.getType() == 32) {
                    if (this.previousSid == 10) {
                        this.newSheet();
                        break;
                    }
                    if (this.currentSheet == null) break;
                    this.processSheet();
                    this.currentSheetIndex = (short)(this.currentSheetIndex - 1);
                    this.newSheet();
                    break;
                }
                if (bof.getType() != 16) break;
                this.newSheet();
                break;
            }
            case 10: {
                if (this.currentSheet != null) {
                    this.processSheet();
                }
                this.currentSheet = null;
                break;
            }
            case 133: {
                BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                this.sheetNames.add(boundSheetRecord.getSheetname());
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 6: {
                FormulaRecord formula = (FormulaRecord)record;
                if (formula.hasCachedResultString()) {
                    this.stringFormulaRecord = formula;
                    break;
                }
                this.addStylizedCell(record, this.formatListener.formatNumberDateCell((CellValueRecordInterface)formula));
                break;
            }
            case 519: {
                if (this.previousSid != 6) break;
                StringRecord sr = (StringRecord)record;
                this.addStylizedCell((Record)this.stringFormulaRecord, sr.getString());
                break;
            }
            case 516: {
                LabelRecord label = (LabelRecord)record;
                this.addStylizedCell(record, label.getValue());
                break;
            }
            case 253: {
                LabelSSTRecord sst = (LabelSSTRecord)record;
                UnicodeString unicode = this.sstRecord.getString(sst.getSSTIndex());
                this.addStylizedCell(record, unicode.getString());
                break;
            }
            case 515: {
                NumberRecord number = (NumberRecord)record;
                this.addStylizedCell(record, this.formatListener.formatNumberDateCell((CellValueRecordInterface)number));
                break;
            }
            case 224: {
                ExtendedFormatRecord ext = (ExtendedFormatRecord)record;
                this.extendedFormatRecords.add(ext);
                break;
            }
            case 49: {
                FontRecord fr = (FontRecord)record;
                this.fontRecords.add(fr);
                break;
            }
            case 229: {
                MergeCellsRecord mergeRecord = (MergeCellsRecord)record;
                this.mergesCellsRecords.add(mergeRecord);
            }
        }
        this.previousSid = record.getSid();
        if (this.stringFormulaRecord != record) {
            this.stringFormulaRecord = null;
        }
    }

    private void addCell(Record record, Cell cell) throws SAXException {
        if (cell != null) {
            if (this.currentSheet != null && record instanceof CellValueRecordInterface) {
                CellValueRecordInterface value = (CellValueRecordInterface)record;
                Point point = new Point(value.getColumn(), value.getRow());
                this.currentSheet.put(point, cell);
            } else {
                this.extraTextCells.add(cell);
            }
        }
    }

    private void addStylizedCell(Record record, String text) throws SAXException {
        if (text != null && (text = text.trim()).length() > 0) {
            if (record instanceof CellValueRecordInterface) {
                CellValueRecordInterface value = (CellValueRecordInterface)record;
                ExtendedFormatRecord efr = this.extendedFormatRecords.get(value.getXFIndex());
                short index = efr.getFontIndex();
                if (index > 4) {
                    index = (short)(index - 1);
                }
                this.addCell(record, new StylizedCell(text, efr, this.fontRecords.get(index)));
            } else {
                this.addCell(record, new StylizedCell(text));
            }
        }
    }

    private void newSheet() {
        this.currentSheetIndex = (short)(this.currentSheetIndex + 1);
        this.currentSheet = new TreeMap<Point, Cell>(new PointComparator());
    }

    private CellRangeAddress getMergedArea(int rowIndex, int colIndex) {
        Iterator<MergeCellsRecord> iteratorMergeRecords = this.mergesCellsRecords.iterator();
        CellRangeAddress ret = null;
        boolean found = false;
        while (iteratorMergeRecords.hasNext() && !found) {
            MergeCellsRecord record = iteratorMergeRecords.next();
            int index = 0;
            while (index < record.getNumAreas() && !found) {
                ret = record.getAreaAt(index);
                if (rowIndex >= ret.getFirstRow() && rowIndex <= ret.getLastRow() && colIndex >= ret.getFirstColumn() && colIndex <= ret.getLastColumn()) {
                    found = true;
                }
                ++index;
            }
        }
        return found ? ret : null;
    }

    private int mergedAreaLastRow(SubRow row) {
        Iterator iteratorRow = row.iterator();
        CellRangeAddress area = null;
        while (iteratorRow.hasNext()) {
            CellsGroup cellsGroup = (CellsGroup)iteratorRow.next();
            area = this.getMergedArea(cellsGroup.getRowIndex(), cellsGroup.getFirstColumn());
            if (area == null) continue;
            return area.getLastRow();
        }
        return row.getRowIndex();
    }

    private int mergedAreaLastColumn(CellsGroup cellsGroup) {
        CellRangeAddress area = this.getMergedArea(cellsGroup.getRowIndex(), cellsGroup.getLastColumn());
        if (area != null) {
            return area.getLastColumn();
        }
        return cellsGroup.getLastColumn();
    }

    private CellRangeAddress areContiguous(Point previousPoint, Point currentPoint) {
        CellRangeAddress area;
        CellRangeAddress ret = null;
        if (currentPoint.y == previousPoint.y && currentPoint.x != previousPoint.x && (area = this.getMergedArea(previousPoint.y, previousPoint.x)) != null && currentPoint.x == area.getLastColumn() + 1) {
            ret = area;
        }
        return ret;
    }

    public Table findTable(SubRow subrow) {
        SubRowScore subrowScore = new SubRowScore(subrow);
        LinkedList<SubRowScore> arrayScore = new LinkedList<SubRowScore>();
        arrayScore.add(subrowScore);
        Table table = new Table(subrowScore);
        table.setHeader(subrowScore);
        ArrayList<SubRow> subRowsReferences = new ArrayList<SubRow>();
        subRowsReferences.add(subrowScore);
        ArrayList<Line> LinesReferences = new ArrayList<Line>();
        LinesReferences.add(this._lines_read.get(this._index));
        SubRow tmpSubrow = subrow;
        boolean goOut = false;
        int indexSave = this._index;
        SubRow maxNumberSubRow = subrow;
        int maxNbElement = subrow.getCellsNb();
        int alignedSubRowNb = 0;
        int LastAreaRow = 0;
        HashSet<Integer> setCol = new HashSet<Integer>();
        for (CellsGroup cg : maxNumberSubRow) {
            int column = cg.getFirstColumn();
            int i = 0;
            while (i < cg.getCellsNb()) {
                setCol.add(column);
                ++column;
                ++i;
            }
        }
        while (!goOut && indexSave < this._lines_read.size()) {
            int nextLineNumber = this._lines_read.get(indexSave).getLineIndex();
            LastAreaRow = this.mergedAreaLastRow(tmpSubrow);
            int offset = 1;
            while (nextLineNumber < LastAreaRow + 1 && indexSave + offset < this._lines_read.size()) {
                nextLineNumber = this._lines_read.get(indexSave + offset).getLineIndex();
                ++offset;
            }
            Iterator<SubRow> nextLineIterator = null;
            if (nextLineNumber != LastAreaRow + 1) {
                if (table.getNbRows() != 1) break;
                goOut = true;
                break;
            }
            nextLineIterator = this._lines_read.get(indexSave += offset - 1).iterator();
            tmpSubrow = new SubRowSimple();
            while (!goOut && nextLineIterator.hasNext()) {
                SubRow nextSubrow = nextLineIterator.next();
                int[] excess = subrow.excess(nextSubrow);
                if (excess[0] <= 0 && excess[1] <= 0) {
                    tmpSubrow.addSubRowCellsGroup(nextSubrow);
                    subRowsReferences.add(nextSubrow);
                    LinesReferences.add(this._lines_read.get(indexSave));
                    continue;
                }
                if (nextSubrow.get_lastColumn() < subrow.get_firstColumn() || subrow.get_lastColumn() < nextSubrow.get_firstColumn()) break;
                goOut = true;
            }
            if (tmpSubrow.getCellsNb() == 0) {
                goOut = true;
                continue;
            }
            subrowScore = new SubRowScore(tmpSubrow);
            table.addSubRow(subrowScore);
            arrayScore.add(subrowScore);
            int nbElements = subrowScore.getCellsNb();
            if (nbElements <= maxNbElement) continue;
            maxNbElement = nbElements;
            maxNumberSubRow = subrowScore;
            table.setHeader(subrowScore);
            alignedSubRowNb = 0;
            setCol = new HashSet();
            for (CellsGroup cg : maxNumberSubRow) {
                int column = cg.getFirstColumn();
                int i = 0;
                while (i < cg.getCellsNb()) {
                    setCol.add(column);
                    ++column;
                    ++i;
                }
            }
        }
        if (goOut) {
            return null;
        }
        for (SubRow row : table) {
            Iterator iterator = row.iterator();
            boolean goOutMax = false;
            while (iterator.hasNext() && !goOutMax) {
                CellsGroup cg;
                cg = (CellsGroup)iterator.next();
                int column = cg.getFirstColumn();
                int cpt = 0;
                while (cpt < cg.getCellsNb() && !goOutMax) {
                    if (!setCol.contains(column)) {
                        goOutMax = true;
                    }
                    ++column;
                    ++cpt;
                }
            }
            if (goOutMax) continue;
            ((SubRowScore)row).setAligned();
            ++alignedSubRowNb;
        }
        float percentage = (float)alignedSubRowNb / (float)table.getNbRows();
        if ((double)percentage < 0.5) {
            return null;
        }
        Collections.sort(arrayScore, new SubRowScoreComparator());
        Iterator iteratorScore = arrayScore.iterator();
        int hiearchy = 0;
        SubRowScore previousScore = (SubRowScore)iteratorScore.next();
        previousScore.setHiearchy(hiearchy);
        if (previousScore.getRowIndex() < table.getHeader().getRowIndex()) {
            goOut = true;
        }
        while (iteratorScore.hasNext() && !goOut) {
            SubRowScore score = (SubRowScore)iteratorScore.next();
            if (new SubRowScoreComparator().compare(score, previousScore) != 0) {
                ++hiearchy;
            }
            score.setHiearchy(hiearchy);
            if (hiearchy > 0 && score.getRowIndex() < table.getHeader().getRowIndex()) {
                goOut = true;
            }
            previousScore = score;
        }
        if (goOut) {
            return null;
        }
        ((SubRowScore)table.getHeader()).setSubRowType(SubRowScore.SubRowFunction.Header);
        table.setMaxHiearchy(hiearchy);
        int ref = 0;
        while (ref < subRowsReferences.size()) {
            Line line = (Line)LinesReferences.get(ref);
            line.removeSubRow((SubRow)subRowsReferences.get(ref));
            ++ref;
        }
        return table;
    }

    private void processStructuredSheet() throws IOException {
        Line currentLine2 = new Line();
        for (Line currentLine2 : this._lines_read) {
            for (SubRow subrow : currentLine2) {
                Table table = this.findTable(subrow);
                if (table != null) {
                    this.defineTableElements(table);
                    this._spreadSheetElements.add(table);
                    continue;
                }
                this._spreadSheetElements.add(subrow);
            }
            ++this._index;
        }
        this._lines_read.clear();
    }

    private void defineTableElements(Table table) {
        String title = "";
        Iterator<SpreadSheetElement> it = this._spreadSheetElements.descendingIterator();
        while (it.hasNext()) {
            SpreadSheetElement elt = it.next();
            if (elt instanceof Table) {
                Table previoustable = (Table)elt;
                if (previoustable.getLastRowIndex() >= table.getFirstRowIndex()) continue;
                break;
            }
            SubRow subrow = (SubRow)elt;
            if (subrow.getCellsNb() != 1) continue;
            if (table.getHeader().excess(subrow)[0] <= 0 && subrow.get_firstColumn() < table.getHeader().get_lastColumn()) {
                title = subrow.getText();
                break;
            }
            if (title.length() != 0) continue;
            title = subrow.getText();
        }
        table.setTitle(title);
        if (table.getMaxHiearchy() != 0) {
            for (SubRow subRow : table) {
                SubRowScore ss = (SubRowScore)subRow;
                if (ss.getHiearchy() != 0) {
                    CellsGroup previousGrp;
                    Iterator<CellsGroup> grpIterator = ss.iterator();
                    CellsGroup currentGrp = previousGrp = grpIterator.next();
                    boolean gap = false;
                    while (grpIterator.hasNext() && !gap) {
                        currentGrp = grpIterator.next();
                        if (currentGrp.getFirstColumn() != previousGrp.getLastColumn() + 1) {
                            gap = true;
                        }
                        previousGrp = currentGrp;
                    }
                    if (!gap && currentGrp.getLastColumn() == table.getHeader().get_lastGroup().getLastColumn() && ss.getCellsNb() > 1) {
                        ss.setSubRowType(SubRowScore.SubRowFunction.Header);
                        continue;
                    }
                    ss.setSubRowType(SubRowScore.SubRowFunction.Title);
                    continue;
                }
                ss.setSubRowType(SubRowScore.SubRowFunction.DataContent);
            }
        } else {
            ((SubRowScore)table.getHeader()).setSubRowType(SubRowScore.SubRowFunction.Header);
        }
    }

    private void processSheet() throws SAXException, IOException {
        Iterator iterator = ((TreeMap)this.currentSheet).descendingKeySet().descendingIterator();
        Point previousPoint = new Point(-1, -1);
        Point currentPoint = new Point(-1, -1);
        StylizedCell currentCell = new StylizedCell("");
        Line currentLine = new Line();
        this._lines_read.clear();
        this._index = 0;
        CellsGroup currentCellGroup = new CellsGroup();
        SubRowSimple currentSubrow = new SubRowSimple();
        while (iterator.hasNext()) {
            currentPoint = (Point)iterator.next();
            currentCell = (StylizedCell)this.currentSheet.get(currentPoint);
            if (previousPoint.y != currentPoint.y) {
                currentCellGroup.setLastColumn(this.mergedAreaLastColumn(currentCellGroup));
                currentCellGroup = new CellsGroup(currentPoint, currentCell);
                currentSubrow = new SubRowSimple();
                currentSubrow.addCellsGroup(currentCellGroup);
                currentLine = new Line(currentPoint.y);
                currentLine.addSubRow(currentSubrow);
                this._lines_read.add(currentLine);
            } else if (currentPoint.x != previousPoint.x + 1) {
                CellRangeAddress area = this.areContiguous(previousPoint, currentPoint);
                if (area == null) {
                    currentSubrow = new SubRowSimple();
                    currentLine.addSubRow(currentSubrow);
                    currentCellGroup.setLastColumn(previousPoint.x);
                } else {
                    currentCellGroup.setLastColumn(area.getLastColumn());
                }
                currentCellGroup = new CellsGroup(currentPoint, currentCell);
                currentSubrow.addCellsGroup(currentCellGroup);
            } else {
                currentCellGroup.addCell(currentPoint, currentCell);
            }
            previousPoint = currentPoint;
        }
        this.processStructuredSheet();
    }

    private static class PointComparator
    implements Comparator<Point> {
        private PointComparator() {
        }

        @Override
        public int compare(Point a, Point b) {
            int diff = a.y - b.y;
            if (diff == 0) {
                diff = a.x - b.x;
            }
            return diff;
        }
    }
}

