/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.ui.providers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.deferred.DeferredContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.WorkbenchJob;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.exceptions.EngineException;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.engine.ITypedTraceabilityEngine;
import org.polarsys.reqcycle.traceability.ui.providers.BusinessDeffered;
import org.polarsys.reqcycle.traceability.utils.EngineUtils;
import org.polarsys.reqcycle.uri.IReachableListener;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.model.Reachable;

public class RequestContentProvider
extends DeferredContentProvider
implements ITreeContentProvider,
IReachableListener {
    public static final String CONF_KEY = "conf";
    public static final String EXPAND_ALL = "expandAll";
    @Inject
    ITraceabilityEngine defaultEngine;
    @Inject
    ITypedTraceabilityEngine typedEngine;
    @Inject
    IReachableListenerManager listenerManger;
    @Inject
    ITypesConfigurationProvider typeProvider;
    Multimap<Reachable, Link> links = ArrayListMultimap.create();
    private Collection<Request> requests = new LinkedList<Request>();
    private TreeViewer treeViewer;
    private Object newInput;
    private Request baseRequest = null;
    private DeferredTreeContentManager contentManager;
    private Set<Object> allParents = new HashSet<Object>();

    public RequestContentProvider() {
        super((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
    }

    public void dispose() {
        this.listenerManger.removeReachableListener((IReachableListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.treeViewer = (TreeViewer)viewer;
        this.newInput = newInput;
        this.listenerManger.removeReachableListener((IReachableListener)this);
        this.allParents.clear();
        this.links.clear();
        this.requests.clear();
        this.contentManager = new DeferredTreeContentManager((AbstractTreeViewer)viewer){

            protected void addChildren(final Object parent, final Object[] children, IProgressMonitor monitor) {
                WorkbenchJob updateJob = new WorkbenchJob(ProgressMessages.DeferredTreeContentManager_AddingChildren){

                    public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                        if (RequestContentProvider.this.treeViewer.getControl().isDisposed() || updateMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        RequestContentProvider.this.treeViewer.add(parent, children);
                        if (RequestContentProvider.this.isSync()) {
                            Object[] objectArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                if (o instanceof BusinessDeffered) {
                                    BusinessDeffered bd = (BusinessDeffered)o;
                                    RequestContentProvider.this.treeViewer.expandToLevel((Object)bd, bd.getLevel() + 1);
                                }
                                ++n2;
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                updateJob.setSystem(true);
                updateJob.schedule();
            }
        };
    }

    public Object[] getElements(Object inputElement) {
        if (this.newInput instanceof Request) {
            this.links.clear();
            this.requests.clear();
            this.baseRequest = (Request)this.newInput;
            this.requests.add(this.baseRequest);
        } else if (this.newInput instanceof Collection) {
            this.links.clear();
            this.requests.clear();
            Collection newInput2 = (Collection)this.newInput;
            if (!newInput2.isEmpty()) {
                this.requests.addAll(newInput2);
                this.baseRequest = this.requests.iterator().next();
            }
        }
        LinkedList<BusinessDeffered> result = new LinkedList<BusinessDeffered>();
        for (Request r : this.requests) {
            for (Request.Couple c : r.getCouples()) {
                Reachable source = c.getSource();
                if (source == null) continue;
                this.listenerManger.addReachableListener(source, (IReachableListener)this);
                this.listenerManger.addReachableListener(source.trimFragment(), (IReachableListener)this);
                result.add(new BusinessDeffered(source, this));
            }
        }
        return result.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        return this.contentManager.getChildren(parentElement);
    }

    private Iterator<Pair<Link, Reachable>> getTraceability(Request r) throws EngineException {
        Object conf = r.getProperty(CONF_KEY);
        Configuration defaultConfiguration = this.typeProvider.getDefaultConfiguration();
        if (defaultConfiguration != null && Boolean.TRUE.equals(conf)) {
            return this.typedEngine.getTraceability(defaultConfiguration, new Request[]{r});
        }
        return this.defaultEngine.getTraceability(new Request[]{r});
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.contentManager.mayHaveChildren(element);
    }

    public void hasChanged(Reachable[] reachable) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (RequestContentProvider.this.treeViewer != null) {
                    Object[] objects = RequestContentProvider.this.treeViewer.getExpandedElements();
                    RequestContentProvider.this.treeViewer.refresh();
                    RequestContentProvider.this.treeViewer.setExpandedElements(objects);
                }
            }
        });
    }

    public Collection<Object> doGetChildren(Object parentElement) {
        if (!this.allParents.contains(parentElement)) {
            this.allParents.add(parentElement);
        } else if (this.isSync()) {
            return Collections.emptyList();
        }
        LinkedList<Object> result = new LinkedList<Object>();
        if (parentElement instanceof Reachable) {
            Reachable reachable = (Reachable)parentElement;
            Collection c = this.links.get((Object)reachable);
            if (c.isEmpty()) {
                if (this.baseRequest.getDepth() == Request.DEPTH.INFINITE) {
                    if (!Boolean.TRUE.equals(this.baseRequest.getProperty("COMPUTED"))) {
                        try {
                            Iterator<Pair<Link, Reachable>> traceIterator = this.getTraceability(this.baseRequest);
                            this.links.putAll(EngineUtils.toFollowingMap(traceIterator));
                            c = this.links.get((Object)reachable);
                            this.baseRequest.addProperty("COMPUTED", (Object)true);
                        }
                        catch (EngineException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    Request r = new Request().addProperty("optionCheckCache", (Object)true).setDepth(Request.DEPTH.ONE).setDirection(this.baseRequest.getDirection()).setScope(this.baseRequest.getScope()).addProperty(CONF_KEY, this.baseRequest.getProperty(CONF_KEY));
                    ArrayList listOfCouples = Lists.newArrayList((Iterable)this.baseRequest.getCouples());
                    for (Request.Couple cTmp : listOfCouples) {
                        r.addSourceAndCondition(reachable, cTmp.getStopCondition());
                        if (cTmp.getStopCondition() == null) continue;
                        r.setDepth(Request.DEPTH.INFINITE);
                    }
                    try {
                        Iterator<Pair<Link, Reachable>> traceIterator = this.getTraceability(r);
                        this.links.putAll(EngineUtils.toFollowingMap(traceIterator));
                        c = this.links.get((Object)reachable);
                    }
                    catch (EngineException e) {
                        e.printStackTrace();
                    }
                }
            }
            result.addAll(c);
        } else if (parentElement instanceof Link) {
            Set targets = ((Link)parentElement).getTargets();
            for (Reachable r : targets) {
                this.listenerManger.addReachableListener(r, (IReachableListener)this);
                this.listenerManger.addReachableListener(r.trimFragment(), (IReachableListener)this);
                result.add(r);
            }
        }
        return result;
    }

    private boolean isSync() {
        return String.valueOf(true).equals(this.treeViewer.getData(EXPAND_ALL));
    }
}

