/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.table.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.exceptions.EngineException;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.scopes.CompositeScope;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.traceability.model.scopes.Scopes;
import org.polarsys.reqcycle.traceability.storage.IStorageProvider;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.traceability.table.model.TransverseLink;
import org.polarsys.reqcycle.traceability.table.providers.TraceabilityLazyContentProvider;
import org.polarsys.reqcycle.traceability.types.scopes.ConfigurationScope;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.model.Reachable;

public class TableController {
    @Inject
    protected IStorageProvider provider;
    @Inject
    protected IReachableListenerManager listenerManager;
    @Inject
    protected ITraceabilityEngine engine;
    protected TableViewer viewer;
    protected Callable<Iterable<?>> callable;

    public TableController(TableViewer viewer) {
        this.viewer = viewer;
    }

    public void displayAllLinks() {
        this.callable = new Callable<Iterable<?>>(){

            @Override
            public Iterable<?> call() throws Exception {
                return TableController.this.getLinksFromEngine();
            }
        };
        this.refreshViewerData();
    }

    public void displayExplicitLinks(final IProject project) {
        this.callable = new Callable<Iterable<?>>(){

            @Override
            public Iterable<?> call() throws Exception {
                return TableController.this.getLinksFromProject(project);
            }
        };
        this.refreshViewerData();
    }

    protected Iterable<Link> getLinksFromEngine() {
        return new Iterable<Link>(){

            @Override
            public Iterator<Link> iterator() {
                new Date().getTime();
                Request request = new Request();
                CompositeScope scope = new CompositeScope();
                scope.add(Scopes.getWorkspaceScope());
                scope.add((IScope)new ConfigurationScope());
                request.setScope((IScope)scope);
                request.setDepth(Request.DEPTH.INFINITE);
                try {
                    Iterator traceability = TableController.this.engine.getTraceability(new Request[]{request});
                    return Iterators.transform((Iterator)traceability, (Function)new Function<Pair<Link, Reachable>, Link>(){

                        public Link apply(Pair<Link, Reachable> arg0) {
                            return (Link)arg0.getFirst();
                        }
                    });
                }
                catch (EngineException e) {
                    e.printStackTrace();
                    return new ArrayList().iterator();
                }
            }
        };
    }

    protected Iterable<Link> getLinksFromProject(final IProject project) {
        ITraceabilityStorage storage = this.provider.getProjectStorage(project);
        Iterable allTraceabilityLinks = storage.getAllTraceability(ITraceabilityEngine.DIRECTION.DOWNWARD);
        return Iterables.transform((Iterable)allTraceabilityLinks, (Function)new Function<Pair<Link, Reachable>, Link>(){

            public Link apply(Pair<Link, Reachable> arg0) {
                return new TransverseLink((Link)arg0.getFirst(), project);
            }
        });
    }

    public void deleteTraceabilityLinks(Iterator<TransverseLink> links) {
        ITraceabilityStorage storage = null;
        IProject project = null;
        try {
            try {
                HashSet notification = Sets.newHashSet();
                while (links.hasNext()) {
                    TransverseLink link = links.next();
                    if (storage == null) {
                        project = link.getProject();
                        storage = this.provider.getProjectStorage(project);
                        storage.startTransaction();
                    }
                    Reachable source = (Reachable)Iterables.get((Iterable)link.getSources(), (int)0);
                    Reachable target = (Reachable)Iterables.get((Iterable)link.getTargets(), (int)0);
                    if (storage == null) continue;
                    storage.removeTraceabilityLink(link.getId());
                    notification.add(link.getId());
                    notification.add(source);
                    notification.add(target);
                    notification.add(link.getId().trimFragment());
                }
                if (storage != null) {
                    storage.commit();
                    this.listenerManager.notifyChanged(notification.toArray(new Reachable[0]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                storage.rollback();
                storage.save();
                this.refreshViewerData();
            }
        }
        finally {
            storage.save();
            this.refreshViewerData();
        }
    }

    public void refreshViewerData() {
        Predicate<Object> filter = new Predicate<Object>(){

            public boolean apply(Object arg0) {
                ViewerFilter[] filters = TableController.this.viewer.getFilters();
                int i = 0;
                while (i < filters.length) {
                    ViewerFilter filter = filters[i];
                    if (!filter.select((Viewer)TableController.this.viewer, null, arg0)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
        try {
            Iterable<?> input = this.callable.call();
            Iterable filtered = Iterables.filter(input, (Predicate)filter);
            long start = new Date().getTime();
            int count = Iterables.size((Iterable)filtered);
            this.viewer.setItemCount(count);
            new Date().getTime();
            this.viewer.setInput((Object)filtered);
            this.viewer.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshViewerVisuals() {
        TraceabilityLazyContentProvider contentProvider = (TraceabilityLazyContentProvider)this.viewer.getContentProvider();
        this.viewer.setItemCount(Iterables.size((Iterable)((Iterable)this.viewer.getInput())));
        contentProvider.clearCache();
        this.viewer.refresh();
    }
}

