/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.jdt.handlers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaProject;
import org.polarsys.reqcycle.jdt.model.JDTReachableObject;
import org.polarsys.reqcycle.jdt.utils.JDTUtils;
import org.polarsys.reqcycle.types.ITypeChecker;
import org.polarsys.reqcycle.uri.model.IObjectHandler;
import org.polarsys.reqcycle.uri.model.IReachableHandler;
import org.polarsys.reqcycle.uri.model.ProxyResolver;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class JDTReachableHandler
implements IReachableHandler,
IObjectHandler,
ITypeChecker {
    public ReachableObject getFromReachable(Reachable t) {
        JDTReachableObject jdtReachableObject = new JDTReachableObject(t);
        ZigguratInject.inject((Object[])new Object[]{jdtReachableObject});
        return jdtReachableObject;
    }

    public boolean handlesReachable(Reachable t) {
        return t != null && t.getPath() != null && t.getPath().endsWith(".java");
    }

    public ReachableObject getFromObject(Object object) {
        IFile file;
        if (object instanceof IFile && "java".equalsIgnoreCase((file = (IFile)object).getFileExtension())) {
            return JDTUtils.getReachable(file);
        }
        if (object instanceof IJavaElement) {
            IJavaElement cu = (IJavaElement)object;
            return JDTUtils.getReachable(cu);
        }
        return null;
    }

    public boolean handlesObject(Object object) {
        IFile file;
        if (object instanceof IFile && "java".equalsIgnoreCase((file = (IFile)object).getFileExtension())) {
            return JavaProject.hasJavaNature((IProject)file.getProject());
        }
        return object instanceof IJavaElement && !(object instanceof IJavaProject);
    }

    public boolean apply(Reachable reachable) {
        return this.handlesReachable(reachable);
    }

    public ProxyResolver getProxyResolver() {
        return null;
    }
}

