/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.types.internal;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.polarsys.reqcycle.repository.data.types.IType;

public class ETypeImpl
implements IType,
IAdaptable {
    private String name = null;
    private EClassifier eType;
    public static final ETypeImpl BYTE = new ETypeImpl(EcorePackage.Literals.EBYTE.getName().replaceFirst("E", ""), (EClassifier)EcorePackage.Literals.EBYTE);
    public static final ETypeImpl STRING = new ETypeImpl(EcorePackage.Literals.ESTRING.getName().replaceFirst("E", ""), (EClassifier)EcorePackage.Literals.ESTRING);
    public static final ETypeImpl INT = new ETypeImpl(EcorePackage.Literals.EINT.getName().replaceFirst("E", ""), (EClassifier)EcorePackage.Literals.EINT);
    public static final ETypeImpl LONG = new ETypeImpl(EcorePackage.Literals.ELONG.getName().replaceFirst("E", ""), (EClassifier)EcorePackage.Literals.ELONG);
    public static final ETypeImpl BIG_DECIMAL = new ETypeImpl(EcorePackage.Literals.EBIG_DECIMAL.getName().replaceFirst("E", ""), (EClassifier)EcorePackage.Literals.EBIG_DECIMAL);
    public static final ETypeImpl CHAR = new ETypeImpl(EcorePackage.Literals.ECHAR.getName().replaceFirst("E", ""), (EClassifier)EcorePackage.Literals.ECHAR);
    public static final ETypeImpl FLOAT = new ETypeImpl(EcorePackage.Literals.EFLOAT.getName().replaceFirst("E", ""), (EClassifier)EcorePackage.Literals.EFLOAT);
    public static final ETypeImpl DOUBLE = new ETypeImpl(EcorePackage.Literals.EDOUBLE.getName().replaceFirst("E", ""), (EClassifier)EcorePackage.Literals.EDOUBLE);
    public static final ETypeImpl SHORT = new ETypeImpl(EcorePackage.Literals.ESHORT.getName().replaceFirst("E", ""), (EClassifier)EcorePackage.Literals.ESHORT);
    public static final ETypeImpl BIG_INTEGER = new ETypeImpl(EcorePackage.Literals.EBIG_INTEGER.getName().replaceFirst("E", ""), (EClassifier)EcorePackage.Literals.EBIG_INTEGER);
    public static final ETypeImpl BOOLEAN = new ETypeImpl(EcorePackage.Literals.EBOOLEAN.getName().replaceFirst("E", ""), (EClassifier)EcorePackage.Literals.EBOOLEAN);
    public static final Set<ETypeImpl> eBasicTypes = Sets.newHashSet((Object[])new ETypeImpl[]{BYTE, STRING, INT, LONG, BIG_DECIMAL, CHAR, FLOAT, DOUBLE, SHORT, BIG_INTEGER, BOOLEAN});
    public static final Map<EClassifier, ETypeImpl> eBasicTypesMap = Maps.uniqueIndex(eBasicTypes, (Function)new Function<ETypeImpl, EClassifier>(){

        public EClassifier apply(ETypeImpl t) {
            return t.getEType();
        }
    });

    protected ETypeImpl(EClassifier eType) {
        this.eType = eType;
    }

    protected ETypeImpl(String name, EClassifier eType) {
        this.name = name;
        this.eType = eType;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return this.getEType().getName();
        }
        return this.name;
    }

    public EClassifier getEType() {
        return this.eType;
    }

    public Object getAdapter(Class adapter) {
        if (EClassifier.class.isAssignableFrom(adapter)) {
            return this.getEType();
        }
        return null;
    }

    public static ETypeImpl createEType(EClassifier eType) {
        ETypeImpl basicType = eBasicTypesMap.get(eType);
        if (basicType != null) {
            return basicType;
        }
        return new ETypeImpl(eType);
    }
}

