/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.iterators.collectors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.polarsys.reqcycle.utils.iterators.collectors.DepthHarvester;
import org.polarsys.reqcycle.utils.iterators.exceptions.CannotHandleException;
import org.polarsys.reqcycle.utils.iterators.exceptions.CollectionAbortedException;
import org.polarsys.reqcycle.utils.iterators.exceptions.PickerExecutionException;
import org.polarsys.reqcycle.utils.iterators.handlers.ResultHandler;
import org.polarsys.reqcycle.utils.iterators.pickers.IPicker;

public class DepthMeasuringHarvester
extends DepthHarvester {
    protected Map<Object, Integer> longestPath = new HashMap<Object, Integer>();

    public DepthMeasuringHarvester() {
    }

    public DepthMeasuringHarvester(Object startingElement) {
        super(startingElement);
    }

    @Override
    public void collect(ResultHandler<Object> handler) throws CollectionAbortedException {
        this.getLongestPathMap().put(this.start, 0);
        this.collectDepthWise(handler, this.start, 0);
    }

    public Map<Object, Integer> getLongestPathMap() {
        return this.longestPath;
    }

    protected void collectDepthWise(ResultHandler<Object> handler, Object element, int depth) throws CollectionAbortedException {
        try {
            handler.handleResult(element);
            for (IPicker picker : this.getPickers()) {
                Iterable<?> nexts = picker.getNexts(element);
                if (nexts == null) continue;
                for (Object next : nexts) {
                    Integer nextOldDepth = this.getLongestPathMap().get(next);
                    Integer nextCurrentDepth = Math.max(nextOldDepth != null ? nextOldDepth : -1, depth + 1);
                    if (nextCurrentDepth != nextOldDepth) {
                        this.getLongestPathMap().put(next, nextCurrentDepth);
                    }
                    this.collectDepthWise(handler, next, nextCurrentDepth);
                }
            }
        }
        catch (CannotHandleException cannotHandleException) {
        }
        catch (PickerExecutionException e) {
            throw new CollectionAbortedException(e);
        }
    }

    public List<Object> getElementsFromDeepest() {
        Set<Object> keySet = this.longestPath.keySet();
        ArrayList result = Lists.newArrayList(keySet);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                Integer depth0 = DepthMeasuringHarvester.this.getLongestPathMap().get(arg0);
                Integer depth1 = DepthMeasuringHarvester.this.getLongestPathMap().get(arg1);
                if (depth0 > depth1) {
                    return -1;
                }
                if (depth0 == depth1) {
                    return 0;
                }
                return 1;
            }
        });
        return result;
    }
}

