/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.ui.preference.pages;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.ui.Activator;
import org.polarsys.reqcycle.repository.data.ui.dialog.NameDialog;
import org.polarsys.reqcycle.repository.data.ui.preference.PreferenceUiUtil;
import org.polarsys.reqcycle.repository.data.ui.preference.pages.DataModelsPreferencePage;

public class ScopesPreferencePage
extends DataModelsPreferencePage {
    protected TableViewer tvScopes;
    protected Table tScopes;
    protected TableViewerColumn tvcScopesNames;
    protected IDataModel selectedModel;
    protected Collection<Scope> inputScopes = new ArrayList<Scope>();
    protected Button btnAddScope;
    protected Button btnEditScope;
    private Button btnDeleteScope;

    @Override
    protected void performDefaults() {
        super.performDefaults();
        if (this.inputScopes != null) {
            this.inputScopes.clear();
        }
        if (this.tvScopes != null) {
            this.tvScopes.refresh();
        }
    }

    @Override
    public void doCreateContents(Composite control) {
        Group scopesGrp = PreferenceUiUtil.createGroup(control, "Scopes");
        this.createScopesUi(scopesGrp);
    }

    @Override
    public void hookListeners() {
        super.hookListeners();
        this.tvModels.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                ScopesPreferencePage.this.btnAddScope.setEnabled(false);
                ScopesPreferencePage.this.inputScopes.clear();
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IDataModel) {
                    ScopesPreferencePage.this.selectedModel = (IDataModel)obj;
                    ScopesPreferencePage.this.btnAddScope.setEnabled(true);
                    ScopesPreferencePage.this.inputScopes.addAll(ScopesPreferencePage.this.dataModelManager.getScopes(ScopesPreferencePage.this.selectedModel));
                }
                ScopesPreferencePage.this.tvScopes.refresh();
            }
        });
        this.btnAddScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NameDialog dialog = new NameDialog(e.display.getActiveShell(), "Add Scope");
                if (dialog.open() == 0) {
                    String name = dialog.getName();
                    Scope scope = ScopesPreferencePage.this.dataModelManager.createScope(name, ScopesPreferencePage.this.selectedModel);
                    ScopesPreferencePage.this.dataModelManager.addScopes(ScopesPreferencePage.this.selectedModel, new Scope[]{scope});
                    ScopesPreferencePage.this.inputScopes.add(scope);
                    ScopesPreferencePage.this.tvScopes.setInput(ScopesPreferencePage.this.inputScopes);
                    ScopesPreferencePage.this.tvScopes.refresh();
                }
            }
        });
    }

    protected void createScopesUi(Group parent) {
        Composite viewerComposite = new Composite((Composite)parent, 0);
        viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout dataTypeTVLayout = new TableColumnLayout();
        viewerComposite.setLayout((Layout)dataTypeTVLayout);
        this.tvScopes = new TableViewer(viewerComposite);
        this.tvScopes.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tScopes = this.tvScopes.getTable();
        this.tScopes.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tScopes.setLinesVisible(true);
        this.tvcScopesNames = PreferenceUiUtil.createTableViewerColumn(this.tvScopes, "Name", 0);
        this.tvcScopesNames.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Scope) {
                    return ((Scope)element).getName();
                }
                return super.getText(element);
            }
        });
        dataTypeTVLayout.setColumnData((Widget)this.tvcScopesNames.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100, true));
        this.tvScopes.setInput(this.inputScopes);
        Composite btnComposite = new Composite((Composite)parent, 0);
        btnComposite.setLayout((Layout)new GridLayout());
        btnComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.btnAddScope = PreferenceUiUtil.createButton(btnComposite, "Add Scope", Activator.getImageDescriptor("/icons/add.gif").createImage());
        this.btnAddScope.setEnabled(false);
        this.btnEditScope = PreferenceUiUtil.createButton(btnComposite, "Edit Scope", Activator.getImageDescriptor("/icons/edit.png").createImage());
        this.btnEditScope.setEnabled(false);
        this.btnDeleteScope = PreferenceUiUtil.createButton(btnComposite, "Delete Scope", Activator.getImageDescriptor("/icons/delete.gif").createImage());
        this.btnDeleteScope.setEnabled(false);
    }
}

