/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.inject.Inject;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers.StorageHelpersProvider;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.Reachable;

public class ReachablesStorageHelper {
    private final RepositoryConnection conn;
    private final StorageHelpersProvider helpers;
    private static final ValueFactory valueFactory = ValueFactoryImpl.getInstance();
    @Inject
    protected IReachableCreator creator;

    ReachablesStorageHelper(RepositoryConnection conn, StorageHelpersProvider storageHelpersProvider) {
        this.conn = conn;
        this.helpers = storageHelpersProvider;
    }

    public static org.openrdf.model.URI getURI(Reachable reachable) {
        if (reachable == null) {
            return null;
        }
        return valueFactory.createURI(reachable.getURI().toString());
    }

    public org.openrdf.model.URI storeReachable(Reachable reachable, org.openrdf.model.URI type, Resource ... contexts) throws RepositoryException {
        org.openrdf.model.URI uri = ReachablesStorageHelper.getURI(reachable);
        this.conn.add((Resource)uri, RDF.TYPE, (Value)type, contexts);
        this.helpers.getPropertiesStorageHelper().storeProperties(uri, reachable.getProperties(), contexts);
        return uri;
    }

    public Reachable getStoredReachable(RepositoryConnection conn, org.openrdf.model.URI uri, Resource context) throws RepositoryException, URISyntaxException, QueryEvaluationException, MalformedQueryException {
        Reachable reachable = this.creator.getReachable(new URI(uri.stringValue()));
        Map<String, String> props = this.helpers.getPropertiesStorageHelper().getStoredProperties(uri, context);
        reachable.putAll(props);
        return reachable;
    }
}

