/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.model.Styling;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FontOption implements Enumerator
{
    ITALIC(0, "ITALIC", "ITALIC"),
    BOLD(1, "BOLD", "BOLD"),
    UNDERLINE(2, "UNDERLINE", "UNDERLINE"),
    STRIKE(3, "STRIKE", "STRIKE");

    public static final String copyright = "Copyright (c) 2014 AtoS\r\n    All rights reserved. This program and the accompanying materials\r\n    are made available under the terms of the Eclipse Public License v1.0\r\n    which accompanies this distribution, and is available at\r\n    http://www.eclipse.org/legal/epl-v10.html *\r\n    Contributors:\r\n      Sebastien Lemanceau (AtoS) - initial API and implementation and/or initial documentation";
    public static final int ITALIC_VALUE = 0;
    public static final int BOLD_VALUE = 1;
    public static final int UNDERLINE_VALUE = 2;
    public static final int STRIKE_VALUE = 3;
    private static final FontOption[] VALUES_ARRAY;
    public static final List<FontOption> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FontOption[]{ITALIC, BOLD, UNDERLINE, STRIKE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FontOption get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FontOption result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FontOption getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FontOption result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FontOption get(int value) {
        switch (value) {
            case 0: {
                return ITALIC;
            }
            case 1: {
                return BOLD;
            }
            case 2: {
                return UNDERLINE;
            }
            case 3: {
                return STRIKE;
            }
        }
        return null;
    }

    private FontOption(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

