/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ocl.ui;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.polarsys.reqcycle.ocl.OCLCallable;
import org.polarsys.reqcycle.ocl.ui.OCLPage;
import org.polarsys.reqcycle.ocl.ui.SettingBean;
import org.polarsys.reqcycle.ocl.ui.SettingPage;
import org.polarsys.reqcycle.repository.connector.ICallable;
import org.polarsys.reqcycle.repository.connector.IURIValidatorConnector;
import org.polarsys.reqcycle.repository.connector.ui.wizard.IConnectorWizard;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class OCLConnector
extends Wizard
implements IConnectorWizard,
IURIValidatorConnector {
    protected SettingPage oclSettingPage;
    protected OCLPage oclMappingPage;
    protected SettingBean bean = new SettingBean((IWizard)this);
    private RequirementSource requirementSource = null;
    @Inject
    IDataModelManager manager;
    @Inject
    IDataManager dataManager;

    public void addPages() {
        this.oclSettingPage = new SettingPage(this.bean);
        this.oclMappingPage = new OCLPage(this.bean);
        this.addPage((IWizardPage)this.oclSettingPage);
        this.addPage((IWizardPage)this.oclMappingPage);
        super.addPages();
    }

    public ICallable getRequirementsCreator() {
        OCLCallable callable = (OCLCallable)ZigguratInject.make(OCLCallable.class);
        return callable;
    }

    public void initializeWithRequirementSource(RequirementSource requirementSource) {
        this.requirementSource = requirementSource;
    }

    public boolean performFinish() {
        return true;
    }

    public boolean canFinish() {
        return this.bean != null && this.bean.getOclUri() != null && this.bean.getDataModel() != null && this.bean.getUri() != null && !this.bean.getOclUri().isEmpty() && !this.bean.getUri().isEmpty() && !this.bean.getOutputPath().isEmpty();
    }

    public void init(ISelection selection, String name) {
    }

    public void storeProperties(RequirementSource source) {
        this.bean.storeProperties(source);
    }

    public static Set<String> loadExtensions() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecore", "extension_parser");
        HashSet set = Sets.newHashSet((Iterable)Iterables.transform(Arrays.asList(elements), (Function)new Function<IConfigurationElement, String>(){

            public String apply(IConfigurationElement arg0) {
                return arg0.getAttribute("type").toLowerCase();
            }
        }));
        set.add("xmi");
        return set;
    }

    public IStatus validate(URI uri) {
        String extension;
        Set<String> EXTENSIONS = OCLConnector.loadExtensions();
        if (EXTENSIONS.contains((extension = uri.path().substring(uri.path().lastIndexOf(".") + 1, uri.path().length())).toLowerCase())) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.polarsys.reqcycle.ocl", "extension \"" + extension + "\" could not be supported");
    }
}

