/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ocl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.reqcycle.ocl.utils.OCLUtilities;
import org.polarsys.reqcycle.repository.connector.ICallable;
import org.polarsys.reqcycle.repository.connector.ui.PropertyUtils;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.utils.ocl.OCLEvaluator;
import org.polarsys.reqcycle.utils.ocl.ZigguratOCLPlugin;

public class OCLCallable
implements ICallable {
    @Inject
    IDataManager dataManager;
    Map<EObject, Section> sections = Maps.newHashMap();

    public void fillRequirementSource(RequirementSource source) throws Exception {
        Scope scope = PropertyUtils.getScopeFromSource((RequirementSource)source);
        this.fillRequirements(source, scope);
    }

    protected TreeIterator<EObject> getIterator(RequirementSource requirementSource, ResourceSet resourceSet) {
        String repositoryUri = requirementSource.getRepositoryURI();
        Resource resource = resourceSet.getResource(URI.createURI((String)repositoryUri), true);
        TreeIterator contents = resource.getAllContents();
        return contents;
    }

    protected void fillRequirements(RequirementSource requirementSource, Scope scope) throws Exception {
        requirementSource.clearContent();
        EList mapping = requirementSource.getMappings();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        OCLEvaluator evaluator = ZigguratOCLPlugin.compileOCL((ResourceSet)resourceSet, (URI)URI.createPlatformResourceURI((String)requirementSource.getProperty("org.polarsys.reqcycle.repository.connector.ui.ocl.uri"), (boolean)true));
        TreeIterator<EObject> contents = this.getIterator(requirementSource, (ResourceSet)resourceSet);
        Collection types = PropertyUtils.getDataModelFromSource((RequirementSource)requirementSource).getTypes();
        while (contents.hasNext()) {
            EObject eObject = (EObject)contents.next();
            if (OCLUtilities.isSection(evaluator, eObject)) {
                String id = (String)OCLUtilities.getAttributeValue(evaluator, eObject, "getId", (EClassifier)EcorePackage.Literals.ESTRING);
                String name = (String)OCLUtilities.getAttributeValue(evaluator, eObject, "getName", (EClassifier)EcorePackage.Literals.ESTRING);
                Section section = this.dataManager.createSection(id, name, "");
                this.sections.put(eObject, section);
                this.addToSection(requirementSource, eObject, (AbstractElement)section);
            }
            for (IType type : types) {
                if (!(type instanceof IRequirementType) || !OCLUtilities.isDataType(evaluator, eObject, (IRequirementType)type)) continue;
                AbstractElement requirement = this.createRequirement(evaluator, (Collection<MappingElement>)mapping, eObject, (IRequirementType)type);
                requirement.getScopes().add((Object)scope);
                this.addToSection(requirementSource, eObject, requirement);
            }
        }
    }

    private void addToSection(RequirementSource requirementSource, EObject eObject, AbstractElement current) {
        Section container = null;
        EObject tmp = eObject;
        while (container == null && tmp.eContainer() != null) {
            container = this.sections.get(tmp.eContainer());
            tmp = tmp.eContainer();
        }
        if (container == null) {
            this.dataManager.addElementsToSource(requirementSource, new AbstractElement[]{current});
        } else {
            this.dataManager.addElementsToSection(container, new AbstractElement[]{current});
        }
    }

    protected AbstractElement createRequirement(OCLEvaluator evaluator, Collection<MappingElement> mappings, EObject eObject, IRequirementType reqType) throws Exception {
        Requirement requirement = reqType.createInstance();
        for (IAttribute attribute : Iterables.filter((Iterable)reqType.getAttributes(), IAttribute.class)) {
            Object value = OCLUtilities.getAttributeValue(evaluator, eObject, attribute);
            if (value == null) continue;
            this.dataManager.addAttributeValue((AbstractElement)requirement, attribute, value);
        }
        return requirement;
    }
}

