/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.rmf.ui;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.polarsys.reqcycle.repository.connector.ui.wizard.MappingComposite;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.MappingDialogPage;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingAttribute;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingElement;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingModelFactory;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;

public abstract class RMFRepositoryMappingPage
extends WizardPage
implements Listener {
    private MappingComposite mappingComposite;
    private Button autoMappingBtn;
    static ITreeContentProvider contentProvider = new ITreeContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return ArrayContentProvider.getInstance().getElements(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }
    };

    public RMFRepositoryMappingPage(String title, String description) {
        super(title);
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createControl(final Composite parent) {
        this.mappingComposite = new MappingComposite(parent, 0, this){

            public MappingElement linkElements(Object sourceSelection, Object targetSelection) {
                return RMFRepositoryMappingPage.this.mapElements(parent, sourceSelection, targetSelection);
            }

            protected String getResultDetail() {
                return RMFRepositoryMappingPage.this.getResultDetail();
            }

            protected Object getTargetInput() {
                return RMFRepositoryMappingPage.this.getTargetInput();
            }

            protected Object getSourceInput() {
                return RMFRepositoryMappingPage.this.getSourceInput();
            }

            protected IContentProvider getSourceContentProvider() {
                return RMFRepositoryMappingPage.this.getSourceContentProvider();
            }

            protected IBaseLabelProvider getSourceLabelProvider() {
                return RMFRepositoryMappingPage.this.getSourceLabelProvider();
            }

            protected String getTargetDetail() {
                return RMFRepositoryMappingPage.this.getTargetDetail();
            }

            protected String getSourceDetail() {
                return RMFRepositoryMappingPage.this.getSourceDetail();
            }

            protected boolean getCanEditLink() {
                return false;
            }

            protected void init(Collection<EObject> result) {
                Collection<EObject> mapping = RMFRepositoryMappingPage.this.addToMapping();
                if (mapping != null && !mapping.isEmpty()) {
                    result.addAll(mapping);
                }
            }
        };
        this.autoMappingBtn = new Button((Composite)this.mappingComposite, 8);
        this.autoMappingBtn.setLayoutData((Object)new GridData(1, 1, false, false));
        this.autoMappingBtn.setText("Map using names");
        this.autoMappingBtn.setEnabled(true);
        this.hookListeners();
        this.setControl((Control)this.mappingComposite);
    }

    protected abstract Collection<EObject> addToMapping();

    protected abstract String getSourceDetail();

    protected abstract String getTargetDetail();

    protected abstract IBaseLabelProvider getSourceLabelProvider();

    protected abstract IContentProvider getSourceContentProvider();

    protected abstract Object getSourceInput();

    protected abstract Object getTargetInput();

    protected abstract String getResultDetail();

    private void hookListeners() {
        this.autoMappingBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RMFRepositoryMappingPage.this.generateMapping();
            }
        });
    }

    protected void generateMapping() {
        if (this.getSourceInput() instanceof Collection && this.getTargetInput() instanceof Collection) {
            for (Object inputElement : (Collection)this.getSourceInput()) {
                if (!(inputElement instanceof SpecType)) continue;
                final String inputName = ((SpecType)inputElement).getLongName();
                IRequirementType element = (IRequirementType)Iterators.find(((Collection)this.getTargetInput()).iterator(), (Predicate)new Predicate<IRequirementType>(){

                    public boolean apply(IRequirementType arg0) {
                        String ii = inputName;
                        return ii.equalsIgnoreCase(arg0.getName());
                    }
                }, null);
                if (element == null) continue;
                MappingElement elementMapping = MappingModelFactory.eINSTANCE.createMappingElement();
                Collection allAttributes = element.getAttributes();
                Collection filtered = Collections2.filter((Collection)allAttributes, (Predicate)new Predicate<IAttribute>(){

                    public boolean apply(IAttribute arg0) {
                        if (arg0 instanceof IAttribute) {
                            return !arg0.isHidden();
                        }
                        return false;
                    }
                });
                elementMapping.getAttributes().addAll(this.mapAttributes((Collection<AttributeDefinition>)((SpecType)inputElement).getSpecAttributes(), filtered));
                elementMapping.setSourceQualifier(((SpecType)inputElement).getIdentifier());
                elementMapping.setDescription(((SpecType)inputElement).getLongName());
                elementMapping.setTargetElement((EClass)element);
                if (this.mappingComposite == null) continue;
                this.mappingComposite.addToResult((EObject)elementMapping);
            }
        }
    }

    private Collection<MappingAttribute> mapAttributes(Collection<AttributeDefinition> source, Collection<IAttribute> target) {
        HashSet result = Sets.newHashSet();
        for (final AttributeDefinition attribute : source) {
            IAttribute element = (IAttribute)Iterators.find(target.iterator(), (Predicate)new Predicate<IAttribute>(){

                public boolean apply(IAttribute arg0) {
                    String name = attribute.getLongName();
                    return arg0.getName().equalsIgnoreCase(name);
                }
            });
            EAttribute eAttribute = null;
            if (element instanceof IAdaptable) {
                eAttribute = (EAttribute)((IAdaptable)element).getAdapter(EAttribute.class);
            }
            if (eAttribute == null) continue;
            MappingAttribute attributeMapping = MappingModelFactory.eINSTANCE.createMappingAttribute();
            attributeMapping.setTargetAttribute(eAttribute);
            attributeMapping.setSourceId(attribute.getIdentifier());
            attributeMapping.setDescription(attribute.getLongName());
            result.add(attributeMapping);
        }
        return result;
    }

    private MappingElement mapElements(Composite parent, Object sourceSelection, final Object targetSelection) {
        if (targetSelection instanceof IRequirementType && sourceSelection instanceof SpecType) {
            final SpecType specType = (SpecType)sourceSelection;
            MappingDialogPage mappingDialog = new MappingDialogPage(parent.getShell()){

                protected MappingAttribute linkElements(Object sourceSelection, Object targetSelection2) {
                    if (sourceSelection instanceof AttributeDefinition && targetSelection2 instanceof IAttribute) {
                        EAttribute eAttribute = null;
                        if (targetSelection2 instanceof IAdaptable) {
                            eAttribute = (EAttribute)((IAdaptable)targetSelection2).getAdapter(EAttribute.class);
                        }
                        if (eAttribute == null) {
                            return null;
                        }
                        MappingAttribute attributeMapping = MappingModelFactory.eINSTANCE.createMappingAttribute();
                        attributeMapping.setTargetAttribute(eAttribute);
                        attributeMapping.setSourceId(((AttributeDefinition)sourceSelection).getIdentifier());
                        attributeMapping.setDescription(((AttributeDefinition)sourceSelection).getLongName());
                        return attributeMapping;
                    }
                    return null;
                }

                protected String getResultDetail() {
                    return null;
                }

                protected Object getTargetInput() {
                    Collection allAttributes = ((IRequirementType)targetSelection).getAttributes();
                    Collection filteredAttribute = Collections2.filter((Collection)allAttributes, (Predicate)new Predicate<IAttribute>(){

                        public boolean apply(IAttribute arg0) {
                            if (arg0 instanceof IAttribute) {
                                return !arg0.isHidden();
                            }
                            return false;
                        }
                    });
                    return filteredAttribute;
                }

                protected Object getSourceInput() {
                    return specType.getSpecAttributes();
                }

                protected boolean getCanEditLink() {
                    return false;
                }

                protected String getSourceDetail() {
                    return null;
                }

                protected String getTargetDetail() {
                    return null;
                }

                protected IContentProvider getSourceContentProvider() {
                    return contentProvider;
                }

                public ILabelProvider getSourceLabelProvider() {
                    return new LabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof AttributeDefinition) {
                                DatatypeDefinition dataTypeDef = ReqIF10Util.getDatatypeDefinition((AttributeDefinition)((AttributeDefinition)element));
                                return String.valueOf(((AttributeDefinition)element).getLongName()) + " : " + dataTypeDef.getClass().getSimpleName();
                            }
                            return super.getText(element);
                        }
                    };
                }
            };
            if (mappingDialog.open() == 0 && mappingDialog.getResult() != null) {
                EClass eClass = null;
                if (targetSelection instanceof IAdaptable) {
                    eClass = (EClass)((IAdaptable)targetSelection).getAdapter(EClass.class);
                }
                if (eClass == null) {
                    return null;
                }
                MappingElement element = MappingModelFactory.eINSTANCE.createMappingElement();
                element.getAttributes().addAll(mappingDialog.getResult());
                element.setSourceQualifier(specType.getIdentifier());
                element.setDescription(specType.getLongName());
                element.setTargetElement(eClass);
                return element;
            }
        }
        return null;
    }

    public boolean preFinish(RequirementSource repository) {
        return true;
    }

    public boolean isPageComplete() {
        return this.mappingComposite != null && this.mappingComposite.getResult() != null && !this.mappingComposite.getResult().isEmpty();
    }

    public Collection<EObject> getResult() {
        if (this.mappingComposite != null) {
            return this.mappingComposite.getResult();
        }
        return null;
    }

    public void handleEvent(Event event) {
    }
}

