/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.collect.yieldadapters;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.polarsys.reqcycle.utils.collect.Collector;
import org.polarsys.reqcycle.utils.collect.ResultHandler;
import org.polarsys.reqcycle.utils.collect.YieldAdapter;
import org.polarsys.reqcycle.utils.collect.YieldAdapterIterable;
import org.polarsys.reqcycle.utils.collect.YieldAdapterIterator;
import org.polarsys.reqcycle.utils.collect.exceptions.CannotHandleException;
import org.polarsys.reqcycle.utils.collect.exceptions.CollectionAbortedException;

public class SetYieldAdapter<T>
implements YieldAdapter<T> {
    @Override
    public YieldAdapterIterable<T> adapt(Collector<T> client) {
        final LinkedHashSet results = new LinkedHashSet();
        try {
            client.collect(new ResultHandler<T>(){

                @Override
                public void handleResult(T value) throws CannotHandleException {
                    if (!results.contains(value)) {
                        results.add(value);
                    }
                }
            });
        }
        catch (CollectionAbortedException collectionAbortedException) {}
        return new YieldAdapterIterable<T>(){

            @Override
            public YieldAdapterIterator<T> iterator() {
                final Iterator iterator = results.iterator();
                return new YieldAdapterIterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return iterator.next();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public void dispose() {
                    }
                };
            }
        };
    }
}

