/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.uri.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Singleton;
import org.polarsys.reqcycle.uri.IReachableListener;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.model.Reachable;

@Singleton
public class ReachableListenerManager
implements IReachableListenerManager {
    Multimap<Reachable, IReachableListener> mapReachableToListener = HashMultimap.create();
    Multimap<IReachableListener, Reachable> mapListenerToReachable = HashMultimap.create();
    boolean preventReentrant = false;

    @Override
    public void addReachableListener(Reachable reachable, IReachableListener listener) {
        this.put(this.mapReachableToListener, this.mapListenerToReachable, reachable, listener);
    }

    public <X, Y> void put(Multimap<X, Y> map, Multimap<Y, X> map2, X reachable, Y listener) {
        map.put(reachable, listener);
        map2.put(listener, reachable);
    }

    public <X, Y> void remove(Multimap<X, Y> map, Multimap<Y, X> map2, X reachable, Y listener) {
        map.remove(reachable, listener);
        map2.remove(listener, reachable);
    }

    @Override
    public synchronized void removeReachableListener(IReachableListener listener) {
        Collection reachables = this.mapListenerToReachable.removeAll((Object)listener);
        for (Reachable r : reachables) {
            this.mapReachableToListener.remove((Object)r, (Object)listener);
        }
    }

    @Override
    public synchronized void notifyChanged(Reachable[] reachables) {
        if (!this.preventReentrant) {
            this.preventReentrant = true;
            HashSet collection = Sets.newHashSet();
            Reachable[] copy = Arrays.copyOf(reachables, reachables.length);
            Reachable[] reachableArray = reachables;
            int n = reachables.length;
            int n2 = 0;
            while (n2 < n) {
                Reachable r = reachableArray[n2];
                collection.addAll(this.mapReachableToListener.get((Object)r));
                ++n2;
            }
            IReachableListener[] array = collection.toArray(new IReachableListener[collection.size()]);
            int i = 0;
            while (i < array.length) {
                array[i].hasChanged(this.filter(copy, this.mapListenerToReachable.get((Object)array[i])));
                ++i;
            }
        }
        this.preventReentrant = false;
    }

    private Reachable[] filter(Reachable[] reachables, Collection<Reachable> collection) {
        HashSet result = Sets.newHashSet();
        HashSet collection2 = Sets.newHashSet(collection);
        Reachable[] reachableArray = reachables;
        int n = reachables.length;
        int n2 = 0;
        while (n2 < n) {
            Reachable r = reachableArray[n2];
            if (collection2.contains(r)) {
                result.add(r);
            }
            ++n2;
        }
        return result.toArray(new Reachable[0]);
    }

    @Override
    public synchronized void removeReachableListener(IReachableListener listener, Reachable reachable) {
        this.remove(this.mapReachableToListener, this.mapListenerToReachable, reachable, listener);
    }
}

