/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.emf.word;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.polarsys.kitalpha.doc.doc2model.common.Common.CommonFactory;
import org.polarsys.kitalpha.doc.doc2model.common.Common.Style;
import org.polarsys.kitalpha.doc.doc2model.common.Common.StyleEnum;
import org.polarsys.kitalpha.doc.doc2model.core.ModelContentHandler;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Cell;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Image;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Paragraph;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Row;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Section;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.StringChunk;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Table;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Title;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.WPFile;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.WordprocessorFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class WPSAXContentHandler
implements ModelContentHandler<WPFile> {
    static final String TAG_HEAD = "head";
    static final String TAG_META = "meta";
    static final String TAG_PARAGRAPH = "p";
    static final String TAG_BOLD = "b";
    static final String TAG_TABLE = "table";
    static final String TAG_ROW = "tr";
    static final String TAG_CELL = "td";
    static final String TAG_IMG = "img";
    static final String ATT_NAME = "name";
    static final String ATT_CONTENT = "content";
    static final String ATT_CLASS = "class";
    static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    static final Pattern headingPattern = Pattern.compile("h(\\d)");
    private WordprocessorFactory _factory = WordprocessorFactory.eINSTANCE;
    private WPFile _wordFile;
    private Section _lastSection;
    private Stack<Section> _sectionsStack = new Stack();
    private Paragraph _lastParagraph;
    private Table _lastTable;
    private Row _lastRow;
    private Cell _lastCell;
    private Image _lastImage;
    private TagType _lastTagType = TagType.Default;
    private boolean _isBold = false;

    public void characters(char[] ch, int start, int length) throws SAXException {
        String charStr = new String(ch, start, length);
        switch (this._lastTagType) {
            case Section: {
                String title = this._lastSection.getTitle().getTextContent();
                this._lastSection.getTitle().setTextContent(String.valueOf(title) + charStr);
                break;
            }
            case Paragraph: {
                StringChunk strChk = this._factory.createStringChunk();
                strChk.setTextContent(charStr);
                if (this._isBold) {
                    this.setProperty(strChk, StyleEnum.BOLD);
                }
                this._isBold = false;
                this._lastParagraph.getChunks().add((Object)strChk);
                break;
            }
            case Table: {
                this._lastCell.setTextContent(String.valueOf(this._lastCell.getTextContent()) + charStr);
                break;
            }
        }
    }

    private void setProperty(StringChunk strChk, StyleEnum styleEnum) {
        Style s = strChk.getStyle();
        if (s == null) {
            s = CommonFactory.eINSTANCE.createStyle();
            strChk.setStyle(s);
        }
        s.getEnums().add((Object)styleEnum);
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals(TAG_TABLE)) {
            this._lastTagType = TagType.Default;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this._wordFile = this._factory.createWPFile();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Matcher m = headingPattern.matcher(localName);
        if (localName.equals(TAG_HEAD)) {
            this._lastSection = this._factory.createSection();
            this._lastSection.setHiearchy("0");
            Title mainTitle = this._factory.createTitle();
            mainTitle.setTextContent("Main Section");
            this._lastSection.setTitle(mainTitle);
            this._sectionsStack.add(this._lastSection);
            this._wordFile.setMainSection(this._lastSection);
        } else if (localName.equals(TAG_META)) {
            if (atts.getValue(ATT_NAME).equals("dc:title")) {
                this._wordFile.setName(atts.getValue(ATT_CONTENT));
            } else if (atts.getValue(ATT_NAME).equals("meta:author")) {
                this._wordFile.setAuthor(atts.getValue(ATT_CONTENT));
            } else if (atts.getValue(ATT_NAME).equals("meta:creation-date")) {
                try {
                    this._wordFile.setDate(dateFormat.parse(atts.getValue(ATT_CONTENT)));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        } else if (m.matches()) {
            this._lastSection = this._factory.createSection();
            this._lastSection.setHiearchy(m.group(1));
            Title title = this._factory.createTitle();
            this._lastSection.setTitle(title);
            while (!this._sectionsStack.isEmpty()) {
                Section _tmpSection = this._sectionsStack.peek();
                if (this._lastSection.getHiearchy().compareTo(_tmpSection.getHiearchy()) > 0) {
                    _tmpSection.getSections().add((Object)this._lastSection);
                    this._sectionsStack.add(this._lastSection);
                    break;
                }
                _tmpSection = this._sectionsStack.pop();
            }
            this._lastTagType = TagType.Section;
        } else if (localName.equals(TAG_PARAGRAPH)) {
            if (this._lastTagType != TagType.Table) {
                this._lastParagraph = this._factory.createParagraph();
                this._lastParagraph.setStyleName(atts.getValue(ATT_CLASS));
                this._lastSection.getContents().add((Object)this._lastParagraph);
                this._lastTagType = TagType.Paragraph;
            }
        } else if (localName.equals(TAG_BOLD)) {
            this._isBold = true;
        } else if (localName.equals(TAG_IMG)) {
            this._lastImage = this._factory.createImage();
            Title title = this._factory.createTitle();
            title.setTextContent(atts.getValue("src"));
            this._lastImage.setSubtitle(title);
            this._lastSection.getContents().add((Object)this._lastImage);
        } else if (localName.equals(TAG_TABLE)) {
            this._lastTable = this._factory.createTable();
            this._lastSection.getContents().add((Object)this._lastTable);
            this._lastTagType = TagType.Table;
        } else if (localName.equals(TAG_ROW)) {
            this._lastRow = this._factory.createRow();
            this._lastTable.getRow().add((Object)this._lastRow);
        } else if (localName.equals(TAG_CELL)) {
            this._lastCell = this._factory.createCell();
            this._lastCell.setTextContent("");
            this._lastRow.getCell().add((Object)this._lastCell);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public WPFile getResult() {
        return this._wordFile;
    }

    private static enum TagType {
        Section,
        Paragraph,
        Table,
        Default;

    }
}

