/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.predicates;

import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.types.ITraceabilityAttributesManager;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.RelationUtils;
import org.polarsys.reqcycle.traceability.types.configuration.predicates.EPackageCreationException;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Attribute;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ReqCycleDynamicPackage {
    private static final String PREFIX = "rAttributes";
    public static final String URI = "http://www.reqcycle.org/relations/attributes";
    public static final EDataType INTEGER = EcorePackage.Literals.EINT;
    public static final EDataType STRING = EcorePackage.Literals.ESTRING;
    public static final EDataType BOOLEAN = EcorePackage.Literals.EBOOLEAN;
    static ITypesConfigurationProvider provider = (ITypesConfigurationProvider)ZigguratInject.make(ITypesConfigurationProvider.class);
    private static ITraceabilityAttributesManager attributesManager = (ITraceabilityAttributesManager)ZigguratInject.make(ITraceabilityAttributesManager.class);

    public static void reinitURIPackage() {
        try {
            EPackage.Registry.INSTANCE.put((Object)URI, (Object)ReqCycleDynamicPackage.getEPackage());
        }
        catch (EPackageCreationException e) {
            e.printStackTrace();
        }
    }

    public static EPackage getEPackage() throws EPackageCreationException {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setNsURI(URI);
        ePackage.setNsPrefix(PREFIX);
        ePackage.setName("Relations_Attributes");
        Configuration c = provider.getDefaultConfiguration();
        if (c == null) {
            throw new EPackageCreationException("no default configuration");
        }
        for (Relation r : c.getRelations()) {
            ePackage.getEClassifiers().add((Object)ReqCycleDynamicPackage.getEClass(ePackage, r));
        }
        if (ePackage.eResource() == null) {
            Relation r;
            r = new EcoreResourceFactoryImpl().createResource(org.eclipse.emf.common.util.URI.createURI((String)URI));
            r.getContents().add((Object)ePackage);
        }
        return ePackage;
    }

    private static EClassifier getEClass(EPackage ePackage, Relation r) {
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName(r.getKind());
        for (Attribute a : r.getAttributes()) {
            eclass.getEStructuralFeatures().add((Object)ReqCycleDynamicPackage.getEAttribute(ePackage, a));
        }
        return eclass;
    }

    private static EAttribute getEAttribute(EPackage ePackage, Attribute a) {
        EAttribute att = EcoreFactory.eINSTANCE.createEAttribute();
        att.setName(a.getName());
        att.setEType(ReqCycleDynamicPackage.getType(ePackage, a));
        return att;
    }

    private static EClassifier getType(EPackage ePackage, Attribute a) {
        if (a.getPossibleValues().isEmpty()) {
            switch (a.getType()) {
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case INT: {
                    return INTEGER;
                }
                case STRING: {
                    return STRING;
                }
            }
            return STRING;
        }
        return ReqCycleDynamicPackage.getEnum(ePackage, a);
    }

    private static EClassifier getEnum(EPackage ePackage, Attribute a) {
        EEnum e = EcoreFactory.eINSTANCE.createEEnum();
        e.setName(a.getName());
        ePackage.getEClassifiers().add((Object)e);
        int i = 0;
        for (String s : a.getPossibleValues()) {
            EEnumLiteral l = EcoreFactory.eINSTANCE.createEEnumLiteral();
            l.setLiteral(s);
            l.setValue(i);
            e.getELiterals().add((Object)l);
            ++i;
        }
        return e;
    }

    public static EObject getEObject(Link link) {
        Configuration defaultConfiguration = provider.getDefaultConfiguration();
        if (defaultConfiguration == null) {
            return null;
        }
        Relation r = RelationUtils.getRelation((String)link.getKind().getLabel(), (Configuration)defaultConfiguration);
        if (r == null) {
            return null;
        }
        try {
            return ReqCycleDynamicPackage.getEObject(link, r, ReqCycleDynamicPackage.getEPackage());
        }
        catch (EPackageCreationException ePackageCreationException) {
            return null;
        }
    }

    private static EObject getEObject(Link link, Relation r, EPackage ePackage) {
        for (EClassifier c : ePackage.getEClassifiers()) {
            if (!c.getName().equals(r.getKind())) continue;
            return ReqCycleDynamicPackage.getEObject(link, r, (EClass)c);
        }
        return null;
    }

    private static EObject getEObject(Link link, Relation r, EClass c) {
        Collection attributes = attributesManager.getAttributes(link.getId());
        EObject e = c.getEPackage().getEFactoryInstance().create(c);
        block0: for (EAttribute a : c.getEAllAttributes()) {
            for (ITraceabilityAttributesManager.EditableAttribute att : attributes) {
                if (!a.getName().equals(att.getName())) continue;
                Object val = ReqCycleDynamicPackage.getVal(link, a, att);
                e.eSet((EStructuralFeature)a, val);
                continue block0;
            }
        }
        return e;
    }

    private static Object getVal(Link link, EAttribute a, ITraceabilityAttributesManager.EditableAttribute att) {
        Object val = att.getValue();
        if (att.getPossibleValues() == null || att.getPossibleValues().length == 0) {
            return val;
        }
        return ReqCycleDynamicPackage.getEnumValue(val, a.getEType());
    }

    private static Object getEnumValue(Object val, EClassifier eType) {
        if (val instanceof String) {
            String stringVal = (String)val;
            if (eType instanceof EEnum) {
                EEnum enumeration = (EEnum)eType;
                for (EEnumLiteral l : enumeration.getELiterals()) {
                    if (!l.getLiteral().equals(stringVal)) continue;
                    return l;
                }
            }
        }
        return null;
    }
}

